/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.categories;

import eu.udig.catalog.jgrass.activeregion.dialogs.JGRasterChooserDialog;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.style.jgrass.JGrassrasterStyleActivator;
import eu.udig.style.jgrass.categories.CategoryRule;
import eu.udig.style.jgrass.categories.CategoryRuleComposite;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.Layer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CategoryEditor
extends Composite
implements SelectionListener {
    private ArrayList<CategoryRule> listOfRules = new ArrayList();
    private Button addRuleButton = null;
    private Button removeRuleButton = null;
    private Button moveRuleUpButton = null;
    private Button moveRuleDownButton = null;
    private Composite rulesComposite = null;
    private ScrolledComposite scrolledRulesComposite = null;
    private Layer layer;
    private String[] mapsetPathAndMapName;
    private File catsFile;
    private final Label alphaLabel = null;
    private Button loadFromFileButton = null;
    private Button loadFromMapButton = null;

    public CategoryEditor(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData21 = new GridData();
        gridData21.horizontalSpan = 2;
        gridData21.verticalAlignment = 2;
        gridData21.horizontalAlignment = 4;
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.horizontalSpan = 2;
        gridData11.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.addRuleButton = new Button((Composite)this, 0);
        this.addRuleButton.setText("+");
        this.addRuleButton.setLayoutData((Object)gridData);
        this.addRuleButton.addSelectionListener((SelectionListener)this);
        this.removeRuleButton = new Button((Composite)this, 0);
        this.removeRuleButton.setText("-");
        this.removeRuleButton.setLayoutData((Object)gridData1);
        this.removeRuleButton.addSelectionListener((SelectionListener)this);
        this.moveRuleUpButton = new Button((Composite)this, 132);
        this.moveRuleUpButton.setLayoutData((Object)gridData2);
        this.moveRuleUpButton.addSelectionListener((SelectionListener)this);
        this.moveRuleDownButton = new Button((Composite)this, 1028);
        this.moveRuleDownButton.setLayoutData((Object)gridData3);
        this.moveRuleDownButton.addSelectionListener((SelectionListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
        this.createScrolledRulesComposite();
        this.loadFromFileButton = new Button((Composite)this, 0);
        this.loadFromFileButton.setText("load from file");
        this.loadFromFileButton.setLayoutData((Object)gridData11);
        this.loadFromFileButton.addSelectionListener((SelectionListener)this);
        this.loadFromMapButton = new Button((Composite)this, 0);
        this.loadFromMapButton.setText("load from map");
        this.loadFromMapButton.setLayoutData((Object)gridData21);
        this.loadFromMapButton.addSelectionListener((SelectionListener)this);
        this.createRulesComposite();
    }

    private void createRulesComposite() {
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 4;
        gridData4.verticalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.horizontalAlignment = 4;
        this.rulesComposite = new Composite((Composite)this.scrolledRulesComposite, 0);
        this.rulesComposite.setLayout((Layout)new GridLayout());
        this.rulesComposite.setLayoutData((Object)gridData4);
        this.scrolledRulesComposite.setContent((Control)this.rulesComposite);
    }

    private void createScrolledRulesComposite() {
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 4;
        gridData7.verticalAlignment = 4;
        gridData7.grabExcessVerticalSpace = true;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.horizontalAlignment = 4;
        this.scrolledRulesComposite = new ScrolledComposite((Composite)this, 2560);
        this.scrolledRulesComposite.setLayoutData((Object)gridData7);
        this.scrolledRulesComposite.setAlwaysShowScrollBars(true);
        this.scrolledRulesComposite.setExpandHorizontal(true);
        this.scrolledRulesComposite.setExpandVertical(true);
        this.scrolledRulesComposite.setMinSize(300, 500);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button selectedButton = (Button)e.getSource();
        if (selectedButton.equals(this.addRuleButton)) {
            CategoryRule r = new CategoryRule();
            this.listOfRules.add(r);
            this.redoLayout();
        } else if (selectedButton.equals(this.removeRuleButton)) {
            int i = 0;
            while (i < this.listOfRules.size()) {
                CategoryRule r = this.listOfRules.get(i);
                if (r.isActive()) {
                    this.listOfRules.remove(r);
                }
                ++i;
            }
            this.redoLayout();
        } else if (selectedButton.equals(this.moveRuleUpButton)) {
            int i = 0;
            while (i < this.listOfRules.size()) {
                CategoryRule r = this.listOfRules.get(i);
                if (r.isActive() && i > 0) {
                    this.listOfRules.remove(r);
                    this.listOfRules.add(i - 1, r);
                }
                ++i;
            }
            this.redoLayout();
        } else if (selectedButton.equals(this.moveRuleDownButton)) {
            int i = 0;
            while (i < this.listOfRules.size()) {
                CategoryRule r = this.listOfRules.get(i);
                if (r.isActive() && i < this.listOfRules.size() - 1) {
                    this.listOfRules.remove(r);
                    this.listOfRules.add(i + 1, r);
                    ++i;
                }
                ++i;
            }
            this.redoLayout();
        } else if (selectedButton.equals(this.loadFromFileButton)) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            String path = fileDialog.open();
            if (path == null) {
                return;
            }
            this.makeSomeCategories(path);
        } else if (selectedButton.equals(this.loadFromMapButton)) {
            JGRasterChooserDialog tree = new JGRasterChooserDialog(null);
            tree.open(this.getShell(), 4);
            this.update(tree.getSelectedResources());
        }
    }

    /*
     * Exception decompiling
     */
    public void makeSomeCategories(String catspath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        IGeoResource resource = layer.getGeoResource();
        this.mapsetPathAndMapName = JGrassCatalogUtilities.getMapsetpathAndMapnameFromJGrassMapGeoResource((IGeoResource)resource);
        this.catsFile = new File(String.valueOf(this.mapsetPathAndMapName[0]) + File.separator + "cats" + File.separator + this.mapsetPathAndMapName[1]);
    }

    public void setRulesList(ArrayList<CategoryRule> listOfRules) {
        this.listOfRules = listOfRules;
        this.redoLayout();
    }

    protected void redoLayout() {
        Control[] rulesControls = this.rulesComposite.getChildren();
        int i = 0;
        while (i < rulesControls.length) {
            rulesControls[i].dispose();
            ++i;
        }
        for (CategoryRule rule : this.listOfRules) {
            new CategoryRuleComposite(this.rulesComposite, 2048, rule);
        }
        this.rulesComposite.layout();
    }

    public void makePersistent() {
        BufferedWriter bw = null;
        if (this.catsFile != null) {
            try {
                bw = new BufferedWriter(new FileWriter(this.catsFile));
                if (this.listOfRules.size() == 0) {
                    return;
                }
                try {
                    StringBuffer header = new StringBuffer();
                    header.append("# " + this.listOfRules.size() + "\n");
                    header.append(String.valueOf(this.mapsetPathAndMapName[1]) + "\n");
                    header.append("\n");
                    header.append("0.00 0.00 0.00 0.00\n");
                    bw.write(header.toString());
                    for (CategoryRule r : this.listOfRules) {
                        if (!r.isActive()) continue;
                        bw.write(String.valueOf(r.ruleToString()) + "\n");
                    }
                }
                catch (IOException e1) {
                    JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e1);
                    e1.printStackTrace();
                }
            }
            finally {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e);
                }
            }
        }
    }

    public void update(Object updatedObject) {
        if (updatedObject instanceof List) {
            String mapName = null;
            String mapsetPath = null;
            List layers = (List)updatedObject;
            for (Object layer : layers) {
                if (!(layer instanceof JGrassMapGeoResource)) continue;
                JGrassMapGeoResource rasterMapResource = (JGrassMapGeoResource)layer;
                try {
                    mapName = rasterMapResource.getInfo(null).getTitle();
                    mapsetPath = ((JGrassMapsetGeoResource)rasterMapResource.parent(null)).getFile().getAbsolutePath();
                    if (mapName == null || mapsetPath == null) continue;
                    String catsPath = String.valueOf(mapsetPath) + File.separator + "cats" + File.separator + mapName;
                    this.makeSomeCategories(catsPath);
                }
                catch (IOException e) {
                    JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e);
                    e.printStackTrace();
                }
            }
        }
    }
}

