/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public enum Keywords {
    CONSTANTS("keywords/constants.txt"),
    GEOSCRIPT("keywords/geoscript.txt"),
    METHODS("keywords/methods.txt"),
    KEYWORDS("keywords/keywords.txt"),
    OMS("keywords/oms.txt"),
    TYPES("keywords/types.txt"),
    IMPORTS("keywords/imports.txt"),
    JGTMODULES("keywords/jgt_classes.txt"),
    JGTMETHODS("keywords/jgt_methods.txt");

    private static HashMap<String, List<String>> keywordsMap;
    private final String path;

    static {
        keywordsMap = new HashMap();
    }

    private Keywords(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public static List<String> getValues(Keywords keyword) {
        List<String> stringsList = keywordsMap.get(keyword.toString());
        if (stringsList == null) {
            stringsList = Keywords.getStrings(keyword);
            keywordsMap.put(keyword.toString(), stringsList);
        }
        return stringsList;
    }

    private static List<String> getStrings(Keywords keyword) {
        ArrayList<String> stringsList = new ArrayList<String>();
        String keyPath = keyword.getPath();
        URL keyUrl = Platform.getBundle((String)"eu.udig.jconsole").getResource(keyPath);
        try {
            String realKeyPath = FileLocator.toFileURL((URL)keyUrl).getPath();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(realKeyPath));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    stringsList.add(line);
                }
            }
            finally {
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringsList;
    }
}

