/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageCache {
    public static final String START = "icons/start.gif";
    public static final String STOP = "icons/stop.gif";
    public static final String TEMPLATE = "icons/template.gif";
    private static ImageCache imageCache;
    private HashMap<String, Image> imageMap = new HashMap();

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (imageCache == null) {
            imageCache = new ImageCache();
        }
        return imageCache;
    }

    public Image getImage(String key) {
        Image image = this.imageMap.get(key);
        if (image == null) {
            image = this.createImage(key);
            this.imageMap.put(key, image);
        }
        return image;
    }

    private Image createImage(String key) {
        ImageDescriptor id = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.jconsole", (String)key);
        Image image = id.createImage();
        return image;
    }

    public void dispose() {
        Set<Map.Entry<String, Image>> entrySet = this.imageMap.entrySet();
        for (Map.Entry<String, Image> entry : entrySet) {
            entry.getValue().dispose();
        }
        this.imageMap.clear();
    }
}

