/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole.java;

import eu.udig.jconsole.util.JavaColorProvider;
import eu.udig.jconsole.util.JavaWhitespaceDetector;
import eu.udig.jconsole.util.JavaWordDetector;
import eu.udig.jconsole.util.Keywords;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JavaCodeScanner
extends RuleBasedScanner {
    private static List<String> moduleFieldsNameList = new ArrayList<String>();
    private static List<String> moduleClassesNameList = new ArrayList<String>();

    public JavaCodeScanner(JavaColorProvider provider) {
        Token string = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.SINGLE_LINE_COMMENT)));
        Token keywordTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.KEYWORD), null, 1));
        Token methodTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.METHOD), null, 2));
        Token typeTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.TYPE)));
        Token constantsTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.CONSTANTS)));
        Token geoscriptTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.GEOSCRIPT), null, 1));
        Token other = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.DEFAULT)));
        Token modulesFieldsTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.MODULES_FIELDS)));
        Token omsComponentsTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.OMS_COMPONENTS)));
        Token omsModulesTok = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.OMS_MODULES)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new MultiLineRule("\"\"\"", "\"\"\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), (IToken)other);
        List<String> keywords = Keywords.getValues(Keywords.KEYWORDS);
        int i = 0;
        while (i < keywords.size()) {
            wordRule.addWord(keywords.get(i), (IToken)keywordTok);
            ++i;
        }
        List<String> types = Keywords.getValues(Keywords.TYPES);
        int i2 = 0;
        while (i2 < types.size()) {
            wordRule.addWord(types.get(i2), (IToken)typeTok);
            ++i2;
        }
        List<String> constants = Keywords.getValues(Keywords.CONSTANTS);
        int i3 = 0;
        while (i3 < constants.size()) {
            wordRule.addWord(constants.get(i3), (IToken)constantsTok);
            ++i3;
        }
        List<String> geoscript = Keywords.getValues(Keywords.GEOSCRIPT);
        int i4 = 0;
        while (i4 < geoscript.size()) {
            wordRule.addWord(geoscript.get(i4), (IToken)geoscriptTok);
            ++i4;
        }
        List<String> jgtModules = Keywords.getValues(Keywords.JGTMODULES);
        int i5 = 0;
        while (i5 < jgtModules.size()) {
            wordRule.addWord(jgtModules.get(i5), (IToken)geoscriptTok);
            ++i5;
        }
        List<String> method = Keywords.getValues(Keywords.METHODS);
        int i6 = 0;
        while (i6 < method.size()) {
            wordRule.addWord(method.get(i6), (IToken)methodTok);
            ++i6;
        }
        List<String> jgt_method = Keywords.getValues(Keywords.JGTMETHODS);
        int i7 = 0;
        while (i7 < jgt_method.size()) {
            wordRule.addWord(jgt_method.get(i7), (IToken)methodTok);
            ++i7;
        }
        List<String> oms = Keywords.getValues(Keywords.OMS);
        int i8 = 0;
        while (i8 < oms.size()) {
            wordRule.addWord(oms.get(i8), (IToken)omsComponentsTok);
            ++i8;
        }
        for (String moduleFieldsName : moduleFieldsNameList) {
            wordRule.addWord(moduleFieldsName, (IToken)modulesFieldsTok);
        }
        for (String moduleClassesName : moduleClassesNameList) {
            wordRule.addWord(moduleClassesName, (IToken)omsModulesTok);
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

