/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole.actions;

import eu.udig.jconsole.JConsolePlugin;
import eu.udig.jconsole.JavaFileEditorInput;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ConsoleEditorActionNew
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        try {
            File f;
            File lastOpenFolder = JConsolePlugin.getDefault().getLastOpenFolder();
            FileDialog fileDialog = new FileDialog(this.window.getShell(), 8192);
            fileDialog.setText("Save the new script...");
            fileDialog.setFilterExtensions(new String[]{"*.groovy"});
            fileDialog.setFilterPath(lastOpenFolder.getAbsolutePath());
            String path = fileDialog.open();
            if (path == null || path.length() < 1) {
                return;
            }
            if (!path.endsWith(".groovy")) {
                path = String.valueOf(path) + ".groovy";
            }
            if (!(f = new File(path)).getParentFile().exists()) {
                return;
            }
            if (!f.exists()) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write("");
                bw.flush();
                bw.close();
            }
            File parentFolder = f.getParentFile();
            JConsolePlugin.getDefault().setLastOpenFolder(parentFolder.getAbsolutePath());
            JavaFileEditorInput jFile = new JavaFileEditorInput(f);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)jFile, "eu.udig.jconsole.editor");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

