/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole;

import eu.udig.jconsole.JConsolePlugin;
import eu.udig.jconsole.JavaContentOutlinePage;
import eu.udig.jconsole.JavaEditorDocumentProvider;
import eu.udig.jconsole.JavaEditorMessages;
import eu.udig.jconsole.JavaFileEditorInput;
import eu.udig.jconsole.JavaSourceViewerConfiguration;
import eu.udig.jconsole.util.ImageCache;
import eu.udig.jconsole.util.Keywords;
import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.IProcessListener;
import eu.udig.omsbox.core.JConsoleOutputConsole;
import eu.udig.omsbox.core.OmsScriptExecutor;
import eu.udig.omsbox.ui.RunningProcessListDialog;
import eu.udig.omsbox.utils.OmsBoxConstants;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.internal.ui.UDigByteAndLocalTransfer;
import net.refractions.udig.project.internal.impl.LayerImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.joda.time.DateTime;

public class JavaEditor
extends TextEditor {
    public static final String ID = "eu.udig.jconsole.editor";
    private JavaContentOutlinePage fOutlinePage;
    private ProjectionSupport fProjectionSupport;
    private JConsoleOutputConsole outputConsole;
    private TextTransfer textTransfer;
    private FileTransfer fileTransfer;
    private URLTransfer urlTransfer;
    private UDigByteAndLocalTransfer udigTransfer;
    private static final String CONTENTASSIST_PROPOSAL_ID = "eu.udig.jconsole.java.JavaCompletionProcessor";
    private Process process;
    private String filePath;
    private DropTargetListener dropTargetListener = new DropTargetAdapter(){

        public void drop(DropTargetEvent event) {
            File file;
            String[] files;
            if (JavaEditor.this.textTransfer.isSupportedType(event.currentDataType)) {
                String text = (String)event.data;
                System.out.println(text);
            }
            if (JavaEditor.this.fileTransfer.isSupportedType(event.currentDataType) && (files = (String[])event.data).length > 0 && (file = new File(files[0])).exists()) {
                JavaEditor.this.pasteDropContent(file);
                JConsolePlugin.getDefault().setLastOpenFolder(file.getParentFile().getAbsolutePath());
            }
            if (JavaEditor.this.urlTransfer.isSupportedType(event.currentDataType)) {
                Object data2 = event.data;
                System.out.println(data2);
            }
            if (JavaEditor.this.udigTransfer.isSupportedType(event.currentDataType)) {
                try {
                    Object data = event.data;
                    if (data instanceof TreeSelection) {
                        ID id;
                        IService service;
                        List resources;
                        TreeSelection selection = (TreeSelection)data;
                        Object firstElement = selection.getFirstElement();
                        IGeoResource geoResource = null;
                        if (firstElement instanceof LayerImpl) {
                            LayerImpl layer = (LayerImpl)firstElement;
                            geoResource = layer.getGeoResource();
                        }
                        if (firstElement instanceof IService && (resources = (service = (IService)firstElement).resources((IProgressMonitor)new NullProgressMonitor())).size() > 0) {
                            geoResource = (IGeoResource)resources.get(0);
                        }
                        if (geoResource != null && (id = geoResource.getID()) != null) {
                            if (id.isFile()) {
                                File file2 = id.toFile();
                                if (file2.exists()) {
                                    JavaEditor.this.pasteDropContent(file2);
                                    JConsolePlugin.getDefault().setLastOpenFolder(file2.getParentFile().getAbsolutePath());
                                }
                            } else if (id.toString().contains("#") && id.toString().startsWith("file")) {
                                String string = id.toString().replaceAll("#", "");
                                URL url = new URL(string);
                                File file3 = new File(url.toURI());
                                if (file3.exists()) {
                                    JavaEditor.this.pasteDropContent(file3);
                                    JConsolePlugin.getDefault().setLastOpenFolder(file3.getParentFile().getAbsolutePath());
                                }
                            } else {
                                System.out.println("Not a file: " + id.toString());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public JavaEditor() {
        this.setDocumentProvider((IDocumentProvider)new JavaEditorDocumentProvider());
        this.outputConsole = new JConsoleOutputConsole(null);
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public JConsoleOutputConsole getOutputConsole() {
        return this.outputConsole;
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = JavaEditorMessages.getResourceBundle();
        TextOperationAction action = new TextOperationAction(bundle, "ContentAssistProposal", (ITextEditor)this, 13);
        action.setActionDefinitionId(CONTENTASSIST_PROPOSAL_ID);
        this.setAction(CONTENTASSIST_PROPOSAL_ID, (IAction)action);
        this.setActionActivationCode(CONTENTASSIST_PROPOSAL_ID, ' ', -1, 262144);
    }

    public void dispose() {
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.outputConsole});
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input instanceof JavaFileEditorInput) {
            JavaFileEditorInput javaFile = (JavaFileEditorInput)input;
            this.filePath = javaFile.getAbsolutePath();
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(input);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "ContentAssistProposal");
        this.addAction(menu, "ContentAssistTip");
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new JavaContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration(new JavaSourceViewerConfiguration());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComposite.setLayout((Layout)mainLayout);
        this.addEditorActions(mainComposite);
        Composite editorComposite = new Composite(mainComposite, 2048);
        editorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout editorLayout = new FillLayout();
        editorLayout.marginHeight = 0;
        editorLayout.marginWidth = 0;
        editorComposite.setLayout((Layout)editorLayout);
        super.createPartControl(editorComposite);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        viewer.doOperation(19);
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        StyledText st = viewer.getTextWidget();
        this.textTransfer = TextTransfer.getInstance();
        this.fileTransfer = FileTransfer.getInstance();
        this.urlTransfer = URLTransfer.getInstance();
        this.udigTransfer = UDigByteAndLocalTransfer.getInstance();
        Transfer[] types = new Transfer[]{this.fileTransfer, this.textTransfer, this.urlTransfer, this.udigTransfer};
        dndService.addMergedDropTarget((Control)st, 19, types, this.dropTargetListener);
    }

    private void addEditorActions(Composite mainComposite) {
        Composite buttonsComposite = new Composite(mainComposite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout buttonsLayout = new GridLayout(6, false);
        buttonsLayout.marginTop = 1;
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginWidth = 1;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        Button startButton = new Button(buttonsComposite, 8);
        startButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        startButton.setToolTipText("Start the current script");
        startButton.setImage(ImageCache.getInstance().getImage("icons/start.gif"));
        startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaEditor.this.startScript();
            }
        });
        Button stopButton = new Button(buttonsComposite, 8);
        stopButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        stopButton.setToolTipText("Stop a running script");
        stopButton.setImage(ImageCache.getInstance().getImage("icons/stop.gif"));
        stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaEditor.this.stopScript();
            }
        });
        Button templateButton = new Button(buttonsComposite, 8);
        templateButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        templateButton.setToolTipText("Insert commonly used imports");
        templateButton.setImage(ImageCache.getInstance().getImage("icons/template.gif"));
        templateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaEditor.this.insertTemplates();
            }
        });
        Label spacer = new Label(buttonsComposite, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Combo heapCombo = new Combo(buttonsComposite, 4);
        heapCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        heapCombo.setItems(OmsBoxConstants.HEAPLEVELS);
        heapCombo.setToolTipText("Memory [MB]");
        int savedHeapLevel = OmsBoxPlugin.getDefault().retrieveSavedHeap();
        int i = 0;
        while (i < OmsBoxConstants.HEAPLEVELS.length) {
            if (OmsBoxConstants.HEAPLEVELS[i].equals(String.valueOf(savedHeapLevel))) {
                heapCombo.select(i);
                break;
            }
            ++i;
        }
        heapCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String item = heapCombo.getText();
                OmsBoxPlugin.getDefault().saveHeap(Integer.parseInt(item));
            }
        });
        heapCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String item = heapCombo.getText();
                try {
                    Integer.parseInt(item);
                }
                catch (Exception exception) {
                    return;
                }
                if (item.length() > 0) {
                    OmsBoxPlugin.getDefault().saveHeap(Integer.parseInt(item));
                }
            }
        });
        final Combo logCombo = new Combo(buttonsComposite, 12);
        logCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        logCombo.setItems(OmsBoxConstants.LOGLEVELS_GUI);
        logCombo.setToolTipText("Enable/disable logging");
        String savedLogLevel = OmsBoxPlugin.getDefault().retrieveSavedLogLevel();
        int i2 = 0;
        while (i2 < OmsBoxConstants.LOGLEVELS_GUI.length) {
            if (OmsBoxConstants.LOGLEVELS_GUI[i2].equals(savedLogLevel)) {
                logCombo.select(i2);
                break;
            }
            ++i2;
        }
        logCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String item = logCombo.getText();
                OmsBoxPlugin.getDefault().saveLogLevel(item);
            }
        });
    }

    private void pasteDropContent(File file) {
        String path = file.getAbsolutePath();
        try {
            IDocumentProvider dp = this.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)this.getEditorInput());
            ISelectionProvider selectionProvider = this.getSelectionProvider();
            ISelection selection = selectionProvider.getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                doc.replace(offset, 0, path);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void adjustHighlightRange(int offset, int length) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        }
    }

    private void insertTemplates() {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = doc.get();
        StringBuilder sb = new StringBuilder();
        List<String> values = Keywords.getValues(Keywords.IMPORTS);
        for (String value : values) {
            sb.append(value).append("\n");
        }
        StringBuilder finalSb = new StringBuilder();
        finalSb.append(sb.toString());
        finalSb.append("\n");
        finalSb.append(text);
        doc.set(finalSb.toString());
    }

    private void stopScript() {
        HashMap runningProcessesMap = OmsBoxPlugin.getDefault().getRunningProcessesMap();
        Shell shell = this.getEditorSite().getShell();
        if (runningProcessesMap.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"Process List", (String)"No running processes available at the current time");
        } else {
            RunningProcessListDialog dialog = new RunningProcessListDialog();
            dialog.open(shell, 2);
        }
    }

    private void startScript() {
        ITextSelection textSelection;
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = null;
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && !(textSelection = (ITextSelection)selection).isEmpty() && (text = textSelection.getText()).trim().length() > 0 && !text.trim().startsWith("import")) {
            StringBuilder sb = new StringBuilder();
            List<String> defaultImports = Keywords.getValues(Keywords.IMPORTS);
            for (String defaultImport : defaultImports) {
                sb.append(defaultImport).append("\n");
            }
            sb.append(text);
            text = sb.toString();
        }
        if (text == null || text.length() <= 0) {
            text = doc.get();
        }
        String dateTimeString = new DateTime().toString(OmsBoxConstants.dateTimeFormatterYYYYMMDDHHMMSS);
        String title = this.getTitle();
        JConsoleOutputConsole outputConsole = new JConsoleOutputConsole("Script: " + title + " (" + dateTimeString + " )");
        outputConsole.clearConsole();
        PrintStream internalStream = outputConsole.internal;
        PrintStream errorStream = outputConsole.err;
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{outputConsole});
        manager.showConsoleView((IConsole)outputConsole);
        try {
            final String scriptID = "geoscript_" + dateTimeString;
            OmsScriptExecutor executor = new OmsScriptExecutor();
            String loggerLevelGui = OmsBoxPlugin.getDefault().retrieveSavedLogLevel();
            String ramLevel = String.valueOf(OmsBoxPlugin.getDefault().retrieveSavedHeap());
            executor.addProcessListener(new IProcessListener(){

                public void onProcessStopped() {
                    OmsBoxPlugin.getDefault().cleanProcess(scriptID);
                }
            });
            Process process = executor.exec(text, internalStream, errorStream, loggerLevelGui, ramLevel);
            OmsBoxPlugin.getDefault().addProcess(process, scriptID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

