/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole;

import eu.udig.jconsole.JavaPartitionScanner;
import eu.udig.jconsole.java.JavaCodeScanner;
import eu.udig.jconsole.javadoc.JavaDocScanner;
import eu.udig.jconsole.util.JavaColorProvider;
import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.core.OmsModulesManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JConsolePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.udig.jconsole";
    public static final String JAVA_PARTITIONING = "__java_example_partitioning";
    public static final String LAST_FOLDER_KEY = "LAST_FOLDER_KEY";
    private JavaPartitionScanner fPartitionScanner;
    private JavaColorProvider fColorProvider;
    private JavaCodeScanner fCodeScanner;
    private JavaDocScanner fDocScanner;
    private static JConsolePlugin plugin;
    private String loggerLevel = "OFF";
    private String ram = "512";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JConsolePlugin getDefault() {
        return plugin;
    }

    public JavaPartitionScanner getJavaPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new JavaPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public RuleBasedScanner getJavaCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new JavaCodeScanner(this.getJavaColorProvider());
        }
        return this.fCodeScanner;
    }

    public JavaColorProvider getJavaColorProvider() {
        if (this.fColorProvider == null) {
            this.fColorProvider = new JavaColorProvider();
        }
        return this.fColorProvider;
    }

    public RuleBasedScanner getJavaDocScanner() {
        if (this.fDocScanner == null) {
            this.fDocScanner = new JavaDocScanner(this.fColorProvider);
        }
        return this.fDocScanner;
    }

    public File getLastOpenFolder() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String path = preferenceStore.getString(LAST_FOLDER_KEY);
        File file = new File(path);
        if (!file.exists()) {
            file = new File(System.getProperty("java.home"));
        }
        return file;
    }

    public void setLastOpenFolder(String path) {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.putValue(LAST_FOLDER_KEY, path);
    }

    public void setLoggerLevel(String level) {
        this.loggerLevel = level;
    }

    public String getLoggerLevel() {
        return this.loggerLevel;
    }

    public void setRam(String ram) {
        this.ram = ram;
    }

    public String getRam() {
        return this.ram;
    }

    public HashMap<String, List<ModuleDescription>> gatherModules() {
        HashMap availableModules = OmsModulesManager.getInstance().browseModules(false);
        return availableModules;
    }

    public String[] getModulesFieldsNames() {
        HashMap<String, List<ModuleDescription>> availableModules = this.gatherModules();
        ArrayList<String> names = new ArrayList<String>();
        Collection<List<ModuleDescription>> modulesDescriptions = availableModules.values();
        for (List<ModuleDescription> modulesDescriptionList : modulesDescriptions) {
            for (ModuleDescription moduleDescription : modulesDescriptionList) {
                List inputsList = moduleDescription.getInputsList();
                for (FieldData inFieldData : inputsList) {
                    names.add(inFieldData.fieldName);
                }
                List outputsList = moduleDescription.getOutputsList();
                for (FieldData outFieldData : outputsList) {
                    names.add(outFieldData.fieldName);
                }
            }
        }
        return names.toArray(new String[0]);
    }

    public LinkedHashMap<String, List<String>> modulesName2FieldsNames() {
        HashMap<String, List<ModuleDescription>> availableModules = this.gatherModules();
        LinkedHashMap<String, List<String>> modulesName2FieldsNames = new LinkedHashMap<String, List<String>>();
        Collection<List<ModuleDescription>> modulesDescriptions = availableModules.values();
        for (List<ModuleDescription> modulesDescriptionList : modulesDescriptions) {
            for (ModuleDescription moduleDescription : modulesDescriptionList) {
                String moduleName = moduleDescription.getName();
                ArrayList<String> names = new ArrayList<String>();
                List inputsList = moduleDescription.getInputsList();
                for (FieldData inFieldData : inputsList) {
                    names.add(inFieldData.fieldName);
                }
                List outputsList = moduleDescription.getOutputsList();
                for (FieldData outFieldData : outputsList) {
                    names.add(outFieldData.fieldName);
                }
                modulesName2FieldsNames.put(moduleName, names);
            }
        }
        return modulesName2FieldsNames;
    }
}

