/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select.internal;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import net.refractions.udig.project.ui.tool.AbstractActionTool;
import net.refractions.udig.tool.select.SelectPlugin;
import net.refractions.udig.ui.ProgressManager;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ZoomSelection
extends AbstractActionTool {
    public static final String ID = "net.refractions.udig.tool.default.show.selection";

    public void run() {
        ILayer layer = this.getContext().getSelectedLayer();
        if (layer.hasResource(SimpleFeatureSource.class)) {
            try {
                ReferencedEnvelope envelope;
                SimpleFeatureCollection featureResult;
                SimpleFeatureSource resource = this.featureSource(layer);
                Query query = layer.getQuery(true);
                ReferencedEnvelope bounds = resource.getBounds(query);
                if (bounds == null && (featureResult = resource.getFeatures(query)) != null && !featureResult.isEmpty() && (envelope = featureResult.getBounds()) != null) {
                    bounds = new ReferencedEnvelope((Envelope)envelope, layer.getCRS());
                }
                if (bounds != null) {
                    if (bounds.getHeight() <= 0.0 || bounds.getWidth() <= 0.0) {
                        bounds.expandBy(1.0);
                    }
                    bounds = ScaleUtils.fitToMinAndMax((ReferencedEnvelope)bounds, (ILayer)layer);
                    this.getContext().sendASyncCommand((Command)new SetViewportBBoxCommand((Envelope)bounds, layer.getCRS()));
                }
            }
            catch (IOException e) {
                SelectPlugin.log("failed to obtain resource", e);
            }
        }
    }

    private SimpleFeatureSource featureSource(ILayer layer) throws IOException {
        SimpleFeatureSource resource = (SimpleFeatureSource)layer.getResource(SimpleFeatureSource.class, ProgressManager.instance().get(new Object[0]));
        return resource;
    }

    public void dispose() {
    }
}

