/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select.internal;

import java.util.List;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.AOIProxy;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.tool.select.internal.AOILayerStrategy;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class AOILayerPage
extends Page {
    private Composite page;
    private AOIProxy strategy;
    private ComboViewer comboViewer;
    private static String AOI_LAYER_ID = "net.refractions.udig.tool.select.internal.aoiLayer";
    private ISelectionChangedListener comboListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selectedLayer = (IStructuredSelection)event.getSelection();
            ILayer selected = (ILayer)selectedLayer.getFirstElement();
            AOILayerPage.this.getAOILayerStrategy().setActiveLayer(selected);
        }
    };
    private AOIListener layerWatcher = new AOIListener(){

        public void handleEvent(AOIListener.Event event) {
            PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILayer activeLayer = AOILayerPage.this.getAOILayerStrategy().getActiveLayer();
                    List<ILayer> layers = AOILayerPage.this.getAOILayerStrategy().getAOILayers();
                    if (AOILayerPage.this.comboViewer == null || AOILayerPage.this.comboViewer.getControl() == null || AOILayerPage.this.comboViewer.getControl().isDisposed()) {
                        return;
                    }
                    AOILayerPage.this.comboViewer.setInput(layers);
                    if (layers.contains(activeLayer)) {
                        AOILayerPage.this.setSelected(activeLayer);
                    } else {
                        AOILayerPage.this.setSelected(null);
                    }
                }
            }, (boolean)true);
        }
    };

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    private AOILayerStrategy getAOILayerStrategy() {
        IAOIService aOIService = PlatformGIS.getAOIService();
        IAOIStrategy aOIStrategy = aOIService.findProxy(AOI_LAYER_ID).getStrategy();
        if (aOIStrategy instanceof AOILayerStrategy) {
            return (AOILayerStrategy)aOIStrategy;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.page.setLayout((Layout)layout);
        Label comboLabel = new Label(this.page, 16384);
        comboLabel.setText("Layer:");
        comboLabel.pack();
        this.listenStrategy(true);
        this.comboViewer = new ComboViewer(this.page, 8);
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ILayer) {
                    ILayer layer = (ILayer)element;
                    return layer.getName();
                }
                return super.getText(element);
            }
        });
        List<ILayer> layers = this.getAOILayerStrategy().getAOILayers();
        this.comboViewer.setInput(layers);
        ILayer activeLayer = this.getAOILayerStrategy().getActiveLayer();
        this.setSelected(activeLayer);
        this.comboViewer.addSelectionChangedListener(this.comboListener);
    }

    private void setSelected(ILayer selected) {
        boolean disposed = this.comboViewer.getControl().isDisposed();
        if (this.comboViewer == null || disposed) {
            this.listenStrategy(false);
            return;
        }
        ILayer current = this.getSelected();
        if (current != selected) {
            try {
                this.listenCombo(false);
                this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)selected), true);
            }
            finally {
                this.listenCombo(true);
            }
        }
    }

    private ILayer getSelected() {
        if (this.comboViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
            return (ILayer)selection.getFirstElement();
        }
        return null;
    }

    protected void listenCombo(boolean listen) {
        if (listen) {
            this.comboViewer.addSelectionChangedListener(this.comboListener);
        } else {
            this.comboViewer.removeSelectionChangedListener(this.comboListener);
        }
    }

    protected void listenStrategy(boolean listen) {
        AOILayerStrategy aOILayerStrategy = this.getAOILayerStrategy();
        if (listen) {
            aOILayerStrategy.addListener(this.layerWatcher);
        } else {
            aOILayerStrategy.removeListener(this.layerWatcher);
        }
    }

    public Composite getControl() {
        return this.page;
    }

    public void setFocus() {
        if (this.page != null && !this.page.isDisposed()) {
            this.page.setFocus();
        }
    }

    public void dispose() {
        if (this.strategy != null) {
            this.strategy = null;
        }
        super.dispose();
    }
}

