/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select.commands;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import net.refractions.udig.aoi.AOIProxy;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.render.impl.ViewportModelImpl;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tool.select.SelectPlugin;
import net.refractions.udig.tool.select.internal.AOILayerStrategy;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class SetAOILayerCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Envelope bbox = null;
    private ReferencedEnvelope bounds;
    private MapMouseEvent mouseEvent;
    private static String AOI_LAYER_ID = "net.refractions.udig.tool.select.internal.aoiLayer";

    public SetAOILayerCommand(MapMouseEvent e, Envelope bbox) {
        this.bbox = bbox;
        this.mouseEvent = e;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run(IProgressMonitor monitor) throws Exception {
        boolean isNavigate = SelectPlugin.getDefault().getPreferenceStore().getBoolean("aoiNavigateSelection");
        AOILayerStrategy strategy = this.getAOILayerStrategy();
        ILayer activeLayer = strategy.getActiveLayer();
        ILayer previousLayer = strategy.getPreviousLayer();
        ILayer nextLayer = strategy.getNextLayer();
        ILayer selectedLayer = activeLayer;
        Geometry geometry = strategy.getGeometry();
        Polygon testLocation = JTS.toGeometry((Envelope)this.bbox);
        if (isNavigate && this.mouseEvent.button == 32) {
            if (previousLayer == null) {
                this.updateAOIService(null, null);
                this.bounds = this.getMap().getBounds(null);
                ViewportModelImpl vmi = (ViewportModelImpl)this.getMap().getViewportModel();
                vmi.zoomToBox((Envelope)this.bounds);
                return;
            }
            selectedLayer = previousLayer;
        } else if (isNavigate && this.mouseEvent.button == 8) {
            ILayer iLayer = selectedLayer = nextLayer != null ? nextLayer : activeLayer;
            if (!(activeLayer == null || geometry != null && geometry.contains((Geometry)testLocation))) {
                selectedLayer = activeLayer;
            }
        }
        if (selectedLayer == null) {
            return;
        }
        if (!selectedLayer.getInteraction(Interaction.AOI)) {
            return;
        }
        SimpleFeatureCollection featureCollection = this.getFeaturesInBbox(selectedLayer, this.bbox, monitor);
        if (featureCollection.isEmpty()) {
            if (selectedLayer == activeLayer) {
                return;
            }
            SimpleFeatureCollection testCollection = this.getFeaturesInBbox(activeLayer, this.bbox, monitor);
            if (testCollection.isEmpty()) {
                return;
            }
            selectedLayer = activeLayer;
            featureCollection = testCollection;
        }
        this.bounds = featureCollection.getBounds();
        Geometry newAOI = this.unionGeometry(featureCollection);
        this.updateAOIService(selectedLayer, newAOI);
        if (isNavigate) {
            IMap map = selectedLayer.getMap();
            ViewportModelImpl vmi = (ViewportModelImpl)map.getViewportModel();
            vmi.zoomToBox((Envelope)this.bounds);
        }
    }

    private AOILayerStrategy getAOILayerStrategy() {
        IAOIService aOIService = PlatformGIS.getAOIService();
        IAOIStrategy aOIStrategy = aOIService.findProxy(AOI_LAYER_ID).getStrategy();
        if (aOIStrategy instanceof AOILayerStrategy) {
            return (AOILayerStrategy)aOIStrategy;
        }
        return null;
    }

    private SimpleFeatureCollection getFeaturesInBbox(ILayer layer, Envelope bbox, IProgressMonitor monitor) throws IOException {
        SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (featureSource == null) {
            return null;
        }
        Filter bboxFilter = layer.createBBoxFilter(bbox, monitor);
        return featureSource.getFeatures(bboxFilter);
    }

    private Geometry unionGeometry(SimpleFeatureCollection featureCollection) {
        if (featureCollection.size() < 0) {
            return null;
        }
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        SimpleFeatureIterator featureIterator = featureCollection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            geoms.add(geometry.reverse());
        }
        GeometryFactory factory = new GeometryFactory();
        Geometry combined = factory.buildGeometry(geoms);
        return combined.union();
    }

    private void updateAOIService(ILayer layer, Geometry newAOI) throws IOException {
        IAOIService aOIService = PlatformGIS.getAOIService();
        AOIProxy aoiLayerProxy = aOIService.findProxy(AOI_LAYER_ID);
        AOILayerStrategy aOILayerStrategy = (AOILayerStrategy)aoiLayerProxy.getStrategy();
        aOILayerStrategy.setActiveLayer(layer);
        aOILayerStrategy.setGeometry(newAOI);
        if (!aOIService.getProxy().equals((Object)aoiLayerProxy)) {
            aOIService.setProxy(aoiLayerProxy);
        }
    }

    public String getName() {
        return Messages.BBoxSelectionCommand_boxSelection;
    }
}

