/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.select;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.commands.selection.BBoxSelectionCommand;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.SimpleTool;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class BBoxSelection
extends SimpleTool
implements ModalTool {
    public static final String ID = "net.refractions.udig.tools.BBoxSelect";
    private Point start;
    private boolean selecting;
    SelectionBoxCommand shapeCommand;
    Set<String> selectedFids = new HashSet<String>();

    public BBoxSelection() {
        super(3);
    }

    protected void onMouseDragged(MapMouseEvent e) {
        Point end = e.getPoint();
        if (this.start == null) {
            return;
        }
        this.shapeCommand.setShape((Shape)new Rectangle(Math.min(this.start.x, end.x), Math.min(this.start.y, end.y), Math.abs(this.start.x - end.x), Math.abs(this.start.y - end.y)));
        this.context.getViewportPane().repaint();
    }

    public void onMousePressed(MapMouseEvent e) {
        this.shapeCommand = new SelectionBoxCommand();
        if ((e.button & 8) != 0) {
            this.selecting = true;
            this.start = e.getPoint();
            this.shapeCommand.setValid(true);
            this.shapeCommand.setShape((Shape)new Rectangle(this.start.x, this.start.y, 0, 0));
            this.context.sendASyncCommand((Command)this.shapeCommand);
        }
    }

    public void onMouseReleased(MapMouseEvent e) {
        if (this.selecting) {
            Point end = e.getPoint();
            if (this.start == null || this.start.equals(end)) {
                ReferencedEnvelope bounds = this.getContext().getBoundingBox(e.getPoint(), 3);
                this.sendSelectionCommand(e, (Envelope)bounds);
            } else {
                Coordinate c1 = this.context.getMap().getViewportModel().pixelToWorld(this.start.x, this.start.y);
                Coordinate c2 = this.context.getMap().getViewportModel().pixelToWorld(end.x, end.y);
                Envelope bounds = new Envelope(c1, c2);
                this.sendSelectionCommand(e, bounds);
            }
        }
    }

    protected void sendSelectionCommand(MapMouseEvent e, Envelope bounds) {
        BBoxSelectionCommand command = e.isModifierDown(MapMouseEvent.MOD2_DOWN_MASK) ? new BBoxSelectionCommand(bounds, 1) : (e.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK) ? new BBoxSelectionCommand(bounds, -1) : new BBoxSelectionCommand(bounds, 0));
        this.getContext().sendASyncCommand((Command)command);
        this.selecting = false;
        this.shapeCommand.setValid(false);
        this.getContext().getViewportPane().repaint();
    }
}

