/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import net.sourceforge.hatbox.AbstractNode;
import net.sourceforge.hatbox.Algorithm;
import net.sourceforge.hatbox.IndexStatus;
import net.sourceforge.hatbox.InvalidTableException;

public class MetaNode
extends AbstractNode {
    private static final int CURRENT_VERSION = 1;
    private static final Algorithm CURRENT_ALGORITHM = Algorithm.RTREE_GUTTMAN_QUADRATIC;
    private static final int META_NODE_SIZE = 500;
    private static final int DEFAULT_ENTRIES_MAX = 49;
    private static final boolean DEFAULT_EXPOSE_PK = false;
    private static final String[] VALID_GEOMETRY = new String[]{"GEOMETRY", "POINT", "MULTIPOINT", "LINESTRING", "MULTILINESTRING", "POLYGON", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
    public static final int VERSION_OFFSET = 0;
    public static final int ALGORITHM_OFFSET = 1;
    public static final int EXPOSE_PK_OFFSET = 2;
    public static final int GEOM_TYPE_OFFSET = 3;
    public static final int ROOT_ID_OFFSET = 4;
    public static final int INDEX_STATUS_OFFSET = 12;
    public static final int ENTRIES_MAX_OFFSET = 16;
    public static final int SRID_OFFSET = 20;
    public static final int PK_COL_INDEX_OFFSET = 24;
    public static final int GEOM_COL_INDEX_OFFSET = 28;
    public static final int STRINGS_OFFSET = 40;
    private String tableName;
    private String pkColName;
    private String geomColName;

    public MetaNode(byte[] data) {
        super(1L, data);
    }

    public MetaNode(long rootId, String table, String pkColumn, int pkColumnIndex, String geomColumn, int geomColumnIndex, String geomType, String srid, String exposePK, String entriesMax) {
        this.id = 1L;
        this.data = new byte[500];
        this.putByte(1, 0);
        this.putByte(CURRENT_ALGORITHM.ordinal(), 1);
        this.setIndexStatus(IndexStatus.NO_INDEX);
        this.setRootId(rootId);
        if (pkColumn == null || geomColumn == null) {
            throw new InvalidTableException("PK column name and Geom column name must be supplied");
        }
        this.setNames(table, pkColumn, geomColumn);
        this.setPkColIndex(pkColumnIndex);
        this.setGeomColIndex(geomColumnIndex);
        try {
            this.setSrid(Integer.parseInt(srid));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (exposePK == null) {
            this.setExposePk(false);
        } else {
            this.setExposePk(Boolean.parseBoolean(exposePK));
        }
        if (entriesMax == null) {
            this.setEntriesMax(49);
        } else {
            this.setEntriesMax(Integer.parseInt(entriesMax));
        }
        if (geomType == null) {
            geomType = VALID_GEOMETRY[0];
        }
        this.setGeomType(geomType);
    }

    public long getRootId() {
        return this.getLong(4);
    }

    public void setRootId(long id) {
        this.putLong(id, 4);
    }

    public IndexStatus getIndexStatus() {
        return IndexStatus.values()[this.getInt(12)];
    }

    public void setIndexStatus(IndexStatus status) {
        this.putInt(status.ordinal(), 12);
    }

    public int getEntriesMax() {
        return this.getInt(16);
    }

    public void setEntriesMax(int max) {
        if (max < 2 || max > 1000) {
            throw new InvalidTableException("Maximum index entries per node: " + max + " is not valid");
        }
        this.putInt(max, 16);
    }

    public int getSrid() {
        return this.getInt(20);
    }

    public void setSrid(int srid) {
        if (srid < -1) {
            throw new InvalidTableException("srid: " + srid + " is not valid");
        }
        this.putInt(srid, 20);
    }

    public int getPkColIndex() {
        return this.getInt(24);
    }

    public void setPkColIndex(int index) {
        this.putInt(index, 24);
    }

    public int getGeomColIndex() {
        return this.getInt(28);
    }

    public void setGeomColIndex(int index) {
        this.putInt(index, 28);
    }

    public boolean getExposePk() {
        return this.getBoolean(2);
    }

    public void setExposePk(boolean exposePk) {
        this.putBoolean(exposePk, 2);
    }

    public String getGeomType() {
        return VALID_GEOMETRY[this.getByte(3)];
    }

    public void setGeomType(String geomType) {
        this.putByte(this.validateGeomType(geomType), 3);
    }

    public int getVersion() {
        return this.getByte(0);
    }

    public Algorithm getAlgorithm() {
        return Algorithm.values()[this.getByte(1)];
    }

    public String getTableName() {
        if (this.tableName == null) {
            this.populateStrings();
        }
        return this.tableName;
    }

    public String getPkColName() {
        if (this.pkColName == null) {
            this.populateStrings();
        }
        return this.pkColName;
    }

    public String getGeomColName() {
        if (this.geomColName == null) {
            this.populateStrings();
        }
        return this.geomColName;
    }

    public void setNames(String table, String pkCol, String geomCol) {
        this.tableName = table;
        this.pkColName = pkCol;
        this.geomColName = geomCol;
        this.saveStrings();
    }

    private void saveStrings() {
        String[] strings = new String[]{this.tableName, this.pkColName, this.geomColName};
        this.putShort(strings.length, 40);
        int offset = 42;
        for (String s : strings) {
            int len = 0;
            len = s == null ? -1 : s.length();
            this.putShort(len, offset);
            offset += 2;
            for (int i = 0; i < len; ++i) {
                this.putChar(s.charAt(i), offset);
                offset += 2;
            }
        }
    }

    private void populateStrings() {
        int count = this.getShort(40);
        String[] strings = new String[count];
        StringBuilder builder = null;
        int offset = 42;
        for (int s = 0; s < count; ++s) {
            builder = new StringBuilder();
            int len = this.getShort(offset);
            offset += 2;
            for (int i = 0; i < len; ++i) {
                builder.append(this.getChar(offset));
                offset += 2;
            }
            if (len < 0) continue;
            strings[s] = builder.toString();
        }
        this.tableName = strings[0];
        this.pkColName = strings[1];
        this.geomColName = strings[2];
    }

    private int validateGeomType(String toValidate) {
        for (int i = 0; i < VALID_GEOMETRY.length; ++i) {
            if (!VALID_GEOMETRY[i].equalsIgnoreCase(toValidate)) continue;
            return i;
        }
        throw new InvalidTableException("Geometry Type: " + toValidate + " is not valid");
    }
}

