/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PropertyAttributeReader
implements AttributeReader {
    BufferedReader reader;
    SimpleFeatureType type;
    String line;
    String next;
    String[] text;
    String fid;

    public PropertyAttributeReader(File file) throws IOException {
        String typeName = PropertyAttributeReader.typeName(file);
        String namespace = PropertyAttributeReader.namespace(file);
        this.reader = new BufferedReader(new FileReader(file));
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("_=")) {
        }
        if (this.line == null || !this.line.startsWith("_=")) {
            throw new IOException(typeName + " schema not available");
        }
        String typeSpec = this.line.substring(2);
        try {
            this.type = DataUtilities.createType(namespace, typeName, typeSpec);
        }
        catch (SchemaException e) {
            throw new DataSourceException(typeName + " schema not available", e);
        }
        this.line = null;
        this.next = null;
    }

    private static String typeName(File file) {
        String name = file.getName();
        int split = name.lastIndexOf(46);
        return split == -1 ? name : name.substring(0, split);
    }

    private static String namespace(File file) {
        File parent = file.getParentFile();
        return parent == null ? "" : parent.getName() + ".";
    }

    @Override
    public int getAttributeCount() {
        return this.type.getAttributeCount();
    }

    @Override
    public AttributeDescriptor getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.type.getDescriptor(index);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.reader = null;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.next = this.readLine();
        return this.next != null;
    }

    String readLine() throws IOException {
        String txt;
        StringBuilder buffer = new StringBuilder();
        while ((txt = this.reader.readLine()) != null) {
            if (txt.startsWith("#") || txt.startsWith("!")) continue;
            if ((txt = this.trimLeft(txt)).endsWith("\\")) {
                buffer.append(txt.substring(0, txt.length() - 1));
                buffer.append("\n");
                continue;
            }
            buffer.append(txt);
            break;
        }
        if (buffer.length() == 0) {
            return null;
        }
        String raw = buffer.toString();
        return raw;
    }

    String decodeString(String txt) {
        txt = txt.replace("\\n", "\n");
        txt = txt.replaceAll("\\r", "\r");
        txt = txt.replace("\\|", "|");
        return txt;
    }

    String trimLeft(String txt) {
        int start = 0;
        for (int i = 0; i < txt.length(); ++i) {
            char ch = txt.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            start = i;
            break;
        }
        return txt.substring(start);
    }

    @Override
    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.line = this.next;
        this.next = null;
        int split = this.line.indexOf(61);
        this.fid = this.line.substring(0, split);
        String data = this.line.substring(split + 1);
        this.text = this.splitIntoText(data);
    }

    private String[] splitIntoText(String data) throws DataSourceException {
        String[] split = new String[this.type.getAttributeCount()];
        int i = 0;
        StringBuilder item = new StringBuilder();
        for (String str : data.split("\\|", -1)) {
            if (i == this.type.getAttributeCount()) {
                throw new DataSourceException("format error: expected " + split.length + " attributes, stopped after finding " + i + ". [" + data + "] split into " + Arrays.asList(split));
            }
            if (str.endsWith("\\")) {
                item.append(str);
                item.append("|");
                continue;
            }
            item.append(str);
            split[i] = item.toString();
            ++i;
            item = new StringBuilder();
        }
        if (i < this.type.getAttributeCount()) {
            throw new DataSourceException("format error: expected " + this.type.getAttributeCount() + " attributes, but only found " + i + ". [" + data + "] split into " + Arrays.asList(split));
        }
        return split;
    }

    public String getFeatureID() {
        if (this.line == null) {
            return null;
        }
        return this.fid;
    }

    @Override
    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        CoordinateReferenceSystem crs;
        if (this.line == null) {
            throw new IOException("No content available - did you remeber to call next?");
        }
        AttributeDescriptor attType = this.type.getDescriptor(index);
        String stringValue = null;
        try {
            stringValue = this.decodeString(this.text[index]);
        }
        catch (RuntimeException huh) {
            huh.printStackTrace();
            stringValue = null;
        }
        if ("<null>".equals(stringValue)) {
            stringValue = null;
        }
        if (stringValue == null && attType.isNillable()) {
            return null;
        }
        Object value = Converters.convert(stringValue, attType.getType().getBinding());
        if (attType.getType() instanceof GeometryType && (crs = ((GeometryType)attType.getType()).getCoordinateReferenceSystem()) != null && value != null && value instanceof Geometry) {
            ((Geometry)value).setUserData(crs);
        }
        return value;
    }
}

