/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.StructDescriptor;

public class StructMetaData
implements oracle.jdbc.internal.StructMetaData {
    StructDescriptor descriptor;
    OracleTypeADT otype;
    OracleType[] types;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jan_25_01:27:36_PST_2006";

    public StructMetaData(StructDescriptor structDescriptor) throws SQLException {
        if (structDescriptor == null) {
            DatabaseError.throwSqlException(1, "illegal operation: descriptor is null");
        }
        this.descriptor = structDescriptor;
        this.otype = structDescriptor.getOracleTypeADT();
        this.types = this.otype.getAttrTypes();
    }

    public int getColumnCount() throws SQLException {
        return this.types.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        return false;
    }

    public boolean isCurrency(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.types[n2] instanceof OracleTypeNUMBER || this.types[n2] instanceof OracleTypeFLOAT;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.types[n2] instanceof OracleTypeCHAR;
    }

    public int isNullable(int n) throws SQLException {
        return 1;
    }

    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        if (this.types[n2] instanceof OracleTypeCHAR) {
            return ((OracleTypeCHAR)this.types[n2]).getLength();
        }
        if (this.types[n2] instanceof OracleTypeRAW) {
            return ((OracleTypeRAW)this.types[n2]).getLength();
        }
        return 0;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.otype.getAttributeName(n);
    }

    public String getSchemaName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        if (this.types[n2] instanceof OracleTypeADT) {
            return ((OracleTypeADT)this.types[n2]).getSchemaName();
        }
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.types[n2].getPrecision();
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.types[n2].getScale();
    }

    public String getTableName(int n) throws SQLException {
        return null;
    }

    public String getCatalogName(int n) throws SQLException {
        return null;
    }

    public int getColumnType(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.types[n2].getTypeCode();
    }

    public String getColumnTypeName(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        int n3 = this.getValidColumnIndex(n);
        switch (n2) {
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMBER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 100: {
                return "BINARY_FLOAT";
            }
            case 101: {
                return "BINARY_DOUBLE";
            }
            case 91: {
                return "DATE";
            }
            case -104: {
                return "INTERVALDS";
            }
            case -103: {
                return "INTERVALYM";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                return ((OracleTypeADT)this.types[n3]).getFullName();
            }
            case 2006: {
                return "REF " + ((OracleTypeREF)this.types[n3]).getFullName();
            }
        }
        return null;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -2: {
                return "byte[]";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "java.math.BigDecimal";
            }
            case 91: {
                return "java.sql.Timestamp";
            }
            case -103: {
                return "oracle.sql.INTERVALYM";
            }
            case -104: {
                return "oracle.sql.INTERVALDS";
            }
            case 93: {
                return "oracle.sql.TIMESTAMP";
            }
            case -101: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case -102: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 2004: {
                return "oracle.sql.BLOB";
            }
            case 2005: {
                return "oracle.sql.CLOB";
            }
            case -13: {
                return "oracle.sql.BFILE";
            }
            case 2002: 
            case 2008: {
                return "oracle.sql.STRUCT";
            }
            case 2007: {
                return "oracle.sql.OPAQUE";
            }
            case 2003: {
                return "oracle.sql.ARRAY";
            }
            case 2006: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public String getOracleColumnClassName(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 1: 
            case 12: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "NUMBER";
            }
            case 91: {
                return "DATE";
            }
            case -103: {
                return "INTERVALYM";
            }
            case -104: {
                return "INTERVALDS";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2008: {
                return "JAVA_STRUCT";
            }
            case 2007: {
                return "OPAQUE";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2006: {
                return "REF";
            }
        }
        return null;
    }

    public int getLocalColumnCount() throws SQLException {
        return this.descriptor.getLocalAttributeCount();
    }

    public boolean isInherited(int n) throws SQLException {
        return n <= this.getColumnCount() - this.getLocalColumnCount();
    }

    public String getAttributeJavaName(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.descriptor.getAttributeJavaName(n2);
    }

    private int getValidColumnIndex(int n) throws SQLException {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.types.length) {
            DatabaseError.throwSqlException(3, "getValidColumnIndex");
        }
        return n2;
    }

    public boolean isNCHAR(int n) throws SQLException {
        int n2 = this.getValidColumnIndex(n);
        return this.types[n2].isNCHAR();
    }
}

