/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.WMSTileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.AbstractRequest;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.ows.ServiceException;

public class WMSTile
implements Tile {
    private static final boolean testing = false;
    public static final int INERROR = 1;
    public static final int OK = 0;
    private String id;
    private String position;
    private static String ID_DIVIDER = "_";
    private WMSTileSet tileset;
    private AbstractOpenWebService<?, ?> server;
    private BufferedImage image;
    private Object imageLock = new Object();
    private Envelope bounds;
    private double scale;
    private int state = 0;
    private String maxCacheAge;

    public WMSTile(AbstractOpenWebService<?, ?> server, WMSTileSet tileset, Envelope bounds, double scale) {
        this.server = server;
        this.tileset = tileset;
        this.bounds = bounds;
        this.scale = scale;
        this.id = WMSTile.buildId(bounds, scale);
    }

    public static String buildId(Envelope bbox, double scale) {
        if (bbox == null) {
            return null;
        }
        return String.valueOf(scale) + ID_DIVIDER + bbox.getMinX() + ID_DIVIDER + bbox.getMaxY() + ID_DIVIDER + bbox.getMaxY() + ID_DIVIDER + bbox.getMinY();
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = WMSTile.buildId(this.bounds, this.scale);
        }
        return this.id;
    }

    @Override
    public TileSet getTileSet() {
        return this.tileset;
    }

    @Override
    public Envelope getBounds() {
        return this.bounds;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferedImage(BufferedImage im) {
        Object lock;
        Object object = lock = this.getTileLock();
        synchronized (object) {
            this.setBufferedImageInternal(im);
            if (this.getBufferedImage() != null) {
                this.setTileState(0);
            } else {
                this.setTileState(1);
            }
        }
    }

    private void setBufferedImageInternal(BufferedImage im) {
        this.image = im;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.image;
    }

    @Override
    public Object getTileLock() {
        return this.imageLock;
    }

    @Override
    public int compareTo(Tile other) {
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Tile) {
            Tile tile = (Tile)arg0;
            return this.getId().equals(tile.getId());
        }
        return super.equals(arg0);
    }

    @Override
    public int getTileState() {
        return this.state;
    }

    @Override
    public void setTileState(int state) {
        this.state = state;
    }

    @Override
    public void setPosition(String pos) {
        this.position = pos;
    }

    @Override
    public String getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadTile(IProgressMonitor monitor) {
        if (this.server == null && this.tileset != null) {
            this.setServer(this.tileset.getServer());
        }
        if (this.server == null || this.tileset == null) {
            WmsPlugin.log("error, tile not setup with a server and/or tileset", null);
            this.createErrorImage();
            return false;
        }
        Envelope env = this.getBounds();
        URL req = null;
        try {
            URI rawURI = this.server.getInfo().getSource();
            String baseUrl = String.valueOf(rawURI.getScheme()) + "://" + rawURI.getHost() + ":" + rawURI.getPort() + rawURI.getPath() + "?";
            req = new URL(String.valueOf(baseUrl) + "&version=" + this.server.getCapabilities().getVersion() + "&" + this.tileset.createQueryString(env));
        }
        catch (MalformedURLException e2) {
            WmsPlugin.log("error building request URL:", e2);
            return false;
        }
        GetMapRequest request = new GetMapRequest(req);
        Object lock = this.getTileLock();
        BufferedImage bufImage = null;
        Object object = lock;
        synchronized (object) {
            block28: {
                block27: {
                    if ((this.getBufferedImage() == null || this.getTileState() == 1) && !monitor.isCanceled()) break block27;
                    monitor.setCanceled(true);
                    return true;
                }
                InputStream inputStream = null;
                try {
                    HTTPResponse response = this.issueRequest(request);
                    String cacheControl = this.extractHeaderCacheControl(response);
                    this.setMaxCacheAge(cacheControl);
                    inputStream = response.getResponseStream();
                    WmsPlugin.log("WMSC GetMap: " + req.toString(), null);
                    bufImage = ImageIO.read(inputStream);
                    if (bufImage != null) {
                        this.setBufferedImageInternal(bufImage);
                        this.setTileState(0);
                    } else {
                        this.setBufferedImageInternal(this.createErrorImage());
                        this.setTileState(1);
                    }
                }
                catch (Exception e1) {
                    this.setBufferedImageInternal(this.createErrorImage());
                    this.setTileState(1);
                    WmsPlugin.log("error loading tile, placeholder created:", e1);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            WmsPlugin.log("failed to close input stream!!!", e);
                        }
                    }
                    break block28;
                }
                catch (Throwable t) {
                    try {
                        this.setBufferedImageInternal(this.createErrorImage());
                        this.setTileState(1);
                        WmsPlugin.log("error loading tile, placeholder created:", t);
                        break block28;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                WmsPlugin.log("failed to close input stream!!!", e);
                            }
                        }
                    }
                }
                if (inputStream == null) break block28;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    WmsPlugin.log("failed to close input stream!!!", e);
                }
            }
        }
        return this.getBufferedImage() != null;
    }

    private String extractHeaderCacheControl(HTTPResponse response) {
        String[] split;
        String maxAge;
        String cacheControl = response.getResponseHeader("Cache-Control");
        if (cacheControl != null && !"".equals(cacheControl) && (maxAge = (split = cacheControl.split(","))[0]) != null && !"".equals(maxAge)) {
            return maxAge.split("=")[1];
        }
        return null;
    }

    public HTTPResponse issueRequest(GetMapRequest request) throws IOException, ServiceException {
        HTTPResponse httpResponse;
        URL finalURL = request.getFinalURL();
        if (finalURL.getHost() == null) {
            throw new NullPointerException("No host provided by " + finalURL);
        }
        HTTPClient httpClient = this.server.getHTTPClient();
        if (request.requiresPost()) {
            String postContentType = request.getPostContentType();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            request.performPostOutput(out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            try {
                httpResponse = httpClient.post(finalURL, (InputStream)in, postContentType);
            }
            finally {
                ((InputStream)in).close();
            }
        } else {
            httpResponse = httpClient.get(finalURL);
        }
        return httpResponse;
    }

    private BufferedImage createErrorImage() {
        BufferedImage bf = new BufferedImage(this.tileset.getWidth(), this.tileset.getHeight(), 2);
        Graphics2D g = bf.createGraphics();
        g.setColor(Color.RED);
        g.drawLine(0, 0, this.tileset.getWidth(), this.tileset.getHeight());
        g.drawLine(0, this.tileset.getHeight(), this.tileset.getWidth(), 0);
        return bf;
    }

    public AbstractOpenWebService<?, ?> getServer() {
        return this.server;
    }

    public void setServer(AbstractOpenWebService<?, ?> server) {
        this.server = server;
    }

    @Override
    public void setMaxCacheAge(String maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
    }

    @Override
    public String getMaxCacheAge() {
        return this.maxCacheAge;
    }

    static class GetMapRequest
    extends AbstractRequest {
        private URL url;

        public GetMapRequest(URL url) {
            super(url, null);
            this.url = url;
        }

        public Response createResponse(HTTPResponse response) throws ServiceException, IOException {
            return new Response(response){};
        }

        public URL getFinalURL() {
            return this.url;
        }

        protected void initRequest() {
        }

        protected void initService() {
        }

        protected void initVersion() {
        }
    }
}

