/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import net.refractions.udig.catalog.wmsc.server.Capability;
import net.refractions.udig.catalog.wmsc.server.VendorSpecificCapabilities;
import net.refractions.udig.catalog.wmsc.server.WMSCCapabilities;
import net.refractions.udig.catalog.wmsc.server.WMSCSchema;
import net.refractions.udig.catalog.wmsc.server.WMSTileSet;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Service;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public interface WMSCComplexTypes {

    public static class _BoundingBoxType
    extends WMSCSchema.WMSCComplexType {
        private static final WMSCSchema.WMSCComplexType instance = new _BoundingBoxType();
        private static Attribute[] attrs = new Attribute[]{new WMSCSchema.WMSCAttribute(null, "CRS", WMSCSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false), new WMSCSchema.WMSCAttribute(null, "SRS", WMSCSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false), new WMSCSchema.WMSCAttribute(null, "minx", WMSCSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSCSchema.WMSCAttribute(null, "miny", WMSCSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSCSchema.WMSCAttribute(null, "maxx", WMSCSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSCSchema.WMSCAttribute(null, "maxy", WMSCSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSCSchema.WMSCAttribute("resx", XSISimpleTypes.Double.getInstance()), new WMSCSchema.WMSCAttribute("resy", XSISimpleTypes.Double.getInstance())};

        public static WMSCSchema.WMSCComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            CRSEnvelope bbox = new CRSEnvelope();
            String crs = attrs.getValue("CRS");
            if (crs == null || crs.length() == 0) {
                crs = attrs.getValue("crs");
            }
            if (crs == null || crs.length() == 0) {
                crs = attrs.getValue("SRS");
            }
            if (crs == null || crs.length() == 0) {
                crs = attrs.getValue("srs");
            }
            if (crs == null || crs.length() == 0) {
                throw new SAXException("Bounding Box element contains no CRS/SRS attribute");
            }
            bbox.setEPSGCode(crs.toUpperCase());
            bbox.setMinX(Double.parseDouble(attrs.getValue("minx")));
            bbox.setMaxX(Double.parseDouble(attrs.getValue("maxx")));
            bbox.setMinY(Double.parseDouble(attrs.getValue("miny")));
            bbox.setMaxY(Double.parseDouble(attrs.getValue("maxy")));
            return bbox;
        }

        public String getName() {
            return "BoundingBox";
        }

        public Class<?> getInstanceType() {
            return CRSEnvelope.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class _CapabilityType
    extends WMSCSchema.WMSCComplexType {
        private static final WMSCSchema.WMSCComplexType instance = new _CapabilityType();
        private static Element[] elems = new Element[]{new WMSCSchema.WMSCElement("VendorSpecificCapabilities", (Type)_VendorSpecificCapabilitiesType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[0];

        public static WMSCSchema.WMSCComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Capability capabilities = new Capability();
            int i = 0;
            while (i < value.length) {
                if (this.sameName(elems[0], value[i])) {
                    VendorSpecificCapabilities vc = (VendorSpecificCapabilities)value[i].getValue();
                    capabilities.setVendorCapabilities(vc);
                }
                ++i;
            }
            return capabilities;
        }

        public String getName() {
            return "Capability";
        }

        public Class<?> getInstanceType() {
            return Capability.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class _ServiceType
    extends WMSCSchema.WMSCComplexType {
        private static final WMSCSchema.WMSCComplexType instance = new _ServiceType();
        private static Element[] elems = new Element[]{new WMSCSchema.WMSCElement("Name", (Type)XSISimpleTypes.String.getInstance()), new WMSCSchema.WMSCElement("Title", (Type)XSISimpleTypes.String.getInstance()), new WMSCSchema.WMSCElement("OnlineResource", (Type)XSISimpleTypes.String.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        public static WMSCSchema.WMSCComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Service service = new Service();
            int i = 0;
            while (i < value.length) {
                if (this.sameName(elems[0], value[i])) {
                    service.setName((String)value[i].getValue());
                }
                if (this.sameName(elems[1], value[i])) {
                    service.setTitle((String)value[i].getValue());
                }
                if (this.sameName(elems[2], value[i])) {
                    String spec = (String)value[i].getValue();
                    if (spec == null || spec.length() == 0) {
                        System.out.println("OnlineResource cannot be empty");
                    } else {
                        try {
                            service.setOnlineResource(new URL(spec));
                        }
                        catch (MalformedURLException malformedURLException) {
                            System.out.println("OnlineResource cannot string to url: " + spec);
                        }
                    }
                }
                ++i;
            }
            return service;
        }

        public String getName() {
            return "Service";
        }

        public Class<?> getInstanceType() {
            return Service.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class _TileSetType
    extends WMSCSchema.WMSCComplexType {
        private static final WMSCSchema.WMSCComplexType instance = new _TileSetType();
        private static Element[] elems = new Element[]{new WMSCSchema.WMSCElement("SRS", (Type)XSISimpleTypes.String.getInstance()), new WMSCSchema.WMSCElement("BoundingBox", (Type)_BoundingBoxType.getInstance()), new WMSCSchema.WMSCElement("Resolutions", (Type)XSISimpleTypes.String.getInstance()), new WMSCSchema.WMSCElement("Width", (Type)XSISimpleTypes.Integer.getInstance()), new WMSCSchema.WMSCElement("Height", (Type)XSISimpleTypes.Integer.getInstance()), new WMSCSchema.WMSCElement("Format", (Type)XSISimpleTypes.String.getInstance()), new WMSCSchema.WMSCElement("Layers", (Type)XSISimpleTypes.String.getInstance()), new WMSCSchema.WMSCElement("Styles", (Type)XSISimpleTypes.String.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        public static WMSCSchema.WMSCComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            WMSTileSet tileset = new WMSTileSet();
            int i = 0;
            while (i < value.length) {
                if (this.sameName(elems[0], value[i])) {
                    String srs = (String)value[i].getValue();
                    tileset.setCoorindateReferenceSystem(srs);
                }
                if (this.sameName(elems[1], value[i])) {
                    CRSEnvelope bbox = (CRSEnvelope)value[i].getValue();
                    tileset.setBoundingBox(bbox);
                }
                if (this.sameName(elems[2], value[i])) {
                    String resolutions = (String)value[i].getValue();
                    tileset.setResolutions(resolutions);
                }
                if (this.sameName(elems[3], value[i])) {
                    Integer width = (Integer)value[i].getValue();
                    tileset.setWidth(width);
                }
                if (this.sameName(elems[4], value[i])) {
                    Integer height = (Integer)value[i].getValue();
                    tileset.setHeight(height);
                }
                if (this.sameName(elems[5], value[i])) {
                    String format = (String)value[i].getValue();
                    tileset.setFormat(format);
                }
                if (this.sameName(elems[6], value[i])) {
                    String layers = (String)value[i].getValue();
                    tileset.setLayers(layers);
                }
                if (this.sameName(elems[7], value[i])) {
                    String styles = (String)value[i].getValue();
                    tileset.setStyles(styles);
                }
                ++i;
            }
            if (tileset.getCoordinateReferenceSystem() == null) {
                return null;
            }
            return tileset;
        }

        public String getName() {
            return "WMSTileSet";
        }

        public Class<?> getInstanceType() {
            return WMSTileSet.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class _VendorSpecificCapabilitiesType
    extends WMSCSchema.WMSCComplexType {
        private static final WMSCSchema.WMSCComplexType instance = new _VendorSpecificCapabilitiesType();
        private static Element[] elems = new Element[]{new WMSCSchema.WMSCElement("TileSet", (Type)_TileSetType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        public static WMSCSchema.WMSCComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            VendorSpecificCapabilities capabilities = new VendorSpecificCapabilities();
            int i = 0;
            while (i < value.length) {
                WMSTileSet tile;
                if (this.sameName(elems[0], value[i]) && (tile = (WMSTileSet)value[i].getValue()) != null) {
                    capabilities.addTile(tile);
                }
                ++i;
            }
            return capabilities;
        }

        public String getName() {
            return "VendorSpecificCapabilities";
        }

        public Class<?> getInstanceType() {
            return VendorSpecificCapabilities.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    public static class _WMT_MS_CapabilitiesType
    extends WMSCSchema.WMSCComplexType {
        private static final WMSCSchema.WMSCComplexType instance = new _WMT_MS_CapabilitiesType();
        private static Element[] elems = new Element[]{new WMSCSchema.WMSCElement("Service", (Type)_ServiceType.getInstance()), new WMSCSchema.WMSCElement("Capability", (Type)_CapabilityType.getInstance()), new WMSCSchema.WMSCElement("VendorSpecificCapabilities", (Type)_VendorSpecificCapabilitiesType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSCSchema.WMSCAttribute(null, "version", WMSCSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false), new WMSCSchema.WMSCAttribute("updateSequence", XSISimpleTypes.String.getInstance())};

        public static WMSCSchema.WMSCComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            WMSCCapabilities capabilities = new WMSCCapabilities();
            int i = 0;
            while (i < value.length) {
                Capability c;
                ElementValue elementValue = value[i];
                if (this.sameName(elems[0], elementValue)) {
                    Service x = (Service)elementValue.getValue();
                    capabilities.setService(x);
                }
                if (this.sameName(elems[1], elementValue)) {
                    c = (Capability)elementValue.getValue();
                    capabilities.setCapabilitiy(c);
                }
                if (this.sameName(elems[2], elementValue)) {
                    c = new Capability();
                    VendorSpecificCapabilities cs = (VendorSpecificCapabilities)elementValue.getValue();
                    c.setVendorCapabilities(cs);
                    capabilities.setCapabilitiy(c);
                }
                ++i;
            }
            capabilities.setVersion(attrs.getValue("", "version"));
            capabilities.setUpdateSequence(attrs.getValue("", "updateSequence"));
            return capabilities;
        }

        public String getName() {
            return "WMT_MS_Capabilities";
        }

        public Class<?> getInstanceType() {
            return WMSCCapabilities.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }
}

