/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.WMSCCapabilities;
import net.refractions.udig.catalog.wmsc.server.WMSCCapabilitiesResponse;
import net.refractions.udig.catalog.wmsc.server.WMSCSchema;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.AbstractGetCapabilitiesRequest;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.Specification;
import org.geotools.data.wms.WMS1_1_1;
import org.geotools.data.wms.WebMapServer;
import org.geotools.ows.ServiceException;

public class TiledWebMapServer
extends AbstractOpenWebService<WMSCCapabilities, TileSet> {
    private WMSCCapabilities capabilities = null;
    private Exception couldNotConnect;
    private String getCaps_xml;

    public TiledWebMapServer(URL serverURL) throws ServiceException, IOException {
        super(serverURL);
    }

    public TiledWebMapServer(URL serverURL, String caps_xml, boolean checkForUpdate) throws ServiceException, IOException {
        this(serverURL);
        this.getCaps_xml = caps_xml;
        WMSCCapabilities capabilities = null;
        try {
            final ByteArrayInputStream is = new ByteArrayInputStream(caps_xml.getBytes());
            HTTPResponse mock = new HTTPResponse(){

                public InputStream getResponseStream() throws IOException {
                    return is;
                }

                public String getResponseHeader(String header) {
                    return null;
                }

                public String getContentType() {
                    return "text/xml";
                }

                public void dispose() {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            };
            WMSCCapabilitiesResponse response = new WMSCCapabilitiesResponse(mock);
            capabilities = (WMSCCapabilities)response.getCapabilities();
        }
        catch (Exception e) {
            TiledWebMapServer.log("Restore from cached capabilities failed", e);
        }
        if (checkForUpdate) {
            try {
                WMSCCapabilities newCaps = this.readCapabilities();
                if (capabilities == null) {
                    capabilities = newCaps;
                } else if (newCaps == null) {
                    this.getCaps_xml = caps_xml;
                } else {
                    Double capUpdateSeq;
                    Double newUpdateSeq = newCaps.getUpdateSequence() == null ? null : Double.valueOf(Double.parseDouble(newCaps.getUpdateSequence()));
                    Double d = capUpdateSeq = capabilities.getUpdateSequence() == null ? null : Double.valueOf(Double.parseDouble(capabilities.getUpdateSequence()));
                    if (newUpdateSeq != null && capUpdateSeq != null) {
                        if (newUpdateSeq > capUpdateSeq) {
                            capabilities = newCaps;
                        } else {
                            this.getCaps_xml = caps_xml;
                        }
                    } else {
                        capabilities = newCaps;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.capabilities = capabilities;
    }

    public WMSCCapabilities getCapabilities() {
        if (this.capabilities == null && this.couldNotConnect == null) {
            try {
                this.capabilities = this.readCapabilities();
            }
            catch (Exception ex) {
                this.couldNotConnect = ex;
            }
        }
        if (this.couldNotConnect != null) {
            TiledWebMapServer.log("Could not connect to " + this.getInfo().getSource(), this.couldNotConnect);
        }
        return this.capabilities;
    }

    private static void log(String msg, Throwable t) {
        if (WmsPlugin.getDefault() == null) {
            System.out.print(msg);
            if (t != null) {
                t.printStackTrace();
            } else {
                System.out.println();
            }
        } else {
            WmsPlugin.log(msg, t);
        }
    }

    private WMSCCapabilities readCapabilities() throws Exception {
        CapabilitiesRequest r = new CapabilitiesRequest(this.serverURL);
        TiledWebMapServer.log("WMSC GetCapabilities: " + r.getFinalURL(), null);
        WMSCCapabilitiesResponse cr = (WMSCCapabilitiesResponse)this.issueRequest((GetCapabilitiesRequest)r);
        if (cr != null) {
            this.getCaps_xml = cr.getCapabilitiesXml();
        }
        return (WMSCCapabilities)cr.getCapabilities();
    }

    public String getCapabilitiesXml() throws IOException {
        if (this.getCaps_xml == null) {
            this.getCapabilities();
        }
        return this.getCaps_xml;
    }

    public URL getService() {
        return this.serverURL;
    }

    protected ServiceInfo createInfo() {
        return new WMSCInfo();
    }

    protected ResourceInfo createInfo(TileSet arg0) {
        return null;
    }

    protected void setupSpecifications() {
        this.specs = new Specification[1];
        this.specs[0] = new WMS1_1_1();
    }

    static class CapabilitiesRequest
    extends AbstractGetCapabilitiesRequest {
        public CapabilitiesRequest(URL serverURL) {
            super(serverURL);
        }

        protected void initService() {
            this.setProperty("REQUEST", "GetCapabilities");
            this.setProperty("SERVICE", "WMS");
            this.setProperty("TILED", "true");
        }

        protected void initVersion() {
        }

        public Response createResponse(HTTPResponse response) throws ServiceException, IOException {
            return new WMSCCapabilitiesResponse(response);
        }
    }

    protected class WMSCInfo
    implements ServiceInfo {
        private Set<String> keywords = new HashSet<String>();
        private Icon icon;

        WMSCInfo() {
            String[] array;
            if (TiledWebMapServer.this.capabilities == null) {
                try {
                    TiledWebMapServer.this.getCapabilities();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (TiledWebMapServer.this.capabilities.getService() != null && (array = TiledWebMapServer.this.capabilities.getService().getKeywordList()) != null) {
                this.keywords.addAll(Arrays.asList(array));
            }
            this.keywords.add("WMSC");
            this.keywords.add(TiledWebMapServer.this.serverURL.toString());
            URL globe2 = WebMapServer.class.getResource("Globe2.png");
            this.icon = new ImageIcon(globe2);
        }

        public String getDescription() {
            String description = null;
            if (TiledWebMapServer.this.capabilities != null && TiledWebMapServer.this.capabilities.getService() != null) {
                description = TiledWebMapServer.this.capabilities.getService().get_abstract();
            }
            if (description == null) {
                description = "Tiled Map Server " + TiledWebMapServer.this.serverURL;
            }
            return description;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public Set<String> getKeywords() {
            return this.keywords;
        }

        public URI getPublisher() {
            try {
                return TiledWebMapServer.this.capabilities.getService().getContactInformation().getContactInfo().getOnLineResource().getLinkage();
            }
            catch (NullPointerException nullPointerException) {
                try {
                    return new URI(String.valueOf(TiledWebMapServer.this.serverURL.getProtocol()) + ":" + TiledWebMapServer.this.serverURL.getHost());
                }
                catch (URISyntaxException uRISyntaxException) {
                    return null;
                }
            }
        }

        public URI getSchema() {
            return WMSCSchema.NAMESPACE;
        }

        public URI getSource() {
            try {
                URL source = TiledWebMapServer.this.getService();
                return source.toURI();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
            try {
                return TiledWebMapServer.this.serverURL.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        public String getTitle() {
            if (TiledWebMapServer.this.capabilities != null && TiledWebMapServer.this.capabilities.getService() != null) {
                return TiledWebMapServer.this.capabilities.getService().getTitle();
            }
            if (TiledWebMapServer.this.serverURL == null) {
                return "Unavailable";
            }
            return TiledWebMapServer.this.serverURL.toString();
        }
    }
}

