/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.imageio.ImageIO;
import net.refractions.udig.catalog.wmsc.server.Tile;
import org.apache.commons.io.FileUtils;
import org.geotools.data.ows.AbstractOpenWebService;

public class TileImageReadWriter {
    private String baseTileFolder = "";
    private static final String baseSubTileFolder = "tilecache";
    private URL server;

    public TileImageReadWriter(AbstractOpenWebService<?, ?> service, String baseDir) {
        try {
            this.server = service.getInfo().getSource().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.baseTileFolder = String.valueOf(baseDir) + File.separator + baseSubTileFolder;
    }

    public File getTileFile(Tile tile, String filetype) {
        String filename = this.getTileFileName(tile, filetype);
        File file = new File(filename);
        if (!file.exists()) {
            try {
                file.mkdirs();
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return file;
    }

    public String getTileFileName(Tile tile, String filetype) {
        return String.valueOf(this.getTileDirectoryPath(tile)) + tile.getPosition() + "." + filetype;
    }

    public String getTileDirectoryPath(Tile tile) {
        String serverURL = String.valueOf(this.server.getHost()) + "_" + this.server.getPath();
        serverURL = serverURL.replace('\\', '_');
        serverURL = serverURL.replace('/', '_');
        String layers = tile.getTileSet().getLayers();
        layers = String.valueOf(layers) + "_" + tile.getTileSet().getEPSGCode();
        layers = String.valueOf(layers) + "_" + tile.getTileSet().getFormat();
        layers = layers.replace(',', '_');
        layers = layers.replace(':', '_');
        layers = layers.replace('\\', '_');
        layers = layers.replace('/', '_');
        layers = layers.replace(File.separator, "_");
        Double scale = tile.getScale();
        String scaleStr = scale.toString();
        scaleStr = scaleStr.replace('.', '_');
        return String.valueOf(this.baseTileFolder) + File.separator + serverURL + File.separator + layers + File.separator + scaleStr + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTile(Tile tile, String filetype) {
        try {
            Object lock;
            Object object = lock = tile.getTileLock();
            synchronized (object) {
                ImageIO.write((RenderedImage)tile.getBufferedImage(), filetype, this.getTileFile(tile, filetype));
                this.writeTileMetadataFile(tile);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void writeTileMetadataFile(Tile tile) throws IOException {
        if (tile.getMaxCacheAge() != null && !"".equals(tile.getMaxCacheAge())) {
            FileUtils.writeStringToFile((File)new File(this.getCacheFilename(tile)), (String)tile.getMaxCacheAge());
        }
    }

    public boolean tileFileExists(Tile tile, String filetype) {
        String filename = this.getTileFileName(tile, filetype);
        File file = new File(filename);
        return file.exists();
    }

    public boolean isTileStale(Tile tile, String filetype) {
        block6: {
            String filename = this.getTileFileName(tile, filetype);
            File tileFile = new File(filename);
            String cacheFilename = this.getCacheFilename(tile);
            File cacheFile = new File(cacheFilename);
            if (cacheFile.exists()) {
                try {
                    String persistedCacheAge = FileUtils.readFileToString((File)cacheFile);
                    if (persistedCacheAge != null && !"".equals(persistedCacheAge)) {
                        Long cacheTimeLong = Long.parseLong(persistedCacheAge);
                        Date cacheTime = new Date(tileFile.lastModified() + cacheTimeLong * 1000L);
                        if (cacheTime.before(new Date(System.currentTimeMillis()))) {
                            return true;
                        }
                        break block6;
                    }
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
        }
        return false;
    }

    public String getCacheFilename(Tile tile) {
        return String.valueOf(this.getTileDirectoryPath(tile)) + tile.getPosition() + ".txt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readTile(Tile tile, String filetype) {
        BufferedInputStream bis = null;
        BufferedImage image = null;
        try {
            Object lock;
            Object object = lock = tile.getTileLock();
            synchronized (object) {
                bis = new BufferedInputStream(new FileInputStream(this.getTileFile(tile, filetype)));
                image = ImageIO.read(bis);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (image != null) {
            tile.setBufferedImage(image);
            return true;
        }
        return false;
    }

    public boolean clearCache() {
        File file = new File(this.baseTileFolder);
        return TileImageReadWriter.deleteDir(file);
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = TileImageReadWriter.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

