/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.management.ServiceNotFoundException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.wms.internal.Messages;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileListener;
import net.refractions.udig.catalog.wmsc.server.TileRangeOnDisk;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TileWorkerQueue;
import net.refractions.udig.catalog.wmsc.server.WMSTileSet;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import net.refractions.udig.project.ui.preferences.PreferenceConstants;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSCTileUtils {
    public static void preloadAllTilesOnDisk(TileSet tileset) {
        WMSCTileUtils.preloadAllTilesOnDisk(tileset, null);
    }

    public static void preloadAllTilesOnDisk(TileSet tileset, Geometry select) {
        PreloadTilesClass preloadTiles = new PreloadTilesClass(tileset, select);
        String taskname = Messages.WMSCTileUtils_preloadtask;
        PlatformGIS.runInProgressDialog((String)taskname, (boolean)false, (IRunnableWithProgress)preloadTiles, (boolean)true);
    }

    public static TileSet toTileSet(IGeoResource resource, AbstractOpenWebService<?, ?> server, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("TileSet generation", 100);
        try {
            if (server == null) {
                WmsPlugin.log("WebMapService required", new ServiceNotFoundException());
                return null;
            }
            ServiceInfo serverInfo = server.getInfo();
            URI serverURI = serverInfo.getSource();
            String source = serverURI != null ? serverURI.toString() : null;
            String version = server.getCapabilities().getVersion();
            if (source == null || "".equals(source)) {
                WmsPlugin.log("GetCapabilities SERVICE is required", new ServiceNotFoundException());
                return null;
            }
            if (version == null || "".equals(version)) {
                WmsPlugin.log("GetCapabilities VERSION is required", new ServiceNotFoundException());
                return null;
            }
            IGeoResourceInfo info = resource.getInfo((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            String srs = CRS.toSRS((CoordinateReferenceSystem)info.getCRS());
            WMSTileSet tileset = new WMSTileSet();
            ReferencedEnvelope bounds = info.getBounds();
            if (bounds == null) {
                WmsPlugin.log("Bounds required for TileSet definition", new NullPointerException("Bounds required for tileset definitio"));
                return null;
            }
            double minX = bounds.getMinimum(0);
            double maxX = bounds.getMaximum(0);
            double minY = bounds.getMinimum(1);
            double maxY = bounds.getMaximum(1);
            CRSEnvelope bbox = new CRSEnvelope(srs, minX, minY, maxX, maxY);
            tileset.setBoundingBox(bbox);
            tileset.setCoorindateReferenceSystem(srs);
            Map properties = resource.getPersistentProperties();
            Integer width = Integer.parseInt((String)properties.get("tilesetWidth"));
            Integer height = Integer.parseInt((String)properties.get("tilesetHeight"));
            if (width == null) {
                width = PreferenceConstants.DEFAULT_TILE_SIZE;
            }
            if (height == null) {
                height = PreferenceConstants.DEFAULT_TILE_SIZE;
            }
            tileset.setWidth(width);
            tileset.setHeight(height);
            String imageType = (String)properties.get("tilesetImageType");
            if (imageType == null || "".equals(imageType)) {
                imageType = "image/png";
            }
            tileset.setFormat(imageType);
            tileset.setLayers(info.getName());
            String scales = (String)properties.get("tilesetScales");
            String resolutions = WMSCTileUtils.workoutResolutions(scales, new ReferencedEnvelope((org.opengis.geometry.Envelope)bbox), width);
            if ("".equals(resolutions)) {
                WmsPlugin.log("Resolutions are required for TileSet generation", new ServiceNotFoundException());
                return null;
            }
            tileset.setResolutions(resolutions);
            String style = "";
            if (resource.canResolve(Layer.class)) {
                Layer layer = (Layer)resource.resolve(Layer.class, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                StringBuilder sb = new StringBuilder("");
                for (StyleImpl layerStyle : layer.getStyles()) {
                    sb.append(String.valueOf(layerStyle.getName()) + ",");
                }
                style = sb.toString();
            }
            if (style.length() > 0) {
                tileset.setStyles(style.substring(0, style.length() - 1));
            } else {
                tileset.setStyles(style);
            }
            tileset.setServer(server);
            WMSTileSet wMSTileSet = tileset;
            return wMSTileSet;
        }
        finally {
            monitor.done();
        }
    }

    public static String workoutResolutions(String rawScales, ReferencedEnvelope bounds, int tileWidth) {
        String[] scales = rawScales.split(" ");
        StringBuffer sb = new StringBuffer();
        String[] stringArray = scales;
        int n = scales.length;
        int n2 = 0;
        while (n2 < n) {
            String scale = stringArray[n2];
            Double scaleDouble = Double.parseDouble(scale);
            Double calculatedScale = ScaleUtils.calculateResolutionFromScale((ReferencedEnvelope)bounds, (double)scaleDouble, (int)tileWidth);
            sb.append(calculatedScale + " ");
            ++n2;
        }
        return sb.toString();
    }

    private static class PreloadTilesClass
    implements IRunnableWithProgress {
        TileSet tileset;
        Geometry select;
        private int requestCount;
        private double percentPerTile;
        private IProgressMonitor monitor;
        private Envelope tileRangeBounds;
        private Map<String, Tile> tileRangeTiles;
        private TileWorkerQueue requestTileWorkQueue;
        private TileWorkerQueue writeTileWorkQueue;
        private static int default_maxTileRequestsPerGroup = 16;
        private int maxTileRequestsPerGroup = default_maxTileRequestsPerGroup;
        private BlockingQueue<Tile> tilesCompleted_queue = new PriorityBlockingQueue<Tile>();
        private TileListenerImpl listener = new TileListenerImpl();

        public PreloadTilesClass(TileSet tileset, Geometry select) {
            this.tileset = tileset;
            this.select = select;
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void doRequestAndResetVars(TileSet tileset) {
            Tile tile;
            TileRangeOnDisk tileRangeOnDisk = new TileRangeOnDisk(tileset.getServer(), tileset, this.tileRangeBounds, this.tileRangeTiles, this.requestTileWorkQueue, this.writeTileWorkQueue);
            tileRangeOnDisk.addListener(this.listener);
            HashMap<String, Tile> loadedTiles = new HashMap<String, Tile>();
            Iterator<Map.Entry<String, Tile>> iterator = this.tileRangeTiles.entrySet().iterator();
            while (iterator.hasNext()) {
                Tile tile2 = iterator.next().getValue();
                if (tile2.getBufferedImage() == null) continue;
                loadedTiles.put(tile2.getId(), tile2);
            }
            Iterator iterator2 = loadedTiles.entrySet().iterator();
            while (iterator2.hasNext()) {
                tile = (Tile)iterator2.next().getValue();
                this.tileRangeTiles.remove(tile.getId());
            }
            tileRangeOnDisk.loadTiles((IProgressMonitor)new NullProgressMonitor());
            while (!this.tileRangeTiles.isEmpty()) {
                tile = null;
                try {
                    try {
                        tile = this.tilesCompleted_queue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        if (tile == null) continue;
                        this.tileRangeTiles.remove(tile.getId());
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (tile != null) {
                        this.tileRangeTiles.remove(tile.getId());
                    }
                    throw throwable;
                }
                if (tile == null) continue;
                this.tileRangeTiles.remove(tile.getId());
            }
            this.monitor.worked((int)this.percentPerTile * tileRangeOnDisk.getTileCount());
            this.requestCount = 0;
            this.tileRangeBounds = new Envelope();
            this.tileRangeTiles.clear();
        }

        private void cleanup() {
            this.requestTileWorkQueue.dispose();
            this.writeTileWorkQueue.dispose();
            this.requestTileWorkQueue = null;
            this.writeTileWorkQueue = null;
            this.monitor.done();
        }

        private class TileListenerImpl
        implements TileListener {
            @Override
            public void notifyTileReady(Tile tile) {
                try {
                    PreloadTilesClass.this.tilesCompleted_queue.put(tile);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

