/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms.ui;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wms.WMSGeoResourceImpl;
import net.refractions.udig.catalog.internal.wms.WMSServiceExtension;
import net.refractions.udig.catalog.internal.wms.WMSServiceImpl;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.wms.WebMapServer;

public class WMSConnectionFactory
extends UDIGConnectionFactory {
    public boolean canProcess(Object context) {
        if (context instanceof IResolve) {
            IResolve resolve = (IResolve)context;
            return resolve.canResolve(WebMapServer.class);
        }
        return WMSConnectionFactory.toCapabilitiesURL(context) != null;
    }

    public Map<String, Serializable> createConnectionParameters(Object context) {
        Map<String, Serializable> params;
        if (context instanceof IResolve && !(params = WMSConnectionFactory.createParams((IResolve)context)).isEmpty()) {
            return params;
        }
        URL url = WMSConnectionFactory.toCapabilitiesURL(context);
        if (url != null) {
            List list = CatalogPlugin.getDefault().getLocalCatalog().find(url, null);
            for (IResolve resolve : list) {
                Map<String, Serializable> params2 = WMSConnectionFactory.createParams(resolve);
                if (params2.isEmpty()) continue;
                return params2;
            }
            return WMSConnectionFactory.createParams(url);
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, Serializable> createParams(IResolve handle) {
        if (handle instanceof WMSServiceImpl) {
            WMSServiceImpl wms = (WMSServiceImpl)handle;
            return wms.getConnectionParams();
        }
        if (handle instanceof WMSGeoResourceImpl) {
            WMSGeoResourceImpl layer = (WMSGeoResourceImpl)handle;
            try {
                WMSServiceImpl wms = layer.service((IProgressMonitor)new NullProgressMonitor());
                return wms.getConnectionParams();
            }
            catch (IOException iOException) {
                WMSConnectionFactory.checkedURL(layer.getIdentifier());
            }
        } else if (handle.canResolve(WebMapServer.class)) {
            return WMSConnectionFactory.createParams(handle.getIdentifier());
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, Serializable> createParams(URL url) {
        WMSServiceExtension factory = new WMSServiceExtension();
        Map<String, Serializable> params = factory.createParams(url);
        if (params != null) {
            return params;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY", url);
        return params2;
    }

    static URL toCapabilitiesURL(Object data) {
        if (data instanceof IResolve) {
            return WMSConnectionFactory.toCapabilitiesURL((IResolve)data);
        }
        if (data instanceof URL) {
            return WMSConnectionFactory.toCapabilitiesURL((URL)data);
        }
        if (ID.cast((Object)data) != null) {
            return WMSConnectionFactory.toCapabilitiesURL(ID.cast((Object)data).toURL());
        }
        return null;
    }

    static URL toCapabilitiesURL(IResolve resolve) {
        if (resolve instanceof IService) {
            return WMSConnectionFactory.toCapabilitiesURL((IService)resolve);
        }
        return WMSConnectionFactory.toCapabilitiesURL(resolve.getIdentifier());
    }

    static URL toCapabilitiesURL(IService resolve) {
        if (resolve instanceof WMSServiceImpl) {
            return WMSConnectionFactory.toCapabilitiesURL((WMSServiceImpl)resolve);
        }
        return WMSConnectionFactory.toCapabilitiesURL(resolve.getIdentifier());
    }

    static URL toCapabilitiesURL(WMSServiceImpl wms) {
        return wms.getIdentifier();
    }

    static URL toCapabilitiesURL(URL url) {
        String protocol;
        if (url == null) {
            return null;
        }
        String path = url.getPath() == null ? null : url.getPath().toLowerCase();
        String query = url.getQuery() == null ? null : url.getQuery().toLowerCase();
        String string = protocol = url.getProtocol() == null ? null : url.getProtocol().toLowerCase();
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            return null;
        }
        if (query != null && query.indexOf("service=wms") != -1) {
            return WMSConnectionFactory.checkedURL(url);
        }
        if (query != null && query.indexOf("service=") == -1 && query.indexOf("request=getcapabilities") != -1) {
            try {
                return new URL(String.valueOf(url.toString()) + "&SERVICE=WMS");
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (path != null && path.toUpperCase().indexOf("GEOSERVER/WMS") != -1) {
            return WMSConnectionFactory.checkedURL(url);
        }
        if (url.toExternalForm().indexOf("WMS") != -1) {
            return WMSConnectionFactory.checkedURL(url);
        }
        return null;
    }

    public static URL checkedURL(URL url) {
        String check = url.toExternalForm();
        int tiled = check.toUpperCase().indexOf("TILED=TRUE");
        if (tiled != -1) {
            return null;
        }
        int hash = check.indexOf(35);
        if (hash == -1) {
            return url;
        }
        try {
            return new URL(check.substring(0, hash));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL createConnectionURL(Object context) {
        if (context instanceof URL) {
            return (URL)context;
        }
        return null;
    }
}

