/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.internal.wms.WMSServiceImpl;
import net.refractions.udig.catalog.wms.internal.Messages;

public class WMSServiceExtension
implements ServiceExtension2 {
    public IService createService(URL id, Map<String, Serializable> params) {
        if (params == null) {
            return null;
        }
        if (!params.containsKey("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY") && id == null && !params.containsKey("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_WMS_KEY")) {
            return null;
        }
        URL extractedId = this.extractId(params);
        if (extractedId != null) {
            if (id != null) {
                return new WMSServiceImpl(id, params);
            }
            return new WMSServiceImpl(extractedId, params);
        }
        return null;
    }

    private URL extractId(Map<String, Serializable> params) {
        if (params.containsKey("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY")) {
            URL base = null;
            if (params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY") instanceof URL) {
                base = (URL)params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY");
            } else {
                try {
                    base = new URL((String)((Object)params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY")));
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                    return null;
                }
                params.remove(params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY"));
                params.put("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY", base);
            }
            return base;
        }
        return null;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!WMSServiceExtension.isWMS(url)) {
            return null;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY", url);
        return params2;
    }

    public static boolean isWMS(URL url) {
        return WMSServiceExtension.processURL(url) == null;
    }

    public String reasonForFailure(Map<String, Serializable> params) {
        URL id = this.extractId(params);
        if (id == null) {
            return String.valueOf(Messages.WMSServiceExtension_needsKey) + "net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY" + Messages.WMSServiceExtension_nullValue;
        }
        return this.reasonForFailure(id);
    }

    public String reasonForFailure(URL url) {
        return WMSServiceExtension.processURL(url);
    }

    private static String processURL(URL url) {
        if (url == null) {
            return Messages.WMSServiceExtension_nullURL;
        }
        String PATH = url.getPath();
        String QUERY = url.getQuery();
        String PROTOCOL = url.getProtocol();
        if (PROTOCOL == null || PROTOCOL.indexOf("http") == -1) {
            return String.valueOf(Messages.WMSServiceExtension_protocol) + "'" + PROTOCOL + "'";
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=") != -1) {
            int indexOf = QUERY.toUpperCase().indexOf("SERVICE=");
            if (QUERY.toUpperCase().indexOf("SERVICE=WMS") == -1) {
                int endOfExp = QUERY.indexOf(38, indexOf);
                if (endOfExp == -1) {
                    endOfExp = QUERY.length();
                }
                if (endOfExp > indexOf + 8) {
                    return String.valueOf(Messages.WMSServiceExtension_badService) + QUERY.substring(indexOf + 8, endOfExp);
                }
                return String.valueOf(Messages.WMSServiceExtension_badService);
            }
        } else if (PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WMS") != -1) {
            return null;
        }
        return null;
    }
}

