/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Aggregate", description="Computes one or more aggregation functions on a feature attribute. Functions include Count, Average, Max, Median, Min, StdDev, and Sum.")
public class AggregateProcess
implements VectorProcess {
    public static Results process(SimpleFeatureCollection features, String aggAttribute, Set<AggregationFunction> functions, Boolean singlePass, ProgressListener progressListener) throws ProcessException, IOException {
        AggregateProcess process = new AggregateProcess();
        return process.execute(features, aggAttribute, functions, singlePass, progressListener);
    }

    @DescribeResult(name="result", description="Aggregation results (one value for each function computed)")
    public Results execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="aggregationAttribute", min=0, description="Attribute on which to perform aggregation") String aggAttribute, @DescribeParameter(name="function", description="An aggregate function to compute. Functions include Count, Average, Max, Median, Min, StdDev, and Sum.", collectionType=AggregationFunction.class) Set<AggregationFunction> functions, @DescribeParameter(name="singlePass", description="If True computes all aggregation values in a single pass (this will defeat DBMS-specific optimizations)", defaultValue="false") boolean singlePass, ProgressListener progressListener) throws ProcessException, IOException {
        CountVisitor calc;
        int attIndex = -1;
        List atts = ((SimpleFeatureType)features.getSchema()).getAttributeDescriptors();
        for (int i = 0; i < atts.size(); ++i) {
            if (!((AttributeDescriptor)atts.get(i)).getLocalName().equals(aggAttribute)) continue;
            attIndex = i;
            break;
        }
        if (attIndex == -1) {
            throw new ProcessException("Could not find attribute [" + aggAttribute + "] " + " the valid values are " + this.attNames(atts));
        }
        if (functions == null) {
            throw new NullPointerException("Aggregate function to call is required");
        }
        ArrayList<AggregationFunction> functionList = new ArrayList<AggregationFunction>(functions);
        ArrayList<FeatureCalc> visitors = new ArrayList<FeatureCalc>();
        for (AggregationFunction function : functionList) {
            if (function == AggregationFunction.Average) {
                calc = new AverageVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.Count) {
                calc = new CountVisitor();
            } else if (function == AggregationFunction.Max) {
                calc = new MaxVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.Median) {
                calc = new MedianVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.Min) {
                calc = new MinVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else if (function == AggregationFunction.StdDev) {
                calc = new StandardDeviationVisitor((Expression)CommonFactoryFinder.getFilterFactory(null).property(aggAttribute));
            } else if (function == AggregationFunction.Sum) {
                calc = new SumVisitor(attIndex, (SimpleFeatureType)features.getSchema());
            } else {
                throw new ProcessException("Uknown method " + (Object)((Object)function));
            }
            visitors.add((FeatureCalc)calc);
        }
        EnumMap<AggregationFunction, Number> results = new EnumMap<AggregationFunction, Number>(AggregationFunction.class);
        if (singlePass) {
            AggregateFeatureCalc calc2 = new AggregateFeatureCalc(visitors);
            features.accepts((FeatureVisitor)calc2, (ProgressListener)new NullProgressListener());
            List resultList = (List)calc2.getResult().getValue();
            for (int i = 0; i < functionList.size(); ++i) {
                CalcResult result = (CalcResult)resultList.get(i);
                if (result == null) continue;
                results.put((AggregationFunction)((Enum)functionList.get(i)), (Number)result.getValue());
            }
        } else {
            for (int i = 0; i < functionList.size(); ++i) {
                calc = (FeatureCalc)visitors.get(i);
                features.accepts((FeatureVisitor)calc, (ProgressListener)new NullProgressListener());
                results.put((AggregationFunction)((Enum)functionList.get(i)), (Number)calc.getResult().getValue());
            }
        }
        return new Results(results);
    }

    private List<String> attNames(List<AttributeDescriptor> atts) {
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeDescriptor ad : atts) {
            result.add(ad.getLocalName());
        }
        return result;
    }

    public static final class Results {
        Double min;
        Double max;
        Double median;
        Double average;
        Double standardDeviation;
        Double sum;
        Long count;

        public Results(EnumMap<AggregationFunction, Number> results) {
            this.min = this.toDouble(results.get((Object)AggregationFunction.Min));
            this.max = this.toDouble(results.get((Object)AggregationFunction.Max));
            this.median = this.toDouble(results.get((Object)AggregationFunction.Median));
            this.average = this.toDouble(results.get((Object)AggregationFunction.Average));
            this.standardDeviation = this.toDouble(results.get((Object)AggregationFunction.StdDev));
            this.sum = this.toDouble(results.get((Object)AggregationFunction.Sum));
            Number nc = results.get((Object)AggregationFunction.Count);
            if (nc != null) {
                this.count = nc.longValue();
            }
        }

        Double toDouble(Number number) {
            if (number == null) {
                return null;
            }
            return number.doubleValue();
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getMedian() {
            return this.median;
        }

        public Double getAverage() {
            return this.average;
        }

        public Double getStandardDeviation() {
            return this.standardDeviation;
        }

        public Double getSum() {
            return this.sum;
        }

        public Long getCount() {
            return this.count;
        }
    }

    static class AggregateFeatureCalc
    implements FeatureCalc {
        List<FeatureCalc> delegates;

        public AggregateFeatureCalc(List<FeatureCalc> delegates) {
            this.delegates = delegates;
        }

        public CalcResult getResult() {
            final ArrayList<CalcResult> results = new ArrayList<CalcResult>();
            for (FeatureCalc delegate : this.delegates) {
                results.add(delegate.getResult());
            }
            return new AbstractCalcResult(){

                public Object getValue() {
                    return results;
                }
            };
        }

        public void visit(Feature feature) {
            for (FeatureCalc delegate : this.delegates) {
                delegate.visit(feature);
            }
        }
    }

    public static enum AggregationFunction {
        Count,
        Average,
        Max,
        Median,
        Min,
        StdDev,
        Sum;

    }
}

