/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.browser.ui;

import net.refractions.udig.browser.BrowserPlugin;
import net.refractions.udig.browser.ui.BrowserContainerView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LocationEntry {
    private BrowserContainerView view;
    private Text entry;

    protected LocationEntry(BrowserContainerView view) {
        this.view = view;
    }

    protected Control createControl(Composite parent) {
        this.entry = new Text(parent, 2436);
        this.addKeyboardListener();
        return this.entry;
    }

    private void addKeyboardListener() {
        this.entry.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 13: {
                        LocationEntry.this.updateView(event);
                        break;
                    }
                    case 10: {
                        LocationEntry.this.updateView(event);
                        break;
                    }
                    case 0x1000050: {
                        LocationEntry.this.updateView(event);
                        break;
                    }
                }
            }
        });
    }

    private void updateView(Event event) {
        if ((event.stateMask & SWT.MOD1) != 0) {
            this.view.addTab(this.entry.getText(), this.entry.getText(), this.view.getListener());
        } else {
            this.view.setCurrentURL(this.entry.getText());
        }
    }

    public IAction getButton() {
        Action action = new Action(){

            public void runWithEvent(Event event) {
                LocationEntry.this.updateView(event);
            }
        };
        action.setImageDescriptor(BrowserPlugin.getImageDescriptor("icons/elcl16/go.png"));
        return action;
    }

    public void setText(String location) {
        this.entry.setText(location);
    }
}

