/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.browser.ui;

import java.net.URL;
import net.refractions.udig.browser.ExternalCatalogueImportPage;
import net.refractions.udig.browser.internal.Messages;
import net.refractions.udig.browser.ui.BrowserContainerView;
import net.refractions.udig.browser.ui.BrowserSelectionPage;
import net.refractions.udig.catalog.ui.IDataWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CatalogueBrowserWizard
extends IDataWizard {
    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof ExternalCatalogueImportPage) {
            return true;
        }
        if (page instanceof BrowserSelectionPage) {
            return ((BrowserSelectionPage)page).canFinish();
        }
        return false;
    }

    protected WizardPage[] getPrimaryPages() {
        return new WizardPage[]{new BrowserSelectionPage()};
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.CatalogueBrowserWizard_windowTitle);
    }

    public boolean performFinish() {
        IViewPart part;
        Object page;
        IWizardPage ipage = this.getContainer().getCurrentPage();
        String name = null;
        URL url = null;
        ImageDescriptor image = null;
        LocationListener listen = null;
        if (ipage instanceof BrowserSelectionPage) {
            page = (BrowserSelectionPage)ipage;
            listen = ((BrowserSelectionPage)((Object)page)).getListener();
            url = ((BrowserSelectionPage)((Object)page)).getUrl();
            image = ((BrowserSelectionPage)((Object)page)).getIconDescriptor();
            name = ((BrowserSelectionPage)((Object)page)).getTitle();
        } else {
            page = (ExternalCatalogueImportPage)ipage;
            IWizardPage next = page.getNextPage();
            if (next != null) {
                this.getContainer().showPage(next);
                return false;
            }
            listen = page.getListener();
            url = page.getURL();
            image = page.getIconDescriptor();
            name = page.getTitle();
        }
        IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            part = wbPage.showView("net.refractions.udig.browser.ui.browserContainerView");
        }
        catch (PartInitException partInitException) {
            return false;
        }
        if (!(part instanceof BrowserContainerView)) {
            return false;
        }
        BrowserContainerView view = (BrowserContainerView)part;
        view.addTab(name, url, image, listen);
        return true;
    }
}

