/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.internal;

import java.util.ArrayList;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.StyleEntry;
import org.eclipse.core.runtime.IProgressMonitor;

class ApplyStyleCommand
extends AbstractCommand
implements UndoableCommand {
    StyleBlackboard oldStyleBlackboard;
    StyleBlackboard newStyleBlackboard;
    Layer layer;

    public ApplyStyleCommand(Layer layer, StyleBlackboard oldStyleBlackboard, StyleBlackboard newStyleBlackboard) {
        this.oldStyleBlackboard = oldStyleBlackboard;
        this.newStyleBlackboard = newStyleBlackboard;
        this.layer = layer;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.layer.setStyleBlackboard(this.oldStyleBlackboard);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        ArrayList l = new ArrayList(this.newStyleBlackboard.getContent());
        ArrayList selected = new ArrayList();
        for (StyleEntry entry : l) {
            if (entry.getStyle() == null) continue;
            this.newStyleBlackboard.put(entry.getID(), entry.getStyle());
        }
        this.newStyleBlackboard.setSelected(selected.toArray(new String[selected.size()]));
        this.layer.setStyleBlackboard(this.newStyleBlackboard);
    }

    public String getName() {
        return this.layer.getName();
    }

    public String toString() {
        return "StyleLayer<" + this.getName() + ">";
    }
}

