/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.panel;

import java.text.MessageFormat;
import net.refractions.udig.project.ui.feature.FeaturePanelEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.tabbed.ITabItem;

public class FeaturePanelTabDescriptor
implements ITabItem {
    public static final String TOP = "top";
    private static final String TAB_ERROR = "Tab in {0} must provide an id, label and category.";
    private String id;
    private String label;
    private Image image;
    private boolean selected;
    private boolean indented;
    private String category;
    private String afterTab;
    FeaturePanelEntry entry;

    public FeaturePanelTabDescriptor(FeaturePanelEntry entry) {
        if (entry == null) {
            throw new NullPointerException("Feature Panel Entry required");
        }
        this.id = entry.getId();
        this.label = entry.getName();
        this.image = entry.getImage();
        this.indented = entry.isIndented();
        this.category = entry.getCategory();
        this.afterTab = entry.getAfterPanel();
        if (this.id == null || this.label == null || this.category == null) {
            String message = MessageFormat.format(TAB_ERROR, entry.getId());
            entry.log(message, null);
        }
        this.entry = entry;
        this.selected = false;
    }

    public FeaturePanelEntry getEntry() {
        return this.entry;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getAfterTab() {
        if (this.afterTab == null) {
            return TOP;
        }
        return this.afterTab;
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        return this.getId();
    }

    protected void setImage(Image image) {
        this.image = image;
    }

    protected void setIndented(boolean indented) {
        this.indented = indented;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public String getText() {
        return this.label;
    }
}

