/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.panel;

import net.refractions.udig.feature.panel.FeaturePanelComposite;
import net.refractions.udig.feature.panel.FeaturePanelWidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.views.properties.tabbed.ITabItem;

public class FeaturePanelList
extends Composite {
    private static final ListElement[] ELEMENTS_EMPTY = new ListElement[0];
    protected static final int NONE = -1;
    protected static final int INDENT = 7;
    private boolean focus = false;
    private ListElement[] elements;
    private int selectedElementIndex = -1;
    private int topVisibleIndex = -1;
    private int bottomVisibleIndex = -1;
    private TopNavigationElement topNavigationElement;
    private BottomNavigationElement bottomNavigationElement;
    private int widestLabelIndex = -1;
    private int tabsThatFitInComposite = -1;
    private Color widgetForeground;
    private Color widgetBackground;
    private Color widgetNormalShadow;
    private Color widgetDarkShadow;
    private Color listBackground;
    private Color hoverGradientStart;
    private Color hoverGradientEnd;
    private Color defaultGradientStart;
    private Color defaultGradientEnd;
    private Color indentedDefaultBackground;
    private Color indentedHoverBackground;
    private Color navigationElementShadowStroke;
    private Color bottomNavigationElementShadowStroke1;
    private Color bottomNavigationElementShadowStroke2;
    private FeaturePanelWidgetFactory factory;

    public FeaturePanelList(Composite parent, FeaturePanelWidgetFactory factory) {
        super(parent, 524288);
        this.factory = factory;
        this.removeAll();
        this.setLayout((Layout)new FormLayout());
        this.initColours();
        this.initAccessible();
        this.topNavigationElement = new TopNavigationElement(this);
        this.bottomNavigationElement = new BottomNavigationElement(this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                FeaturePanelList.this.focus = true;
                int i = FeaturePanelList.this.getSelectionIndex();
                if (i >= 0) {
                    FeaturePanelList.this.elements[i].redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                FeaturePanelList.this.focus = false;
                int i = FeaturePanelList.this.getSelectionIndex();
                if (i >= 0) {
                    FeaturePanelList.this.elements[i].redraw();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FeaturePanelList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 32 || e.detail == 64) {
                    int nMax = FeaturePanelList.this.elements.length - 1;
                    int nCurrent = FeaturePanelList.this.getSelectionIndex();
                    if (e.detail == 32) {
                        --nCurrent;
                        nCurrent = Math.max(0, nCurrent);
                    } else if (e.detail == 64) {
                        ++nCurrent;
                        nCurrent = Math.min(nCurrent, nMax);
                    }
                    FeaturePanelList.this.select(nCurrent);
                    FeaturePanelList.this.redraw();
                } else {
                    e.doit = true;
                }
            }
        });
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = Math.round((this.getSize().y - 22) / this.getTabHeight());
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.elements.length) {
            return this.elements[index];
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public void removeAll() {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].dispose();
                ++i;
            }
        }
        this.elements = ELEMENTS_EMPTY;
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
    }

    public void setElements(Object[] children) {
        if (this.elements != ELEMENTS_EMPTY) {
            this.removeAll();
        }
        this.elements = new ListElement[children.length];
        if (children.length == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            int i = 0;
            while (i < children.length) {
                this.elements[i] = new ListElement(this, (ITabItem)children[i], i);
                this.elements[i].setVisible(false);
                this.elements[i].setLayoutData(null);
                if (i != this.widestLabelIndex) {
                    String label = ((ITabItem)children[i]).getText();
                    int width = this.getTextDimension((String)label).x;
                    if (((ITabItem)children[i]).isIndented()) {
                        width += 7;
                    }
                    if (width > this.getTextDimension((String)((ITabItem)children[this.widestLabelIndex]).getText()).x) {
                        this.widestLabelIndex = i;
                    }
                }
                ++i;
            }
        }
        this.computeTopAndBottomTab();
    }

    protected void select(int index) {
        if (this.getSelectionIndex() == index) {
            return;
        }
        if (index >= 0 && index < this.elements.length) {
            int lastSelected = this.getSelectionIndex();
            this.elements[index].setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements[lastSelected].setSelected(false);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements[this.getSelectionIndex()].setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    private int getIndex(ListElement element) {
        return element.index;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(hHint, wHint, changed);
        if (this.widestLabelIndex == -1) {
            String properties_not_available = "Properties are not available.";
            result.x = this.getTextDimension((String)properties_not_available).x + 7;
        } else {
            ITabItem widestTab = this.elements[this.widestLabelIndex].getTabItem();
            int width = this.getTextDimension((String)widestTab.getText()).x + 7;
            if (widestTab.getImage() != null) {
                width = width + 16 + 4;
            }
            if (widestTab.isIndented()) {
                width += 10;
            }
            result.x = width + 10;
        }
        return result;
    }

    private Point getTextDimension(String text) {
        GC gc = new GC((Drawable)this);
        gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        Point point = gc.textExtent(text);
        ++point.x;
        gc.dispose();
        return point;
    }

    private void initColours() {
        this.listBackground = Display.getCurrent().getSystemColor(25);
        this.widgetBackground = Display.getCurrent().getSystemColor(22);
        this.widgetDarkShadow = Display.getCurrent().getSystemColor(17);
        this.widgetForeground = Display.getCurrent().getSystemColor(21);
        this.widgetNormalShadow = Display.getCurrent().getSystemColor(18);
        RGB infoBackground = Display.getCurrent().getSystemColor(29).getRGB();
        RGB white = Display.getCurrent().getSystemColor(1).getRGB();
        RGB black = Display.getCurrent().getSystemColor(2).getRGB();
        this.defaultGradientStart = this.factory.getColors().createColor("TabbedPropertyList.defaultTabGradientStart", FormColors.blend((RGB)infoBackground, (RGB)FormColors.blend((RGB)white, (RGB)this.widgetNormalShadow.getRGB(), (int)20), (int)60));
        this.defaultGradientEnd = this.factory.getColors().createColor("TabbedPropertyList.defaultTabGradientEnd", FormColors.blend((RGB)infoBackground, (RGB)this.widgetNormalShadow.getRGB(), (int)40));
        this.navigationElementShadowStroke = this.factory.getColors().createColor("TabbedPropertyList.shadowStroke", FormColors.blend((RGB)white, (RGB)this.widgetNormalShadow.getRGB(), (int)55));
        this.bottomNavigationElementShadowStroke1 = this.factory.getColors().createColor("TabbedPropertyList.tabShadowStroke1", FormColors.blend((RGB)black, (RGB)this.widgetBackground.getRGB(), (int)10));
        this.bottomNavigationElementShadowStroke2 = this.factory.getColors().createColor("TabbedPropertyList.tabShadowStroke2", FormColors.blend((RGB)black, (RGB)this.widgetBackground.getRGB(), (int)5));
        this.hoverGradientStart = this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientStart", FormColors.blend((RGB)white, (RGB)this.widgetBackground.getRGB(), (int)20));
        this.hoverGradientEnd = this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientEnd", FormColors.blend((RGB)this.widgetNormalShadow.getRGB(), (RGB)this.widgetBackground.getRGB(), (int)10));
        this.indentedDefaultBackground = this.factory.getColors().createColor("TabbedPropertyList.indentedDefaultBackground", FormColors.blend((RGB)white, (RGB)this.widgetBackground.getRGB(), (int)10));
        this.indentedHoverBackground = this.factory.getColors().createColor("TabbedPropertyList.indentedHoverBackground", FormColors.blend((RGB)white, (RGB)this.widgetBackground.getRGB(), (int)75));
    }

    private int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + 7;
        if (this.tabsThatFitInComposite == 1) {
            int ret = this.getBounds().height - 20;
            return ret > tabHeight ? tabHeight : (ret < 5 ? 5 : ret);
        }
        return tabHeight;
    }

    private boolean isDownScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.bottomVisibleIndex != this.elements.length - 1;
    }

    private boolean isUpScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.topVisibleIndex != 0;
    }

    private void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.elements.length == 0) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = 0;
        } else if (this.tabsThatFitInComposite >= this.elements.length) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.elements.length - 1;
        } else if (this.getSelectionIndex() == -1) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.tabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.tabsThatFitInComposite > this.elements.length) {
            this.bottomVisibleIndex = this.elements.length - 1;
            this.topVisibleIndex = this.bottomVisibleIndex - this.tabsThatFitInComposite + 1;
        } else {
            this.topVisibleIndex = this.selectedElementIndex;
            this.bottomVisibleIndex = this.selectedElementIndex + this.tabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    private void layoutTabs() {
        FormData formData;
        if (this.tabsThatFitInComposite == -1 || this.elements.length == 0) {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = this.getTabHeight();
            this.topNavigationElement.setLayoutData(formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.topNavigationElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.bottomNavigationElement.setLayoutData(formData);
        } else {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = 10;
            this.topNavigationElement.setLayoutData(formData);
            Canvas nextElement = this.topNavigationElement;
            int i = 0;
            while (i < this.elements.length) {
                if (i < this.topVisibleIndex || i > this.bottomVisibleIndex) {
                    this.elements[i].setLayoutData(null);
                    this.elements[i].setVisible(false);
                } else {
                    formData = new FormData();
                    formData.height = this.getTabHeight();
                    formData.left = new FormAttachment(0, 0);
                    formData.right = new FormAttachment(100, 0);
                    formData.top = new FormAttachment((Control)nextElement, 0);
                    nextElement = this.elements[i];
                    this.elements[i].setLayoutData(formData);
                    this.elements[i].setVisible(true);
                }
                ++i;
            }
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)nextElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.height = 10;
            this.bottomNavigationElement.setLayoutData(formData);
        }
        Composite grandparent = this.getParent().getParent();
        grandparent.layout(true);
        this.layout(true);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (FeaturePanelList.this.getSelectionIndex() != -1) {
                    e.result = FeaturePanelList.this.elements[FeaturePanelList.this.getSelectionIndex()].getTabItem().getText();
                }
            }

            public void getHelp(AccessibleEvent e) {
                if (FeaturePanelList.this.getSelectionIndex() != -1) {
                    e.result = FeaturePanelList.this.elements[FeaturePanelList.this.getSelectionIndex()].getTabItem().getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = FeaturePanelList.this.toControl(new Point(e.x, e.y));
                e.childID = FeaturePanelList.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                if (FeaturePanelList.this.getSelectionIndex() != -1) {
                    Rectangle location = FeaturePanelList.this.elements[FeaturePanelList.this.getSelectionIndex()].getBounds();
                    Point pt = FeaturePanelList.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 37;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300006;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (FeaturePanelList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    public class BottomNavigationElement
    extends Canvas {
        public BottomNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    BottomNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (FeaturePanelList.this.isDownScrollRequired()) {
                        FeaturePanelList featurePanelList = FeaturePanelList.this;
                        featurePanelList.topVisibleIndex = featurePanelList.topVisibleIndex + 1;
                        if (FeaturePanelList.this.bottomVisibleIndex != FeaturePanelList.this.elements.length - 1) {
                            FeaturePanelList featurePanelList2 = FeaturePanelList.this;
                            featurePanelList2.bottomVisibleIndex = featurePanelList2.bottomVisibleIndex + 1;
                        }
                        FeaturePanelList.this.layoutTabs();
                        FeaturePanelList.this.topNavigationElement.redraw();
                        FeaturePanelList.this.bottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(FeaturePanelList.this.widgetBackground);
            e.gc.setForeground(FeaturePanelList.this.widgetForeground);
            Rectangle bounds = this.getBounds();
            if (FeaturePanelList.this.elements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(FeaturePanelList.this.widgetNormalShadow);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
                e.gc.drawLine(0, 0, bounds.width - 1, 0);
                e.gc.setForeground(FeaturePanelList.this.bottomNavigationElementShadowStroke1);
                e.gc.drawLine(0, 1, bounds.width - 2, 1);
                e.gc.setForeground(FeaturePanelList.this.bottomNavigationElementShadowStroke2);
                e.gc.drawLine(0, 2, bounds.width - 2, 2);
            } else {
                e.gc.setBackground(FeaturePanelList.this.listBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            if (FeaturePanelList.this.isDownScrollRequired()) {
                e.gc.setForeground(FeaturePanelList.this.widgetDarkShadow);
                int middle = bounds.width / 2;
                int bottom = bounds.height - 3;
                e.gc.drawLine(middle + 1, bottom, middle + 5, bottom - 4);
                e.gc.drawLine(middle, bottom, middle - 4, bottom - 4);
                e.gc.drawLine(middle - 3, bottom - 4, middle + 4, bottom - 4);
                e.gc.setForeground(FeaturePanelList.this.listBackground);
                e.gc.drawLine(middle, bottom - 1, middle + 1, bottom - 1);
                e.gc.drawLine(middle - 1, bottom - 2, middle + 2, bottom - 2);
                e.gc.drawLine(middle - 2, bottom - 3, middle + 3, bottom - 3);
                e.gc.setForeground(FeaturePanelList.this.widgetNormalShadow);
                e.gc.drawLine(0, bottom - 7, bounds.width - 2, bottom - 7);
                e.gc.setForeground(FeaturePanelList.this.navigationElementShadowStroke);
                e.gc.drawLine(0, bottom + 2, bounds.width - 2, bottom + 2);
                e.gc.drawLine(0, bottom - 6, bounds.width - 2, bottom - 6);
            }
        }
    }

    public class ListElement
    extends Canvas {
        private ITabItem tab;
        private int index;
        private boolean selected;
        private boolean hover;

        public ListElement(Composite parent, ITabItem tab, int index) {
            super(parent, 524288);
            this.tab = tab;
            this.hover = false;
            this.selected = false;
            this.index = index;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    ListElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!ListElement.this.selected) {
                        FeaturePanelList.this.select(FeaturePanelList.this.getIndex(ListElement.this));
                        Composite tabbedPropertyComposite = ListElement.this.getParent();
                        while (!(tabbedPropertyComposite instanceof FeaturePanelComposite)) {
                            tabbedPropertyComposite = tabbedPropertyComposite.getParent();
                        }
                        tabbedPropertyComposite.setFocus();
                    }
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (!ListElement.this.hover) {
                        ListElement.this.hover = true;
                        ListElement.this.redraw();
                    }
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    ListElement.this.hover = false;
                    ListElement.this.redraw();
                }
            });
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.redraw();
        }

        private void paint(PaintEvent e) {
            Rectangle bounds = this.getBounds();
            e.gc.setForeground(FeaturePanelList.this.widgetNormalShadow);
            e.gc.drawLine(0, 0, bounds.width - 1, 0);
            e.gc.setForeground(FeaturePanelList.this.listBackground);
            e.gc.drawLine(0, 1, bounds.width - 1, 1);
            if (this.selected) {
                e.gc.setBackground(FeaturePanelList.this.listBackground);
                e.gc.fillRectangle(0, 2, bounds.width, bounds.height - 1);
            } else if (this.hover && this.tab.isIndented()) {
                e.gc.setBackground(FeaturePanelList.this.indentedHoverBackground);
                e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
            } else if (this.hover) {
                e.gc.setForeground(FeaturePanelList.this.hoverGradientStart);
                e.gc.setBackground(FeaturePanelList.this.hoverGradientEnd);
                e.gc.fillGradientRectangle(0, 2, bounds.width - 1, bounds.height - 1, true);
            } else if (this.tab.isIndented()) {
                e.gc.setBackground(FeaturePanelList.this.indentedDefaultBackground);
                e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setForeground(FeaturePanelList.this.defaultGradientStart);
                e.gc.setBackground(FeaturePanelList.this.defaultGradientEnd);
                e.gc.fillGradientRectangle(0, 2, bounds.width - 1, bounds.height - 1, true);
            }
            if (!this.selected) {
                e.gc.setForeground(FeaturePanelList.this.widgetNormalShadow);
                e.gc.drawLine(bounds.width - 1, 1, bounds.width - 1, bounds.height + 1);
            }
            int textIndent = 7;
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            if (this.selected && this.tab.getImage() != null && !this.tab.getImage().isDisposed()) {
                textIndent = this.tab.isIndented() ? (textIndent += 7) : (textIndent -= 3);
                e.gc.drawImage(this.tab.getImage(), textIndent, textMiddle - 1);
                textIndent = textIndent + 16 + 5;
            } else if (this.tab.isIndented()) {
                textIndent += 7;
            }
            e.gc.setForeground(FeaturePanelList.this.widgetForeground);
            if (this.selected) {
                e.gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            }
            e.gc.drawText(this.tab.getText(), textIndent, textMiddle, true);
            if (((FeaturePanelList)this.getParent()).focus && this.selected) {
                Point point = e.gc.textExtent(this.tab.getText());
                e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
            }
            if (!this.hover) {
                e.gc.setForeground(FeaturePanelList.this.listBackground);
                e.gc.drawLine(0, bounds.height - 1, bounds.width - 2, bounds.height - 1);
            }
        }

        public ITabItem getTabItem() {
            return this.tab;
        }

        public String toString() {
            return this.tab.getText();
        }
    }

    public class TopNavigationElement
    extends Canvas {
        public TopNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    TopNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (FeaturePanelList.this.isUpScrollRequired()) {
                        FeaturePanelList featurePanelList = FeaturePanelList.this;
                        featurePanelList.bottomVisibleIndex = featurePanelList.bottomVisibleIndex - 1;
                        if (FeaturePanelList.this.topVisibleIndex != 0) {
                            FeaturePanelList featurePanelList2 = FeaturePanelList.this;
                            featurePanelList2.topVisibleIndex = featurePanelList2.topVisibleIndex - 1;
                        }
                        FeaturePanelList.this.layoutTabs();
                        FeaturePanelList.this.topNavigationElement.redraw();
                        FeaturePanelList.this.bottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(FeaturePanelList.this.widgetBackground);
            e.gc.setForeground(FeaturePanelList.this.widgetForeground);
            Rectangle bounds = this.getBounds();
            if (FeaturePanelList.this.elements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(FeaturePanelList.this.widgetNormalShadow);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setBackground(FeaturePanelList.this.listBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                int textIndent = 7;
                FontMetrics fm = e.gc.getFontMetrics();
                int height = fm.getHeight();
                int textMiddle = (bounds.height - height) / 2;
                e.gc.setForeground(FeaturePanelList.this.widgetForeground);
                String properties_not_available = "Attributes are not available";
                e.gc.drawText(properties_not_available, textIndent, textMiddle);
            }
            if (FeaturePanelList.this.isUpScrollRequired()) {
                e.gc.setForeground(FeaturePanelList.this.widgetDarkShadow);
                int middle = bounds.width / 2;
                e.gc.drawLine(middle + 1, 3, middle + 5, 7);
                e.gc.drawLine(middle, 3, middle - 4, 7);
                e.gc.drawLine(middle - 3, 7, middle + 4, 7);
                e.gc.setForeground(FeaturePanelList.this.listBackground);
                e.gc.drawLine(middle, 4, middle + 1, 4);
                e.gc.drawLine(middle - 1, 5, middle + 2, 5);
                e.gc.drawLine(middle - 2, 6, middle + 3, 6);
                e.gc.setForeground(FeaturePanelList.this.widgetNormalShadow);
                e.gc.drawLine(0, 0, bounds.width - 2, 0);
                e.gc.setForeground(FeaturePanelList.this.navigationElementShadowStroke);
                e.gc.drawLine(0, 1, bounds.width - 2, 1);
                e.gc.drawLine(0, bounds.height - 1, bounds.width - 2, bounds.height - 1);
            }
        }
    }
}

