/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import net.refractions.udig.feature.editor.field.AttributeField;
import net.refractions.udig.project.ui.feature.EditFeature;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.geotools.feature.type.Types;
import org.geotools.util.Converters;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class StringAttributeField
extends AttributeField {
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    protected boolean isValid;
    protected String oldValue;
    protected Text textField;
    private int widthInChars = UNLIMITED;
    protected int textLimit = UNLIMITED;
    protected boolean multi = false;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private int validateStrategy = 0;
    private boolean required;

    protected StringAttributeField() {
    }

    public StringAttributeField(String name, String labelText, int width, int strategy, Composite parent, int control_style) {
        if (control_style == 1) {
            this.multi = true;
        }
        this.init(name, labelText);
        this.widthInChars = width;
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.errorMessage = "Text not valid";
        this.createControl(parent);
    }

    public StringAttributeField(String name, String labelText, int width, Composite parent, int control_style) {
        this(name, labelText, width, 0, parent, control_style);
    }

    public StringAttributeField(String name, String labelText, Composite parent, int control_style) {
        this(name, labelText, UNLIMITED, control_style, parent, control_style);
    }

    public StringAttributeField(String name, String labelText, Composite parent) {
        this(name, labelText, UNLIMITED, parent, 0);
    }

    @Override
    public void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    public boolean checkState() {
        String txt;
        boolean result = false;
        if (this.emptyStringAllowed) {
            result = true;
        }
        if (this.textField == null) {
            result = false;
        }
        result = (txt = this.textField.getText()).trim().length() > 0 || this.emptyStringAllowed;
        boolean bl = result = result && this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected boolean doCheckState() {
        EditFeature feature = this.getFeature();
        if (feature == null) {
            return true;
        }
        SimpleFeatureType schema = feature.getFeatureType();
        AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
        if (descriptor == null) {
            return false;
        }
        String text = this.textField.getText();
        if (text == null || text.length() == 0) {
            return !descriptor.isNillable();
        }
        Object value = Converters.convert((Object)text, (Class)descriptor.getType().getBinding());
        try {
            Types.validate((AttributeDescriptor)descriptor, (Object)value);
            if (this.isRequired() && value == null) {
                this.errorMessage = String.valueOf(this.getAttributeName()) + " is required";
                this.showErrorMessage(this.errorMessage);
                return false;
            }
            return true;
        }
        catch (IllegalAttributeException bad) {
            this.errorMessage = bad.getLocalizedMessage();
            return false;
        }
    }

    boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    protected void doFillIntoGrid(final Composite parent, int numColumns) {
        Point extent;
        GC gc;
        Label label = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.textField = this.getTextControl(parent);
        gd = new GridData();
        gd.horizontalIndent = 5;
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            gc = new GC((Drawable)this.textField);
            try {
                extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        if (this.multi) {
            gc = new GC((Drawable)this.textField);
            try {
                extent = gc.textExtent("X");
                gd.heightHint = extent.y * 3;
            }
            finally {
                gc.dispose();
            }
        }
        this.textField.setLayoutData((Object)gd);
        if (this.multi) {
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    int numLines = StringAttributeField.this.textField.getLineCount();
                    GridData gd = (GridData)StringAttributeField.this.textField.getLayoutData();
                    GC gc = new GC((Drawable)StringAttributeField.this.textField);
                    Point extent = gc.textExtent("X");
                    if (numLines >= 3) {
                        if (gd.heightHint / extent.y > numLines + 1) {
                            try {
                                gd.heightHint = extent.y * numLines--;
                            }
                            finally {
                                gc.dispose();
                            }
                        } else {
                            try {
                                gd.heightHint = extent.y * numLines++;
                            }
                            finally {
                                gc.dispose();
                            }
                        }
                    } else {
                        try {
                            gd.heightHint = extent.y * 3;
                        }
                        finally {
                            gc.dispose();
                        }
                    }
                    parent.layout();
                }
            });
        }
    }

    @Override
    public void doLoad() {
        if (this.textField != null && this.getFeature() != null) {
            Object value = this.getFeature().getAttribute(this.getAttributeName());
            String text = (String)Converters.convert((Object)value, String.class);
            if (text == null) {
                text = "";
            }
            this.textField.setText(text);
            this.oldValue = text;
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.textField != null) {
            SimpleFeatureType schema = this.getFeature().getFeatureType();
            AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
            Object value = descriptor.getDefaultValue();
            String text = (String)Converters.convert((Object)value, String.class);
            this.textField.setText(text);
        }
        this.valueChanged();
    }

    @Override
    protected void doStore() {
        SimpleFeatureType schema = this.getFeature().getFeatureType();
        AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
        String text = this.textField.getText();
        Object value = Converters.convert((Object)text, (Class)descriptor.getType().getBinding());
        this.getFeature().setAttribute(this.getAttributeName(), value);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        Object value = this.getFeature().getAttribute(this.getAttributeName());
        String text = (String)Converters.convert((Object)value, String.class);
        return text;
    }

    protected Text getTextControl() {
        return this.textField;
    }

    public Text getControl() {
        return this.textField;
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = this.multi ? new Text(parent, 2050) : new Text(parent, 2052);
            this.textField.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            StringAttributeField.this.valueChanged();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            StringAttributeField.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            StringAttributeField.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            StringAttributeField.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            StringAttributeField.this.valueChanged();
                            StringAttributeField.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    StringAttributeField.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean b) {
        this.emptyStringAllowed = b;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    @Override
    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("attribute_field_is_valid", oldState, this.isValid);
        }
        this.textField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                StringAttributeField.this.refreshValidState();
            }

            public void focusLost(FocusEvent e) {
                String newValue = StringAttributeField.this.textField.getText();
                if (!newValue.equals(StringAttributeField.this.oldValue)) {
                    StringAttributeField.this.fireValueChanged("attribute_field_value", StringAttributeField.this.oldValue, newValue);
                    StringAttributeField.this.oldValue = newValue;
                    System.out.println("oldValue");
                }
                StringAttributeField.this.clearErrorMessage();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setVisible(visible);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setEnabled(enabled);
        }
    }
}

