/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import net.refractions.udig.feature.editor.field.AttributeField;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public abstract class ListAttributeField
extends AttributeField {
    private List list;
    private Composite buttonBox;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;

    protected ListAttributeField() {
    }

    protected ListAttributeField(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }

    @Override
    public void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "add an Action");
        this.removeButton = this.createPushButton(box, "remove an Action");
        this.upButton = this.createPushButton(box, "move Action up");
        this.downButton = this.createPushButton(box, "move Action down");
    }

    protected abstract String createList(String[] var1);

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels(button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private int convertHorizontalDLUsToPixels(Button control, int buttonWidth) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)buttonWidth * horizontalDialogUnitSize);
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ListAttributeField.this.addButton) {
                    ListAttributeField.this.addPressed();
                } else if (widget == ListAttributeField.this.removeButton) {
                    ListAttributeField.this.removePressed();
                } else if (widget == ListAttributeField.this.upButton) {
                    ListAttributeField.this.upPressed();
                } else if (widget == ListAttributeField.this.downButton) {
                    ListAttributeField.this.downPressed();
                } else if (widget == ListAttributeField.this.list) {
                    ListAttributeField.this.selectionChanged();
                }
            }
        };
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    @Override
    public void doLoad() {
        if (this.list != null) {
            Object value = this.getFeature().getAttribute(this.getAttributeName());
            String text = (String)Converters.convert((Object)value, String.class);
            String[] array = this.parseString(text);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            SimpleFeatureType schema = this.getFeature().getFeatureType();
            AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
            Object value = descriptor.getDefaultValue();
            String text = (String)Converters.convert((Object)value, String.class);
            String[] array = this.parseString(text);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
    }

    @Override
    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.getFeature().setAttribute(this.getAttributeName(), (Object)s);
        }
    }

    private void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListAttributeField.this.addButton = null;
                    ListAttributeField.this.removeButton = null;
                    ListAttributeField.this.upButton = null;
                    ListAttributeField.this.downButton = null;
                    ListAttributeField.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListAttributeField.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    public List getControl() {
        return this.list;
    }

    protected abstract String getNewInputObject();

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected abstract String[] parseString(String var1);

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            this.list.remove(index);
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    @Override
    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    private void upPressed() {
        this.swap(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.list != null && this.list.isDisposed()) {
            this.list.setEnabled(enabled);
            this.addButton.setEnabled(enabled);
            this.removeButton.setEnabled(enabled);
            this.upButton.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
        }
    }

    @Override
    public void setVisible(boolean visble) {
        super.setVisible(visble);
        if (this.list != null && this.list.isDisposed()) {
            this.list.setVisible(visble);
            this.addButton.setVisible(visble);
            this.removeButton.setVisible(visble);
            this.upButton.setVisible(visble);
            this.downButton.setVisible(visble);
        }
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getUpButton() {
        return this.upButton;
    }

    protected Button getDownButton() {
        return this.downButton;
    }

    protected List getList() {
        return this.list;
    }
}

