/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import java.util.Calendar;
import java.util.Date;
import net.refractions.udig.feature.editor.field.AttributeField;
import net.refractions.udig.project.ui.feature.EditFeature;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.geotools.feature.type.Types;
import org.geotools.util.Converters;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class DateTimeAttributeField
extends AttributeField {
    private boolean isValid;
    protected Date oldValue;
    protected DateTime dateTime;
    protected String errorMessage;

    protected DateTimeAttributeField(String name, String label, Composite parent) {
        this.init(name, label);
        this.isValid = false;
        this.errorMessage = "Date not valid";
        this.createControl(parent);
    }

    @Override
    public void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.dateTime.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.dateTime = this.getDateTimeControl(parent);
        gd = new GridData();
        gd.horizontalIndent = 5;
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
    }

    private DateTime getDateTimeControl(Composite parent) {
        if (this.dateTime == null) {
            this.dateTime = new DateTime(parent, 268435492);
            this.dateTime.setFont(parent.getFont());
            this.dateTime.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    DateTimeAttributeField.this.valueChanged();
                }
            });
            this.dateTime.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    DateTimeAttributeField.this.valueChanged();
                }
            });
            this.dateTime.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    DateTimeAttributeField.this.dateTime = null;
                }
            });
        } else {
            this.checkParent((Control)this.dateTime, parent);
        }
        return this.dateTime;
    }

    @Override
    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    private Date toDate() {
        if (this.dateTime == null || this.dateTime.isDisposed()) {
            return null;
        }
        int day = this.dateTime.getDay();
        int month = this.dateTime.getMonth();
        int year = this.dateTime.getYear();
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date newValue = calendar.getTime();
        return newValue;
    }

    protected boolean checkState() {
        boolean result = false;
        if (this.dateTime == null || this.dateTime.isDisposed()) {
            result = false;
        } else {
            Date date = this.toDate();
            result = this.checkState(date);
        }
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected boolean checkState(Date date) {
        EditFeature feature = this.getFeature();
        if (feature == null) {
            return false;
        }
        SimpleFeatureType schema = feature.getFeatureType();
        AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
        if (descriptor == null) {
            return false;
        }
        Class binding = descriptor.getType().getBinding();
        Object value = Converters.convert((Object)date, (Class)binding);
        try {
            Types.validate((AttributeDescriptor)descriptor, (Object)value);
            return true;
        }
        catch (IllegalAttributeException bad) {
            this.errorMessage = bad.getLocalizedMessage();
            return false;
        }
    }

    protected void valueChanged() {
        Date newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("attribute_field_is_valid", oldState, this.isValid);
        }
        if (!(newValue = this.toDate()).equals(this.oldValue)) {
            this.fireValueChanged("attribute_field_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    @Override
    public void doLoad() {
        if (this.dateTime != null && this.getFeature() != null) {
            Object value = this.getFeature().getAttribute(this.getAttributeName());
            Date date = (Date)Converters.convert((Object)value, Date.class);
            if (date == null) {
                date = new Date();
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            int day = cal.get(5);
            int month = cal.get(2);
            this.dateTime.setDate(year, month, day);
            this.oldValue = date;
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.dateTime != null && this.getFeature() != null) {
            SimpleFeatureType schema = this.getFeature().getFeatureType();
            AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
            Object value = descriptor.getDefaultValue();
            Date date = (Date)Converters.convert((Object)value, Date.class);
            if (date == null) {
                date = new Date();
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            int day = cal.get(5);
            int month = cal.get(2);
            this.dateTime.setDate(year, month, day);
            this.oldValue = date;
        }
        this.valueChanged();
    }

    @Override
    protected void doStore() {
        SimpleFeatureType schema = this.getFeature().getFeatureType();
        AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
        int year = this.dateTime.getYear();
        int day = this.dateTime.getDay();
        int month = this.dateTime.getMonth();
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        Date date = cal.getTime();
        Object value = Converters.convert((Object)date, (Class)descriptor.getType().getBinding());
        this.getFeature().setAttribute(this.getAttributeName(), value);
    }

    @Override
    public Control getControl() {
        return this.dateTime;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }
}

