/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor;

import net.refractions.udig.feature.panel.FeaturePanelPage;
import net.refractions.udig.feature.panel.FeaturePanelPageContributor;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureView
extends PageBookView
implements FeaturePanelPageContributor {
    public static final String ID = "net.refractions.udig.feature.editor.featureView";
    private IWorkbenchPart currentPart;
    private IMap currentMap;
    private ISelectionListener workbenchListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection sel) {
            if (sel == null || !FeatureView.this.isImportant(part)) {
                return;
            }
            FeatureView.this.setContributor(part);
        }
    };
    private IEditManagerListener editListener = new IEditManagerListener(){

        public void changed(EditManagerEvent event) {
            ISelectionListener notifyPage;
            IPage page;
            StructuredSelection sel;
            if (event.getType() == 5) {
                sel = new StructuredSelection(event.getNewValue());
                page = FeatureView.this.getCurrentPage();
                if (page != null && page instanceof ISelectionListener) {
                    notifyPage = (ISelectionListener)page;
                    notifyPage.selectionChanged((IWorkbenchPart)FeatureView.this, (ISelection)sel);
                }
            }
            if (event.getType() == 0) {
                sel = new StructuredSelection(event.getNewValue());
                page = FeatureView.this.getCurrentPage();
                if (page != null && page instanceof ISelectionListener) {
                    notifyPage = (ISelectionListener)page;
                    notifyPage.selectionChanged((IWorkbenchPart)FeatureView.this, (ISelection)sel);
                }
            }
        }
    };

    public void setContributor(IWorkbenchPart part) {
        IPage page;
        if (this.currentPart == part) {
            return;
        }
        if (this.currentPart != null && this.currentMap != null) {
            IEditManager editManager = this.currentMap.getEditManager();
            editManager.removeListener(this.editListener);
        }
        this.currentPart = part;
        StructuredSelection editSelection = null;
        if (this.currentPart != null && this.currentMap != null) {
            IEditManager editManager = this.currentMap.getEditManager();
            editManager.addListener(this.editListener);
            editSelection = new StructuredSelection((Object)editManager.getEditFeature());
        }
        if ((page = this.getCurrentPage()) != null && page instanceof ISelectionListener) {
            ISelectionListener notifyPage = (ISelectionListener)page;
            notifyPage.selectionChanged(part, editSelection);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addSelectionListener(this.workbenchListener);
        super.init(site);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener(this.workbenchListener);
        if (this.currentPart != null) {
            IMap map = (IMap)this.currentPart.getAdapter(IMap.class);
            if (map != null) {
                map.getEditManager().removeListener(this.editListener);
            }
            this.currentPart = null;
        }
        if (this.currentMap != null) {
            this.currentMap.getEditManager().removeListener(this.editListener);
            this.currentMap = null;
        }
    }

    @Override
    public SimpleFeatureType getSchema() {
        if (this.getCurrentContributingPart() != null) {
            this.setContributor(this.getCurrentContributingPart());
        }
        return this.getSchema(this.currentPart);
    }

    private SimpleFeatureType getSchema(IWorkbenchPart part) {
        IMap map = (IMap)part.getAdapter(IMap.class);
        if (map == null) {
            return null;
        }
        IEditManager editManager = map.getEditManager();
        if (editManager == null) {
            return null;
        }
        ILayer selectedLayer = editManager.getSelectedLayer();
        if (selectedLayer == null) {
            return null;
        }
        return selectedLayer.getSchema();
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.setMessage("Default Page");
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IMap map = (IMap)part.getAdapter(IMap.class);
        if (map == null) {
            MessagePage page = new MessagePage();
            page.setMessage("Please select a Map");
            this.initPage((IPageBookViewPage)page);
            page.createControl((Composite)this.getPageBook());
            PageBookView.PageRec rec = new PageBookView.PageRec(part, (IPage)page);
            return rec;
        }
        this.setContributor(part);
        FeaturePanelPage page = new FeaturePanelPage(this);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IMap map = (IMap)editor.getAdapter(IMap.class);
        if (map == null) {
            return null;
        }
        return editor;
    }

    public boolean isImportant(IWorkbenchPart part) {
        return FeatureView.toMap(part) != null;
    }

    public static IMap toMap(IWorkbenchPart part) {
        IMap map = (IMap)part.getAdapter(IMap.class);
        if (map != null) {
            return map;
        }
        ILayer layer = (ILayer)part.getAdapter(ILayer.class);
        if (layer != null) {
            return layer.getMap();
        }
        return null;
    }

    public static ILayer toLayer(IWorkbenchPart part) {
        ILayer layer = (ILayer)part.getAdapter(ILayer.class);
        if (layer != null) {
            return layer;
        }
        IMap map = (IMap)part.getAdapter(IMap.class);
        if (map != null) {
            return map.getEditManager().getSelectedLayer();
        }
        return null;
    }

    public static ILayer toEditLayer(IWorkbenchPart part) {
        IMap map = (IMap)part.getAdapter(IMap.class);
        if (map != null) {
            return map.getEditManager().getEditLayer();
        }
        ILayer layer = (ILayer)part.getAdapter(ILayer.class);
        if (layer != null && layer == layer.getMap().getEditManager().getEditLayer()) {
            return layer;
        }
        return null;
    }

    public static ILayer toLayer(ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object item : sel) {
                ILayer layer;
                if (item instanceof ILayer) {
                    return (ILayer)item;
                }
                if (item instanceof IAdaptable && (layer = (ILayer)((IAdaptable)item).getAdapter(ILayer.class)) != null) {
                    return layer;
                }
                if (!(item instanceof IMap)) continue;
                return ((IMap)item).getEditManager().getSelectedLayer();
            }
        }
        return null;
    }
}

