/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor;

import net.refractions.udig.feature.editor.internal.Messages;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.opengis.feature.simple.SimpleFeature;

public class DefaultEditor
extends ViewPart
implements IUDIGView {
    private IToolContext context;
    private PropertySheetPage featureDisplay;
    private SimpleFeature current;
    IAdaptable defaultSource = new IAdaptable(){

        public Object getAdapter(Class adapter) {
            if (IPropertySource.class.isAssignableFrom(adapter)) {
                return new IPropertySource(){

                    public void setPropertyValue(Object id, Object value) {
                    }

                    public void resetPropertyValue(Object id) {
                    }

                    public boolean isPropertySet(Object id) {
                        return false;
                    }

                    public Object getPropertyValue(Object id) {
                        return "";
                    }

                    public IPropertyDescriptor[] getPropertyDescriptors() {
                        return new PropertyDescriptor[]{new PropertyDescriptor((Object)"ID", Messages.DefaultEditor_1)};
                    }

                    public Object getEditableValue() {
                        return null;
                    }
                };
            }
            return null;
        }
    };

    public void setContext(IToolContext context) {
        this.context = context;
    }

    public IToolContext getContext() {
        return this.context;
    }

    public void editFeatureChanged(SimpleFeature feature) {
        this.current = feature;
        Object value = this.defaultSource;
        value = this.current != null ? this.current : this.defaultSource;
        StructuredSelection selection = new StructuredSelection(value);
        this.featureDisplay.selectionChanged(null, (ISelection)selection);
    }

    public void createPartControl(Composite parent) {
        this.featureDisplay = new PropertySheetPage();
        this.featureDisplay.createControl(parent);
        IMap map = ApplicationGIS.getActiveMap();
        if (map != ApplicationGIS.NO_MAP) {
            try {
                this.editFeatureChanged(map.getEditManager().getEditFeature());
            }
            catch (Throwable e) {
                UiPlugin.log((String)"Default SimpleFeature Editor threw an exception", (Throwable)e);
            }
        }
    }

    public void setFocus() {
        this.featureDisplay.setFocus();
        if (this.current == null) {
            this.featureDisplay.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.defaultSource));
        }
    }
}

