/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.core.Util;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ViewPart;

abstract class AbstractPageBookView<K>
extends ViewPart {
    private PageBook book;
    private PageRec<K> defaultPageRec;
    private Map<K, PageRec<K>> mapPartToRec = new HashMap<K, PageRec<K>>();
    private PageRec<K> activeRec;
    private IWorkbenchPart hiddenPart = null;
    private IPropertyChangeListener actionBarPropListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.ui.internal.actionHandlers") && AbstractPageBookView.this.activeRec != null && event.getSource() == ((AbstractPageBookView)AbstractPageBookView.this).activeRec.subActionBars) {
                AbstractPageBookView.this.refreshGlobalActionHandlers();
            }
        }
    };
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractPageBookView.this.pageSelectionChanged(event);
        }
    };
    private ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractPageBookView.this.postSelectionChanged(event);
        }
    };
    private boolean viewInPage = true;
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            AbstractPageBookView.this.viewInPage = page.findViewReference(AbstractPageBookView.this.getViewSite().getId()) != null;
            AbstractPageBookView.this.activated(AbstractPageBookView.this.getBootstrapTarget());
        }
    };
    ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            AbstractPageBookView.this.track(part, selection);
        }
    };
    IWorkbenchPart currentPart = null;
    private IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            this.partActivated(part);
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == null) {
                return;
            }
            Object target = AbstractPageBookView.this.getCurrent(part);
            if (target != null) {
                AbstractPageBookView.this.activated(target);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            Object target = AbstractPageBookView.this.getCurrent(part);
            if (target != null) {
                AbstractPageBookView.this.activated(target);
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == null) {
                return;
            }
            Object target = AbstractPageBookView.this.getCurrent(part);
            if (target != null) {
                AbstractPageBookView.this.closed(target);
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            Object target;
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && (target = AbstractPageBookView.this.getCurrent(part)) != null) {
                AbstractPageBookView.this.closed(target);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            Object target = AbstractPageBookView.this.getCurrent(partRef);
            if (target != null) {
                AbstractPageBookView.this.broughtToTop(target);
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            Object target = AbstractPageBookView.this.getCurrent(partRef);
            if (target != null) {
                AbstractPageBookView.this.deactivated(target);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            Object target = AbstractPageBookView.this.getCurrent(partRef);
            if (target != null) {
                AbstractPageBookView.this.hidden(target);
            }
        }

        protected void partVisible(IWorkbenchPart part) {
            if (part == null || part != AbstractPageBookView.this.hiddenPart) {
                return;
            }
            this.partActivated(part);
        }

        protected void partHidden(IWorkbenchPart part) {
            IViewPart[] viewStack;
            if (part == null || part != AbstractPageBookView.this.getCurrentContributingPart()) {
                return;
            }
            if (AbstractPageBookView.this.getSite().getPage().getPartState(AbstractPageBookView.this.getSite().getPage().getReference(part)) == 0) {
                return;
            }
            if (part instanceof IViewPart && AbstractPageBookView.this.containsPart(viewStack = AbstractPageBookView.this.getSite().getPage().getViewStack((IViewPart)AbstractPageBookView.this), part)) {
                return;
            }
            AbstractPageBookView.this.hiddenPart = part;
            AbstractPageBookView.this.showPageRec(AbstractPageBookView.this.defaultPageRec);
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            Object target = AbstractPageBookView.this.getCurrent(partRef);
            if (target != null) {
                AbstractPageBookView.this.opened(target);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            Object target = AbstractPageBookView.this.getCurrent(partRef);
            if (target != null) {
                AbstractPageBookView.this.visible(target);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            Object target = AbstractPageBookView.this.getCurrent(partRef);
            if (target != null) {
                AbstractPageBookView.this.inputChanged(target);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            Object target = AbstractPageBookView.this.getCurrent(part);
            if (target != null) {
                AbstractPageBookView.this.deactivated(target);
            }
        }

        public void partOpened(IWorkbenchPart part) {
            Object target = AbstractPageBookView.this.getCurrent(part);
            if (target != null) {
                AbstractPageBookView.this.opened(target);
            }
        }
    };
    private SelectionProvider selectionProvider = new SelectionProvider();

    public void track(IWorkbenchPart part, ISelection selection) {
        K target;
        if (part != null && this.currentPart != part) {
            boolean canTrack;
            target = this.getCurrent(part);
            boolean bl = canTrack = target != null;
            if (canTrack) {
                this.listen(false, this.currentPart);
                this.listen(true, part);
            }
        } else {
            target = this.getCurrent(selection);
        }
        if (target == null) {
            this.showPageRec(this.defaultPageRec);
            return;
        }
        this.activated(target);
    }

    protected <T> T selection(ISelection selection, Class<T> adapter) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object value : sel) {
                IAdaptable adaptable;
                Object obj;
                if (adapter.isInstance(value)) {
                    return adapter.cast(value);
                }
                if (!(value instanceof IAdaptable) || (obj = (adaptable = (IAdaptable)value).getAdapter(adapter)) == null) continue;
                return adapter.cast(obj);
            }
        }
        return null;
    }

    protected abstract void listen(boolean var1, IWorkbenchPart var2);

    protected AbstractPageBookView() {
    }

    protected abstract IPage createDefaultPage(PageBook var1);

    private PageRec<K> createPage(K part) {
        PageRec<K> rec = this.doCreatePage(part);
        if (rec != null) {
            this.mapPartToRec.put(part, rec);
            this.preparePage(rec);
        }
        return rec;
    }

    private void preparePage(PageRec<K> rec) {
        IPageSite site = null;
        if (!this.doesPageExist(rec.page)) {
            if (rec.page instanceof IPageBookViewPage) {
                site = ((IPageBookViewPage)rec.page).getSite();
            }
            if (site == null) {
                site = new PageSite(this.getViewSite());
            }
            rec.pageSite = site;
            rec.subActionBars = (SubActionBars)site.getActionBars();
            rec.subActionBars.addPropertyChangeListener(this.actionBarPropListener);
            rec.page.setActionBars((IActionBars)rec.subActionBars);
        } else {
            site = rec.pageSite;
            if (site != null) {
                rec.subActionBars = (SubActionBars)site.getActionBars();
            }
        }
    }

    protected void initPage(IPageBookViewPage page) {
        try {
            page.init((IPageSite)new PageSite(this.getViewSite()));
        }
        catch (PartInitException e) {
            UiPlugin.log(((Object)((Object)this)).getClass(), (String)"initPage", (Throwable)e);
        }
    }

    public void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        IPage defaultPage = this.createDefaultPage(this.book);
        this.defaultPageRec = new PageRec<Object>(null, defaultPage);
        this.preparePage(this.defaultPageRec);
        this.showPageRec(this.defaultPageRec);
        this.getSite().getPage().addPartListener(this.partListener);
        ISelectionService workbenchSelection = (ISelectionService)this.getSite().getService(ISelectionService.class);
        workbenchSelection.addPostSelectionListener(this.selectionListener);
        this.showBootstrapPart();
        this.getSite().getPage().getWorkbenchWindow().addPerspectiveListener(this.perspectiveListener);
    }

    public void dispose() {
        this.getSite().getPage().getWorkbenchWindow().removePerspectiveListener(this.perspectiveListener);
        this.getSite().getPage().removePartListener(this.partListener);
        ISelectionService workbenchSelection = (ISelectionService)this.getSite().getService(ISelectionService.class);
        workbenchSelection.addPostSelectionListener(this.selectionListener);
        this.activeRec = null;
        if (this.defaultPageRec != null) {
            this.defaultPageRec.page.dispose();
            this.defaultPageRec = null;
        }
        Map clone = (Map)((HashMap)this.mapPartToRec).clone();
        for (PageRec rec : clone.values()) {
            this.removePage(rec);
        }
        super.dispose();
    }

    protected abstract PageRec<K> doCreatePage(K var1);

    protected abstract void doDestroyPage(K var1, PageRec<K> var2);

    protected boolean doesPageExist(IPage page) {
        for (PageRec<K> rec : this.mapPartToRec.values()) {
            if (rec.page != page) continue;
            return true;
        }
        return false;
    }

    public Object getAdapter(Class key) {
        IPage page = this.getCurrentPage();
        Object adapter = Util.getAdapter((Object)page, (Class)key);
        if (adapter != null) {
            return adapter;
        }
        adapter = this.getViewAdapter(key);
        if (adapter != null) {
            return adapter;
        }
        return super.getAdapter(key);
    }

    protected Object getViewAdapter(Class adapter) {
        return null;
    }

    protected K getBootstrapTarget() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return null;
        }
        K target = this.getCurrent(part);
        return target;
    }

    protected abstract K getCurrent(IWorkbenchPart var1);

    protected abstract K getCurrent(ISelection var1);

    protected K getCurrent(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == null) {
            return null;
        }
        return this.getCurrent(part);
    }

    protected K getCurrentContributingPart() {
        if (this.activeRec == null) {
            return null;
        }
        return this.activeRec.getTarget();
    }

    public IPage getCurrentPage() {
        if (this.activeRec == null) {
            return null;
        }
        return this.activeRec.page;
    }

    protected IPageSite getPageSite(IPage page) {
        for (PageRec<K> rec : this.mapPartToRec.values()) {
            if (page != rec.page) continue;
            return rec.pageSite;
        }
        return null;
    }

    public IPage getDefaultPage() {
        return this.defaultPageRec.page;
    }

    protected PageBook getPageBook() {
        return this.book;
    }

    protected PageRec<K> getPageRec(K part) {
        return this.mapPartToRec.get(part);
    }

    protected PageRec<K> getPageRec(IPage page) {
        for (PageRec<K> rec : this.mapPartToRec.values()) {
            if (rec.page != page) continue;
            return rec;
        }
        return null;
    }

    protected abstract boolean isImportant(K var1);

    public void init(IViewSite site) throws PartInitException {
        site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        super.init(site);
    }

    public void activated(K part) {
        if (!this.isImportant(part)) {
            return;
        }
        this.hiddenPart = null;
        PageRec<K> rec = this.getPageRec(part);
        if (rec == null) {
            rec = this.createPage(part);
        }
        if (rec != null) {
            this.showPageRec(rec);
        } else {
            this.showPageRec(this.defaultPageRec);
        }
    }

    public void broughtToTop(K target) {
    }

    public void closed(K part) {
        PageRec<K> rec;
        if (this.activeRec != null && this.activeRec.getTarget() == part) {
            this.showPageRec(this.defaultPageRec);
        }
        if ((rec = this.getPageRec(part)) != null) {
            this.removePage(rec);
        }
        if (part == this.hiddenPart) {
            this.hiddenPart = null;
        }
    }

    public void deactivated(K target) {
    }

    public void opened(K target) {
    }

    private void refreshGlobalActionHandlers() {
        Map newActionHandlers;
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        if (this.activeRec.subActionBars != null && (newActionHandlers = this.activeRec.subActionBars.getGlobalActionHandlers()) != null) {
            Set keys = newActionHandlers.entrySet();
            for (Map.Entry entry : keys) {
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    private void removePage(PageRec<K> rec) {
        block12: {
            this.mapPartToRec.remove(rec.getTarget());
            IPageSite site = rec.pageSite;
            Control control = rec.page.getControl();
            if (control != null && !control.isDisposed()) {
                control.dispose();
            }
            this.doDestroyPage(rec.getTarget(), rec);
            if (rec.subActionBars != null) {
                rec.subActionBars.dispose();
            }
            if (site instanceof PageSite) {
                try {
                    Method dispose = PageSite.class.getMethod("dispose", new Class[0]);
                    dispose.invoke((Object)site, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    if (UiPlugin.getDefault().isDebugging()) {
                        e.printStackTrace();
                    }
                }
                catch (IllegalAccessException e) {
                    if (UiPlugin.getDefault().isDebugging()) {
                        e.printStackTrace();
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    if (UiPlugin.getDefault().isDebugging()) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e) {
                    if (!UiPlugin.getDefault().isDebugging()) break block12;
                    e.printStackTrace();
                }
            }
        }
    }

    public void setFocus() {
        if (this.book != null) {
            this.book.setFocus();
        }
        if (this.activeRec != null && this.activeRec.page != null) {
            this.activeRec.page.setFocus();
        }
    }

    private void pageSelectionChanged(SelectionChangedEvent event) {
        SelectionProvider provider = (SelectionProvider)this.getSite().getSelectionProvider();
        if (provider != null) {
            provider.selectionChanged(event);
        }
    }

    private void postSelectionChanged(SelectionChangedEvent event) {
        SelectionProvider provider = (SelectionProvider)this.getSite().getSelectionProvider();
        if (provider != null) {
            provider.postSelectionChanged(event);
        }
    }

    private void showBootstrapPart() {
        K part = this.getBootstrapTarget();
        if (part != null) {
            this.activated(part);
        }
    }

    protected void showPageRec(PageRec<K> pageRec) {
        if (this.activeRec == pageRec) {
            return;
        }
        if (this.activeRec != null && pageRec != null && this.activeRec.page == pageRec.page) {
            this.activeRec = pageRec;
            return;
        }
        if (this.activeRec != null) {
            ISelectionProvider provider;
            IPageSite pageSite = this.activeRec.pageSite;
            if (this.activeRec.subActionBars != null) {
                this.activeRec.subActionBars.deactivate();
            }
            if (pageSite instanceof PageSite) {
                ((PageSite)pageSite).deactivate();
            }
            if (pageSite != null && (provider = pageSite.getSelectionProvider()) != null) {
                provider.removeSelectionChangedListener(this.selectionChangedListener);
                if (provider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)provider).removePostSelectionChangedListener(this.postSelectionListener);
                }
            }
        }
        this.activeRec = pageRec;
        Control pageControl = this.activeRec.page.getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            ISelectionProvider provider;
            IPageSite pageSite = this.activeRec.pageSite;
            this.book.showPage(pageControl);
            if (this.activeRec.subActionBars != null) {
                this.activeRec.subActionBars.activate();
            }
            this.refreshGlobalActionHandlers();
            if (pageSite instanceof PageSite) {
                ((PageSite)pageSite).activate();
            }
            if ((provider = pageSite.getSelectionProvider()) != null) {
                provider.addSelectionChangedListener(this.selectionChangedListener);
                if (provider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)provider).addPostSelectionChangedListener(this.postSelectionListener);
                }
            }
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    private boolean containsPart(IViewPart[] viewStack, IWorkbenchPart part) {
        if (viewStack == null) {
            return false;
        }
        int i = 0;
        while (i < viewStack.length) {
            if (viewStack[i] == part) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void hidden(K target) {
    }

    protected void inputChanged(K target) {
    }

    protected void visible(K target) {
    }

    protected static class PageRec<T> {
        protected T target;
        protected IPage page;
        protected SubActionBars subActionBars;
        protected IPageSite pageSite;

        public PageRec(T target, IPage page) {
            this.target = target;
            this.page = page;
        }

        public IPage getPage() {
            return this.page;
        }

        public T getTarget() {
            return this.target;
        }

        public SubActionBars getActionBars() {
            return this.subActionBars;
        }

        public void dispose() {
            this.target = null;
            this.page = null;
        }
    }

    private static class SelectionManager
    extends EventManager {
        private SelectionManager() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.addListenerObject(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.removeListenerObject(listener);
        }

        public void selectionChanged(final SelectionChangedEvent event) {
            Object[] listeners = this.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(event);
                    }
                });
                ++i;
            }
        }
    }

    protected class SelectionProvider
    implements IPostSelectionProvider {
        private SelectionManager selectionListeners = new SelectionManager();
        private SelectionManager postSelectionListeners = new SelectionManager();

        protected SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionListeners.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            IPage currentPage = AbstractPageBookView.this.getCurrentPage();
            if (currentPage == null) {
                return StructuredSelection.EMPTY;
            }
            IPageSite site = AbstractPageBookView.this.getPageSite(currentPage);
            if (site == null) {
                return StructuredSelection.EMPTY;
            }
            ISelectionProvider selProvider = site.getSelectionProvider();
            if (selProvider != null) {
                return selProvider.getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionListeners.removeSelectionChangedListener(listener);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selectionListeners.selectionChanged(event);
        }

        public void postSelectionChanged(SelectionChangedEvent event) {
            this.postSelectionListeners.selectionChanged(event);
        }

        public void setSelection(ISelection selection) {
            IPage currentPage = AbstractPageBookView.this.getCurrentPage();
            if (currentPage == null) {
                return;
            }
            IPageSite site = AbstractPageBookView.this.getPageSite(currentPage);
            if (site == null) {
                return;
            }
            ISelectionProvider selProvider = site.getSelectionProvider();
            if (selProvider != null) {
                selProvider.setSelection(selection);
            }
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postSelectionListeners.addSelectionChangedListener(listener);
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postSelectionListeners.removeSelectionChangedListener(listener);
        }
    }
}

