/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.view.widgets.GuiBooleanField;
import eu.udig.omsbox.view.widgets.GuiComboField;
import eu.udig.omsbox.view.widgets.GuiCoverageInputField;
import eu.udig.omsbox.view.widgets.GuiCoverageOutputField;
import eu.udig.omsbox.view.widgets.GuiFeatureInputField;
import eu.udig.omsbox.view.widgets.GuiFeatureOutputField;
import eu.udig.omsbox.view.widgets.GuiFilespathListInputField;
import eu.udig.omsbox.view.widgets.GuiGridgeometryInputField;
import eu.udig.omsbox.view.widgets.GuiHashMapInputField;
import eu.udig.omsbox.view.widgets.GuiHashMapOutputField;
import eu.udig.omsbox.view.widgets.GuiLabel;
import eu.udig.omsbox.view.widgets.GuiListInputField;
import eu.udig.omsbox.view.widgets.GuiListOutputField;
import eu.udig.omsbox.view.widgets.GuiTextField;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;

public class ModuleGuiFactory {
    public static int COLUMNS = 12;

    public List<ModuleGuiElement> createInputGui(FieldData inputData, int[] row) {
        ArrayList<ModuleGuiElement> guiElements = new ArrayList<ModuleGuiElement>();
        if (inputData != null) {
            if (this.isAtLeastOneAssignable(inputData.fieldType, String.class)) {
                if (inputData.guiHints != null && inputData.guiHints.startsWith("multiline")) {
                    this.handleTextArea(inputData, row, guiElements);
                } else if (inputData.guiHints != null && inputData.guiHints.startsWith("combo")) {
                    this.handleComboField(inputData, row, guiElements);
                } else {
                    this.handleTextField(inputData, row, guiElements);
                }
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, Double.class, Double.TYPE)) {
                this.handleTextField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, Float.class, Float.TYPE)) {
                this.handleTextField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, Integer.class, Integer.TYPE)) {
                this.handleTextField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, Short.class, Short.TYPE)) {
                this.handleTextField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, Boolean.class, Boolean.TYPE)) {
                this.handleBooleanField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, GridCoverage2D.class)) {
                this.handleGridcoverageInputField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, GridGeometry2D.class)) {
                this.handleGridgeometryInputField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, SimpleFeatureCollection.class)) {
                this.handleFeatureInputField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, HashMap.class)) {
                this.handleHashMapInputField(inputData, row, guiElements);
            } else if (this.isAtLeastOneAssignable(inputData.fieldType, List.class)) {
                if (inputData.guiHints != null && inputData.guiHints.equals("filespathlist")) {
                    this.handleFilesPathListInputField(inputData, row, guiElements);
                } else {
                    this.handleListInputField(inputData, row, guiElements);
                }
            } else if (!inputData.fieldType.endsWith("ProgressMonitor")) {
                System.out.println("Skipping input field: " + inputData.fieldType);
            }
        }
        return guiElements;
    }

    public List<ModuleGuiElement> createOutputGui(FieldData outputData, int[] row) {
        ArrayList<ModuleGuiElement> guiElements = new ArrayList<ModuleGuiElement>();
        if (this.isAtLeastOneAssignable(outputData.fieldType, GridCoverage2D.class)) {
            this.handleGridcoverageOutputField(outputData, row, guiElements);
        } else if (this.isAtLeastOneAssignable(outputData.fieldType, SimpleFeatureCollection.class)) {
            this.handleFeatureOutputField(outputData, row, guiElements);
        } else if (this.isAtLeastOneAssignable(outputData.fieldType, HashMap.class)) {
            this.handleHashMapOutputField(outputData, row, guiElements);
        } else if (this.isAtLeastOneAssignable(outputData.fieldType, List.class)) {
            this.handleListOutputField(outputData, row, guiElements);
        } else if (outputData != null) {
            System.out.println("Skipping output field: " + outputData.fieldType);
        }
        return guiElements;
    }

    private String extractSingleGuiHint(String pattern, String guiHints) {
        String[] split;
        String[] stringArray = split = guiHints.split(",");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String hint = stringArray[n2];
            if ((hint = hint.trim()).contains(pattern)) {
                return hint;
            }
            ++n2;
        }
        return null;
    }

    private boolean isAtLeastOneAssignable(String main, Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz.getCanonicalName().equals(main)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void handleTextField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 5;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        boolean isBold = false;
        String guiHints = data.guiHints;
        if (guiHints != null && (guiHints.contains("outfile") || guiHints.contains("outfolder"))) {
            isBold = true;
        }
        GuiLabel label = new GuiLabel(data, labelConstraint, isBold);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiTextField text = new GuiTextField(data, textConstraint);
        guiElements.add(text);
    }

    private void handleTextArea(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        String hint = this.extractSingleGuiHint("multiline", data.guiHints);
        String rowsStr = hint.replaceFirst("multiline", "");
        row[0] = row[0] + 1;
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS);
        sb.append(" ");
        sb.append(rowsStr);
        row[0] = row[0] + Integer.parseInt(rowsStr);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiTextField text = new GuiTextField(data, textConstraint);
        guiElements.add(text);
    }

    private void handleBooleanField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiBooleanField booleanField = new GuiBooleanField(data, textConstraint);
        guiElements.add(booleanField);
    }

    private void handleGridcoverageInputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiCoverageInputField coverage = new GuiCoverageInputField(data, textConstraint);
        guiElements.add(coverage);
    }

    private void handleGridcoverageOutputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiCoverageOutputField coverage = new GuiCoverageOutputField(data, textConstraint);
        guiElements.add(coverage);
    }

    private void handleFeatureInputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiFeatureInputField feature = new GuiFeatureInputField(data, textConstraint);
        guiElements.add(feature);
    }

    private void handleFeatureOutputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiFeatureOutputField coverage = new GuiFeatureOutputField(data, textConstraint);
        guiElements.add(coverage);
    }

    private void handleHashMapInputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiHashMapInputField hashmap = new GuiHashMapInputField(data, textConstraint);
        guiElements.add(hashmap);
    }

    private void handleHashMapOutputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiHashMapOutputField hashmap = new GuiHashMapOutputField(data, textConstraint);
        guiElements.add(hashmap);
    }

    private void handleListInputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiListInputField hashmap = new GuiListInputField(data, textConstraint);
        guiElements.add(hashmap);
    }

    private void handleFilesPathListInputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        row[0] = row[0] + 1;
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS);
        sb.append(" ");
        sb.append(8);
        row[0] = row[0] + 8;
        sb.append(", growx, growy");
        String textConstraint = sb.toString();
        GuiFilespathListInputField coverageList = new GuiFilespathListInputField(data, textConstraint);
        guiElements.add(coverageList);
    }

    private void handleListOutputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiListOutputField hashmap = new GuiListOutputField(data, textConstraint);
        guiElements.add(hashmap);
    }

    private void handleGridgeometryInputField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 3;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiGridgeometryInputField gridgeometry = new GuiGridgeometryInputField(data, textConstraint);
        guiElements.add(gridgeometry);
    }

    private void handleComboField(FieldData data, int[] row, List<ModuleGuiElement> guiElements) {
        StringBuilder sb = new StringBuilder();
        sb.append("cell ");
        sb.append(0);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        int labelCol = COLUMNS / 5;
        sb.append(labelCol);
        sb.append(" ");
        sb.append(1);
        String labelConstraint = sb.toString();
        GuiLabel label = new GuiLabel(data, labelConstraint, false);
        guiElements.add(label);
        sb = new StringBuilder();
        sb.append("cell ");
        sb.append(labelCol + 1);
        sb.append(" ");
        sb.append(row[0]);
        sb.append(" ");
        sb.append(COLUMNS - labelCol);
        sb.append(" ");
        sb.append(1);
        sb.append(", growx");
        String textConstraint = sb.toString();
        GuiComboField text = new GuiComboField(data, textConstraint);
        guiElements.add(text);
    }
}

