/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.core.FieldData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ModuleGuiElement {
    public abstract Control makeGui(Composite var1);

    public abstract FieldData getFieldData();

    public abstract boolean hasData();

    public abstract String validateContent();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T adapt(String value, Class<T> clazz) {
        try {
            if (clazz.isAssignableFrom(Double.class)) {
                Double parsedDouble = new Double(value);
                return clazz.cast(parsedDouble);
            }
            if (clazz.isAssignableFrom(Float.class)) {
                Float parsedFloat = new Float(value);
                return clazz.cast(parsedFloat);
            }
            if (clazz.isAssignableFrom(Integer.class)) {
                Integer parsedInteger = null;
                try {
                    parsedInteger = new Integer(value);
                    return clazz.cast(parsedInteger);
                }
                catch (Exception exception) {
                    if (value.toLowerCase().equals("true") || value.toLowerCase().equals("y")) {
                        parsedInteger = 1;
                        return clazz.cast(parsedInteger);
                    }
                    if (!value.toLowerCase().equals("false")) {
                        if (!value.toLowerCase().equals("n")) return null;
                    }
                    parsedInteger = 0;
                    return clazz.cast(parsedInteger);
                }
            }
            if (clazz.isAssignableFrom(Long.class)) {
                Long parsedLong = new Long(value);
                return clazz.cast(parsedLong);
            }
            if (!clazz.isAssignableFrom(String.class)) return null;
            return clazz.cast(value);
        }
        catch (Exception exception) {}
        return null;
    }

    protected String checkBackSlash(String textStr, boolean isFile) {
        if (isFile) {
            textStr = textStr.replaceAll("\\\\", "/");
        }
        return textStr;
    }
}

