/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.core.OmsModulesManager;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import eu.udig.omsbox.view.widgets.MultipleModuleDescriptionDialog;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GuiListOutputField
extends ModuleGuiElement {
    private final String constraints;
    private FieldData data;
    private static ModuleDescription selectedListWriter;

    public GuiListOutputField(FieldData data, String constraints) {
        this.data = data;
        this.constraints = constraints;
    }

    @Override
    public Control makeGui(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.constraints);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        final Button browseButton = new Button(composite, 8);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<ModuleDescription> hashmapWriter = OmsModulesManager.getInstance().getListWriters();
                MultipleModuleDescriptionDialog dialog = new MultipleModuleDescriptionDialog("Choose Output List Writer", hashmapWriter);
                if (selectedListWriter != null) {
                    dialog.setLastUsedModuleDescription(selectedListWriter);
                }
                dialog.open(browseButton.getShell());
                selectedListWriter = dialog.getModuleDescription();
                List<FieldData> inputList = selectedListWriter.getInputsList();
                for (FieldData fieldData : inputList) {
                    if (!fieldData.fieldType.equals(List.class.getCanonicalName())) continue;
                    ((GuiListOutputField)GuiListOutputField.this).data.otherFieldName = fieldData.fieldName;
                    ((GuiListOutputField)GuiListOutputField.this).data.otherModule = selectedListWriter;
                    break;
                }
            }
        });
        return null;
    }

    @Override
    public FieldData getFieldData() {
        return this.data;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public String validateContent() {
        return null;
    }
}

