/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.core.OmsModulesManager;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import eu.udig.omsbox.view.widgets.MultipleModuleDescriptionDialog;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GuiListInputField
extends ModuleGuiElement {
    private final String constraints;
    private FieldData data;
    private static ModuleDescription selectedListReader;

    public GuiListInputField(FieldData data, String constraints) {
        this.data = data;
        this.constraints = constraints;
    }

    @Override
    public Control makeGui(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.constraints);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        final Button browseButton = new Button(composite, 8);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<ModuleDescription> listReaders = OmsModulesManager.getInstance().getListReaders();
                MultipleModuleDescriptionDialog dialog = new MultipleModuleDescriptionDialog("Choose Input List Data Reader", listReaders);
                if (selectedListReader != null) {
                    dialog.setLastUsedModuleDescription(selectedListReader);
                }
                dialog.open(browseButton.getShell());
                selectedListReader = dialog.getModuleDescription();
                List<FieldData> outputList = selectedListReader.getOutputsList();
                for (FieldData fieldData : outputList) {
                    if (!fieldData.fieldType.equals(List.class.getCanonicalName())) continue;
                    ((GuiListInputField)GuiListInputField.this).data.otherFieldName = fieldData.fieldName;
                    ((GuiListInputField)GuiListInputField.this).data.otherModule = selectedListReader;
                    break;
                }
            }
        });
        return null;
    }

    @Override
    public FieldData getFieldData() {
        return this.data;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public String validateContent() {
        return null;
    }
}

