/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.actions;

import eu.udig.omsbox.core.OmsModulesManager;
import eu.udig.omsbox.ui.SettingsDialog;
import eu.udig.omsbox.view.OmsBoxView;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class OmsBoxSettingsAction
implements IViewActionDelegate {
    private IViewPart view;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        if (this.view instanceof OmsBoxView) {
            final OmsBoxView dbView = (OmsBoxView)this.view;
            Shell shell = dbView.getSite().getShell();
            SettingsDialog dialog = new SettingsDialog();
            dialog.open(shell, 2);
            if (dialog.isCancelPressed()) {
                return;
            }
            final List<String> resources = dialog.getSelectedResources();
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                    pm.beginTask("Loading modules from libraries...", -1);
                    try {
                        try {
                            OmsModulesManager manager = OmsModulesManager.getInstance();
                            manager.clearJars();
                            for (String resource : resources) {
                                manager.addJar(resource);
                            }
                            manager.browseModules(true);
                            dbView.relayout();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            pm.done();
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            };
            PlatformGIS.runInProgressDialog((String)"Spatial Toolbox...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

