/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResourceFinder {
    private final URL[] urls;
    private final String path;
    private final ClassLoader classLoader;
    private final List<String> resourcesNotLoaded = new ArrayList<String>();

    public ResourceFinder(URL ... urls) {
        this(null, Thread.currentThread().getContextClassLoader(), urls);
    }

    public ResourceFinder(String path) {
        this(path, Thread.currentThread().getContextClassLoader(), null);
    }

    public ResourceFinder(String path, URL ... urls) {
        this(path, Thread.currentThread().getContextClassLoader(), urls);
    }

    public ResourceFinder(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ResourceFinder(String path, ClassLoader classLoader, URL ... urls) {
        if (path == null) {
            path = "";
        } else if (path.length() > 0 && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        this.path = path;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.classLoader = classLoader;
        int i = 0;
        while (urls != null && i < urls.length) {
            URL url = urls[i];
            if (url != null && !ResourceFinder.isDirectory(url) && !url.getProtocol().equals("jar")) {
                try {
                    urls[i] = new URL("jar", "", -1, String.valueOf(url.toString()) + "!/");
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
        this.urls = urls == null || urls.length == 0 ? null : urls;
    }

    private static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.length() > 0 && file.charAt(file.length() - 1) == '/';
    }

    public List<String> getResourcesNotLoaded() {
        return Collections.unmodifiableList(this.resourcesNotLoaded);
    }

    public URL find(String uri) throws IOException {
        String fullUri = String.valueOf(this.path) + uri;
        URL resource = this.getResource(fullUri);
        if (resource == null) {
            throw new IOException("Could not find resource '" + fullUri + "'");
        }
        return resource;
    }

    public List<URL> findAll(String uri) throws IOException {
        String fullUri = String.valueOf(this.path) + uri;
        Enumeration<URL> resources = this.getResources(fullUri);
        ArrayList<URL> list = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            list.add(url);
        }
        return list;
    }

    public String findString(String uri) throws IOException {
        String fullUri = String.valueOf(this.path) + uri;
        URL resource = this.getResource(fullUri);
        if (resource == null) {
            throw new IOException("Could not find a resource in : " + fullUri);
        }
        return this.readContents(resource);
    }

    public List<String> findAllStrings(String uri) throws IOException {
        String fulluri = String.valueOf(this.path) + uri;
        ArrayList<String> strings = new ArrayList<String>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String string = this.readContents(url);
            strings.add(string);
        }
        return strings;
    }

    public List<String> findAvailableStrings(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        String fulluri = String.valueOf(this.path) + uri;
        ArrayList<String> strings = new ArrayList<String>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                String string = this.readContents(url);
                strings.add(string);
            }
            catch (IOException iOException) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return strings;
    }

    public Map<String, String> mapAllStrings(String uri) throws IOException {
        HashMap<String, String> strings = new HashMap<String, String>();
        Map<String, URL> resourcesMap = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : resourcesMap.entrySet()) {
            String name = entry.getKey();
            URL url = entry.getValue();
            String value = this.readContents(url);
            strings.put(name, value);
        }
        return strings;
    }

    public Map<String, String> mapAvailableStrings(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap<String, String> strings = new HashMap<String, String>();
        Map<String, URL> resourcesMap = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : resourcesMap.entrySet()) {
            String name = entry.getKey();
            URL url = entry.getValue();
            try {
                String value = this.readContents(url);
                strings.put(name, value);
            }
            catch (IOException iOException) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return strings;
    }

    public Class findClass(String uri) throws IOException, ClassNotFoundException {
        String className = this.findString(uri);
        return this.classLoader.loadClass(className);
    }

    public List<Class> findAllClasses(String uri) throws IOException, ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>();
        List<String> strings = this.findAllStrings(uri);
        for (String className : strings) {
            Class<?> clazz = this.classLoader.loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    public List<Class> findAvailableClasses(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        List<String> strings = this.findAvailableStrings(uri);
        for (String className : strings) {
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                classes.add(clazz);
            }
            catch (Exception exception) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return classes;
    }

    public Map<String, Class> mapAllClasses(String uri) throws IOException, ClassNotFoundException {
        HashMap<String, Class> classes = new HashMap<String, Class>();
        Map<String, String> map = this.mapAllStrings(uri);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            Class<?> clazz = this.classLoader.loadClass(className);
            classes.put(string, clazz);
        }
        return classes;
    }

    public Map<String, Class> mapAvailableClasses(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap<String, Class> classes = new HashMap<String, Class>();
        Map<String, String> map = this.mapAvailableStrings(uri);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                classes.put(string, clazz);
            }
            catch (Exception exception) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return classes;
    }

    public Class findImplementation(Class interfase) throws IOException, ClassNotFoundException {
        String className = this.findString(interfase.getName());
        Class<?> impl = this.classLoader.loadClass(className);
        if (!interfase.isAssignableFrom(impl)) {
            throw new ClassCastException("Class not of type: " + interfase.getName());
        }
        return impl;
    }

    public List<Class> findAllImplementations(Class interfase) throws IOException, ClassNotFoundException {
        ArrayList<Class> implementations = new ArrayList<Class>();
        List<String> strings = this.findAllStrings(interfase.getName());
        for (String className : strings) {
            Class<?> impl = this.classLoader.loadClass(className);
            if (!interfase.isAssignableFrom(impl)) {
                throw new ClassCastException("Class not of type: " + interfase.getName());
            }
            implementations.add(impl);
        }
        return implementations;
    }

    public List<Class> findAvailableImplementations(Class interfase) throws IOException {
        this.resourcesNotLoaded.clear();
        ArrayList<Class> implementations = new ArrayList<Class>();
        List<String> strings = this.findAvailableStrings(interfase.getName());
        for (String className : strings) {
            try {
                Class<?> impl = this.classLoader.loadClass(className);
                if (interfase.isAssignableFrom(impl)) {
                    implementations.add(impl);
                    continue;
                }
                this.resourcesNotLoaded.add(className);
            }
            catch (Exception exception) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return implementations;
    }

    public Map<String, Class> mapAllImplementations(Class interfase) throws IOException, ClassNotFoundException {
        HashMap<String, Class> implementations = new HashMap<String, Class>();
        Map<String, String> map = this.mapAllStrings(interfase.getName());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            Class<?> impl = this.classLoader.loadClass(className);
            if (!interfase.isAssignableFrom(impl)) {
                throw new ClassCastException("Class not of type: " + interfase.getName());
            }
            implementations.put(string, impl);
        }
        return implementations;
    }

    public Map<String, Class> mapAvailableImplementations(Class interfase) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap<String, Class> implementations = new HashMap<String, Class>();
        Map<String, String> map = this.mapAvailableStrings(interfase.getName());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String className = entry.getValue();
            try {
                Class<?> impl = this.classLoader.loadClass(className);
                if (interfase.isAssignableFrom(impl)) {
                    implementations.put(string, impl);
                    continue;
                }
                this.resourcesNotLoaded.add(className);
            }
            catch (Exception exception) {
                this.resourcesNotLoaded.add(className);
            }
        }
        return implementations;
    }

    public Properties findProperties(String uri) throws IOException {
        String fulluri = String.valueOf(this.path) + uri;
        URL resource = this.getResource(fulluri);
        if (resource == null) {
            throw new IOException("Could not find resource: " + fulluri);
        }
        return this.loadProperties(resource);
    }

    public List<Properties> findAllProperties(String uri) throws IOException {
        String fulluri = String.valueOf(this.path) + uri;
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Properties props = this.loadProperties(url);
            properties.add(props);
        }
        return properties;
    }

    public List<Properties> findAvailableProperties(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        String fulluri = String.valueOf(this.path) + uri;
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = this.getResources(fulluri);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                Properties props = this.loadProperties(url);
                properties.add(props);
            }
            catch (Exception exception) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return properties;
    }

    public Map<String, Properties> mapAllProperties(String uri) throws IOException {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        Map<String, URL> map = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : map.entrySet()) {
            String string = entry.getKey();
            URL url = entry.getValue();
            Properties properties = this.loadProperties(url);
            propertiesMap.put(string, properties);
        }
        return propertiesMap;
    }

    public Map<String, Properties> mapAvailableProperties(String uri) throws IOException {
        this.resourcesNotLoaded.clear();
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        Map<String, URL> map = this.getResourcesMap(uri);
        for (Map.Entry<String, URL> entry : map.entrySet()) {
            String string = entry.getKey();
            URL url = entry.getValue();
            try {
                Properties properties = this.loadProperties(url);
                propertiesMap.put(string, properties);
            }
            catch (Exception exception) {
                this.resourcesNotLoaded.add(url.toExternalForm());
            }
        }
        return propertiesMap;
    }

    public Map<String, URL> getResourcesMap(String uri) throws IOException {
        String basePath = String.valueOf(this.path) + uri;
        HashMap<String, URL> resources = new HashMap<String, URL>();
        if (!basePath.endsWith("/")) {
            basePath = String.valueOf(basePath) + "/";
        }
        Enumeration<URL> urls = this.getResources(basePath);
        while (urls.hasMoreElements()) {
            URL location = urls.nextElement();
            try {
                if (location.getProtocol().equals("jar")) {
                    ResourceFinder.readJarEntries(location, basePath, resources);
                    continue;
                }
                if (!location.getProtocol().equals("file")) continue;
                ResourceFinder.readDirectoryEntries(location, resources);
            }
            catch (Exception exception) {}
        }
        return resources;
    }

    private static void readDirectoryEntries(URL location, Map<String, URL> resources) throws MalformedURLException {
        File dir = new File(URLDecoder.decode(location.getPath()));
        if (dir.isDirectory()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    String name = file.getName();
                    URL url = file.toURI().toURL();
                    resources.put(name, url);
                }
                ++n2;
            }
        }
    }

    private static void readJarEntries(URL location, String basePath, Map<String, URL> resources) throws IOException {
        JarURLConnection conn = (JarURLConnection)location.openConnection();
        JarFile jarfile = null;
        jarfile = conn.getJarFile();
        Enumeration<JarEntry> entries = jarfile.entries();
        while (entries != null && entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || !name.startsWith(basePath) || name.length() == basePath.length() || (name = name.substring(basePath.length())).contains("/")) continue;
            URL resource = new URL(location, name);
            resources.put(name, resource);
        }
    }

    private Properties loadProperties(URL resource) throws IOException {
        Properties properties;
        InputStream in = resource.openStream();
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties2 = new Properties();
            properties2.load(reader);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                reader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            in.close();
            reader.close();
        }
        catch (Exception exception) {}
        return properties;
    }

    private String readContents(URL resource) throws IOException {
        String string;
        InputStream in = resource.openStream();
        BufferedInputStream reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            reader = new BufferedInputStream(in);
            int b = reader.read();
            while (b != -1) {
                sb.append((char)b);
                b = reader.read();
            }
            string = sb.toString().trim();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                reader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            in.close();
            reader.close();
        }
        catch (Exception exception) {}
        return string;
    }

    private URL getResource(String fullUri) {
        if (this.urls == null) {
            return this.classLoader.getResource(fullUri);
        }
        return this.findResource(fullUri, this.urls);
    }

    private Enumeration<URL> getResources(String fulluri) throws IOException {
        if (this.urls == null) {
            return this.classLoader.getResources(fulluri);
        }
        Vector<URL> resources = new Vector<URL>();
        URL[] uRLArray = this.urls;
        int n = this.urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            URL resource = this.findResource(fulluri, url);
            if (resource != null) {
                resources.add(resource);
            }
            ++n2;
        }
        return resources.elements();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL findResource(String resourceName, URL ... search) {
        i = 0;
        while (true) {
            block35: {
                if (i >= search.length) {
                    return null;
                }
                currentUrl = search[i];
                if (currentUrl == null) break block35;
                try {
                    block37: {
                        block36: {
                            protocol = currentUrl.getProtocol();
                            if (!protocol.equals("jar")) break block37;
                            jarURL = ((JarURLConnection)currentUrl.openConnection()).getJarFileURL();
                            try {
                                juc = (JarURLConnection)new URL("jar", "", String.valueOf(jarURL.toExternalForm()) + "!/").openConnection();
                                jarFile = juc.getJarFile();
                            }
                            catch (IOException e) {
                                search[i] = null;
                                throw e;
                            }
                            try {
                                block38: {
                                    juc = (JarURLConnection)new URL("jar", "", String.valueOf(jarURL.toExternalForm()) + "!/").openConnection();
                                    jarFile = juc.getJarFile();
                                    if (!currentUrl.getFile().endsWith("!/")) break block38;
                                    entryName = resourceName;
                                    ** GOTO lbl50
                                }
                                file = currentUrl.getFile();
                                sepIdx = file.lastIndexOf("!/");
                                if (sepIdx == -1) {
                                    search[i] = null;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var13_18) {
                                if (juc.getUseCaches() != false) throw var13_18;
                                try {
                                    jarFile.close();
                                    throw var13_18;
                                }
                                catch (Exception v0) {}
                                throw var13_18;
                            }
                            if (!juc.getUseCaches()) {
                                try {
                                    jarFile.close();
                                }
                                catch (Exception v1) {}
                            }
                            break block35;
lbl-1000:
                            // 1 sources

                            {
                                sb = new StringBuffer(file.length() - (sepIdx += 2) + resourceName.length());
                                sb.append(file.substring(sepIdx));
                                sb.append(resourceName);
                                entryName = sb.toString();
lbl50:
                                // 2 sources

                                if (!entryName.equals("META-INF/") || jarFile.getEntry("META-INF/MANIFEST.MF") == null) ** GOTO lbl-1000
                                var14_19 = this.targetURL(currentUrl, "META-INF/MANIFEST.MF");
                            }
                            if (juc.getUseCaches() != false) return var14_19;
                            try {
                                jarFile.close();
                                return var14_19;
                            }
                            catch (Exception v2) {}
                            return var14_19;
lbl-1000:
                            // 1 sources

                            {
                                if (jarFile.getEntry(entryName) == null) break block36;
                                var14_20 = this.targetURL(currentUrl, resourceName);
                            }
                            if (juc.getUseCaches() != false) return var14_20;
                            try {
                                jarFile.close();
                                return var14_20;
                            }
                            catch (Exception v3) {}
                            return var14_20;
                        }
                        if (!juc.getUseCaches()) {
                            try {
                                jarFile.close();
                            }
                            catch (Exception v4) {}
                        }
                        break block35;
                    }
                    if (protocol.equals("file")) {
                        baseFile = currentUrl.getFile();
                        host = currentUrl.getHost();
                        hostLength = 0;
                        if (host != null) {
                            hostLength = host.length();
                        }
                        buf = new StringBuffer(2 + hostLength + baseFile.length() + resourceName.length());
                        if (hostLength > 0) {
                            buf.append("//").append(host);
                        }
                        buf.append(baseFile);
                        fixedResName = resourceName;
                        while (true) {
                            if (!fixedResName.startsWith("/") && !fixedResName.startsWith("\\")) {
                                buf.append(fixedResName);
                                filename = buf.toString();
                                file = new File(filename);
                                file2 = new File(URLDecoder.decode(filename));
                                if (file.exists() != false) return this.targetURL(currentUrl, fixedResName);
                                if (file2.exists()) {
                                    return this.targetURL(currentUrl, fixedResName);
                                }
                                break block35;
                            }
                            fixedResName = fixedResName.substring(1);
                        }
                    }
                    resourceURL = this.targetURL(currentUrl, resourceName);
                    urlConnection = resourceURL.openConnection();
                    try {
                        urlConnection.getInputStream().close();
                    }
                    catch (SecurityException v5) {
                        return null;
                    }
                    if (!resourceURL.getProtocol().equals("http")) {
                        return resourceURL;
                    }
                    code = ((HttpURLConnection)urlConnection).getResponseCode();
                    if (code >= 200 && code < 300) {
                        return resourceURL;
                    }
                }
                catch (MalformedURLException v6) {
                }
                catch (IOException v7) {
                }
                catch (SecurityException v8) {}
            }
            ++i;
        }
    }

    private URL targetURL(URL base, String name) throws MalformedURLException {
        StringBuffer sb = new StringBuffer(base.getFile().length() + name.length());
        sb.append(base.getFile());
        sb.append(name);
        String file = sb.toString();
        return new URL(base.getProtocol(), base.getHost(), base.getPort(), file, null);
    }
}

