/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.utils;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.utils.OmsBoxConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class MapcalculatorUtils {
    public static final String GENERAL = "general";
    public static final String CONTROL_FLOW = "control flow";
    public static final String LOGICAL = "logical";
    public static final String ARITHMETIC = "arithmetic";
    public static final String NUMERIC = "numeric";
    public static final String STATISTICAL = "statistical";
    public static final String PROCESSING = "processing area";
    private static Color darkGreenColor = Display.getDefault().getSystemColor(6);
    private static Color darkBlueColor = Display.getDefault().getSystemColor(10);
    private static Color darkCyanColor = Display.getDefault().getSystemColor(14);
    private static Color redColor = Display.getDefault().getSystemColor(3);
    private static Color darkRedColor = Display.getDefault().getSystemColor(4);
    private static List<String> reservedWords = Arrays.asList("boolean", "break", "breakif", "con", "double", "else", "false", "float", "foreach", "if", "images", "in", "init", "int", "null", "options", "read", "true", "until", "while", "write");
    private static List<String> operationsWords = Arrays.asList("sqrt", "isnan", "isinf", "isnull", "null", "radToDeg", "degToRad", "max", "min", "mean", "median", "mode", "range", "sdev", "sum", "variance", "height", "width", "xmin", "ymin", "xmax", "ymax", "xres", "yres");

    public static void createMapcalcConstructsButtons(Composite buttonsComposite, final StyledText text) {
        Constructs[] values;
        CTabFolder tabFolder = new CTabFolder(buttonsComposite, 128);
        tabFolder.setBorderVisible(true);
        tabFolder.setMaximized(true);
        GridData tabGD = new GridData(0x1000000, 4, false, true);
        tabFolder.setLayoutData((Object)tabGD);
        HashMap<String, CTabItem> tabsMap = new HashMap<String, CTabItem>();
        Constructs[] constructsArray = values = Constructs.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            final Constructs construct = constructsArray[n2];
            String category = construct.category;
            CTabItem tabItem = (CTabItem)tabsMap.get(category);
            if (tabItem == null) {
                Composite composite = new Composite((Composite)tabFolder, 0);
                GridLayout compositeLayout = new GridLayout(2, true);
                composite.setLayout((Layout)compositeLayout);
                GridData compositeGD = new GridData(4, 4, true, true);
                composite.setLayoutData((Object)compositeGD);
                tabItem = new CTabItem(tabFolder, 0);
                tabItem.setText(category);
                tabItem.setControl((Control)composite);
                tabsMap.put(category, tabItem);
            }
            Control control = tabItem.getControl();
            Button constructButton = new Button((Composite)control, 8);
            constructButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            constructButton.setText(construct.name);
            constructButton.setToolTipText(construct.toolTip);
            constructButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MapcalculatorUtils.insertTextAtCaretPosition(text, construct.construct);
                }
            });
            ++n2;
        }
        tabFolder.setSelection(0);
        tabFolder.setSingle(true);
        tabFolder.pack();
    }

    private static void insertTextAtCaretPosition(StyledText text, String string) {
        int caretPosition = text.getCaretOffset();
        String textStr = text.getText();
        String sub1 = textStr.substring(0, caretPosition);
        String sub2 = textStr.substring(caretPosition);
        StringBuilder sb = new StringBuilder();
        sb.append(sub1);
        sb.append(string);
        sb.append(sub2);
        text.setText(sb.toString());
    }

    public static StyledText createMapcalcPanel(Composite parent, int rows) {
        Composite mapcalcComposite = new Composite(parent, 0);
        GridData compositeGD = new GridData(4, 4, true, true);
        compositeGD.verticalSpan = rows;
        compositeGD.widthHint = 100;
        mapcalcComposite.setLayoutData((Object)compositeGD);
        mapcalcComposite.setLayout((Layout)new GridLayout(2, false));
        final StyledText text = new StyledText(mapcalcComposite, 19010);
        GridData textGD = new GridData(4, 4, true, true);
        textGD.verticalSpan = rows;
        textGD.heightHint = 100;
        text.setLayoutData((Object)textGD);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapcalculatorUtils.checkStyle(text);
            }
        });
        Composite buttonsComposite = new Composite(mapcalcComposite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        GridLayout buttonsCompositeLayout = new GridLayout(1, true);
        buttonsCompositeLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)buttonsCompositeLayout);
        String[] mapcalcHistoryItems = new String[]{};
        String mapcalcHistory = OmsBoxPlugin.getDefault().getMapcalcHistory();
        if (mapcalcHistory != null && mapcalcHistory.length() > 0) {
            mapcalcHistoryItems = mapcalcHistory.split(OmsBoxConstants.MAPCALCHISTORY_SEPARATOR);
        }
        HashMap<String, String> items2ValuesMap = new HashMap<String, String>();
        String[] stringArray = mapcalcHistoryItems;
        int n = mapcalcHistoryItems.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String descr = item.replaceAll("\n", " ");
            items2ValuesMap.put(descr, item);
            ++n2;
        }
        mapcalcHistoryItems = items2ValuesMap.keySet().toArray(new String[0]);
        final Combo historyCombo = new Combo(mapcalcComposite, 12);
        GridData historyComboGD = new GridData(4, 0x1000000, true, false);
        historyComboGD.horizontalSpan = 2;
        historyCombo.setLayoutData((Object)historyComboGD);
        historyCombo.setItems(mapcalcHistoryItems);
        historyCombo.setData(items2ValuesMap);
        historyCombo.select(0);
        historyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = historyCombo.getSelectionIndex();
                String item = historyCombo.getItem(selectionIndex);
                HashMap descriptionsMap = (HashMap)historyCombo.getData();
                String value = (String)descriptionsMap.get(item);
                text.setText(value);
            }
        });
        MapcalculatorUtils.createMapcalcConstructsButtons(buttonsComposite, text);
        MapcalculatorUtils.checkStyle(text);
        return text;
    }

    public static void saveMapcalcHistory(String function) {
        String mapcalcHistory = OmsBoxPlugin.getDefault().getMapcalcHistory();
        if (mapcalcHistory == null) {
            mapcalcHistory = "";
        }
        String[] historySplit = mapcalcHistory.split(OmsBoxConstants.MAPCALCHISTORY_SEPARATOR);
        ArrayList<String> historyList = new ArrayList<String>();
        String[] stringArray = historySplit;
        int n = historySplit.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            if ((tmp = tmp.trim()).length() > 0 && !historyList.contains(tmp)) {
                historyList.add(tmp);
            }
            ++n2;
        }
        if (!historyList.contains(function)) {
            historyList.add(0, function);
        }
        while (historyList.size() > 15) {
            historyList.remove(15);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < historyList.size()) {
            if (i == 0) {
                sb.append(((String)historyList.get(i)).trim());
            } else {
                sb.append(OmsBoxConstants.MAPCALCHISTORY_SEPARATOR).append(((String)historyList.get(i)).trim());
            }
            ++i;
        }
        OmsBoxPlugin.getDefault().setMapcalcHistory(sb.toString());
    }

    public static void checkStyle(StyledText functionAreaText) {
        StyleRange styleRange;
        int position;
        ArrayList<Integer> bracketPositions;
        int length;
        StyleRange styleRange2;
        int index;
        String text = String.valueOf(functionAreaText.getText()) + " ";
        int i = 0;
        while (i < reservedWords.size()) {
            String reservedWord = reservedWords.get(i);
            index = 0;
            while ((index = text.indexOf(reservedWord, index)) != -1) {
                styleRange2 = new StyleRange();
                styleRange2.start = index;
                styleRange2.length = length = reservedWord.length();
                styleRange2.foreground = darkRedColor;
                styleRange2.fontStyle = 3;
                functionAreaText.setStyleRange(styleRange2);
                index += length;
            }
            ++i;
        }
        i = 0;
        while (i < operationsWords.size()) {
            String opWord = operationsWords.get(i);
            index = 0;
            while ((index = text.indexOf(opWord, index)) != -1) {
                styleRange2 = new StyleRange();
                styleRange2.start = index;
                styleRange2.length = length = opWord.length();
                styleRange2.foreground = darkCyanColor;
                styleRange2.fontStyle = 3;
                functionAreaText.setStyleRange(styleRange2);
                index += length;
            }
            ++i;
        }
        String[] textSplit = text.split("\\(|\\)|\\{|\\}");
        if (textSplit.length > 1) {
            bracketPositions = new ArrayList<Integer>();
            position = 0;
            int i2 = 0;
            while (i2 < textSplit.length - 1) {
                position = position + textSplit[i2].length() + 1;
                bracketPositions.add(position - 1);
                ++i2;
            }
            for (Integer pos : bracketPositions) {
                styleRange = new StyleRange();
                styleRange.start = pos;
                styleRange.length = 1;
                styleRange.foreground = darkBlueColor;
                styleRange.fontStyle = 1;
                functionAreaText.setStyleRange(styleRange);
            }
        }
        if ((textSplit = text.split(";")).length > 1) {
            bracketPositions = new ArrayList();
            position = 0;
            int i3 = 0;
            while (i3 < textSplit.length - 1) {
                position = position + textSplit[i3].length() + 1;
                bracketPositions.add(position - 1);
                ++i3;
            }
            for (Integer pos : bracketPositions) {
                styleRange = new StyleRange();
                styleRange.start = pos;
                styleRange.length = 1;
                styleRange.foreground = darkGreenColor;
                styleRange.fontStyle = 1;
                functionAreaText.setStyleRange(styleRange);
            }
        }
        if ((textSplit = text.split("\\?")).length > 1) {
            bracketPositions = new ArrayList();
            position = 0;
            int i4 = 0;
            while (i4 < textSplit.length - 1) {
                position = position + textSplit[i4].length() + 1;
                bracketPositions.add(position - 1);
                ++i4;
            }
            for (Integer pos : bracketPositions) {
                styleRange = new StyleRange();
                styleRange.start = pos;
                styleRange.length = 1;
                styleRange.foreground = redColor;
                styleRange.fontStyle = 1;
                functionAreaText.setStyleRange(styleRange);
            }
        }
    }

    public static enum Constructs {
        IMG("img", "images {\n    example = read;\n    result = write;\n} \n", "Initial image definition block", "control flow"),
        IF("if", "if (?) {\n    result = 1;\n} else {\n    result = 0;\n} \n", "If-else block", "control flow"),
        CON("con", "con(?, ?, ?) \n", "Conditional block", "control flow"),
        FOREACH("for", "foreach (dy in -1:1) {\n    foreach (dx in -1:1) {\n        n += srcimage[dx, dy] > someValue;\n    }\n} \n", "Foreach loop example which iterates through pixels in a 3x3 neighbourhood", "control flow"),
        WHILE("while", "while ( ? ) {\n\n} \n", "A conditional loop which executes the target statement or block while its conditional expression is non-zero", "control flow"),
        SEMICOLON(";", ";", "The semicolon, every statement", "general"),
        COMMENT("/* */", "/*\n* comment\n*/", "Block comment", "general"),
        COMMENTLINE("// ", "// comment", "Line comment", "general"),
        ARRAY("[a,b] ", "array = [1, 2, 3];", "Example declaration of an array", "general"),
        LOGICAL1("AND", "&&", "logical AND", "logical"),
        LOGICAL2("OR", "||", "logical OR", "logical"),
        LOGICAL3("==", "==", "equality test", "logical"),
        LOGICAL4("!=", "!=", "inequality test", "logical"),
        LOGICAL5("> ", "> ", "greater than", "logical"),
        LOGICAL6(">=", ">=", "greater than or equal to", "logical"),
        LOGICAL7("<=", "<=", "less than", "logical"),
        LOGICAL8("< ", "< ", "less than or equal to", "logical"),
        ARITHM1("^", "^", "Raise to power", "arithmetic"),
        ARITHM2("*", "*", "Multiply", "arithmetic"),
        ARITHM3("/", "/", "Divide", "arithmetic"),
        ARITHM4("%", "%", "Modulo (remainder)", "arithmetic"),
        ARITHM5("+", "+", "Add", "arithmetic"),
        ARITHM6("-", "-", "Subtract", "arithmetic"),
        ARITHM7("=", "=", "Assignment", "arithmetic"),
        SQRT("sqrt", "sqrt(?)", "Square root", "numeric"),
        ISNULL("null?", "isnull(?)", "Is null test on value x", "numeric"),
        ISINF("inf?", "isinf( ? )", "Is infinite test on value x", "numeric"),
        ISNAN("nan?", "isnan( ? )", "Is not a number test on value x", "numeric"),
        RADTODEG("r2d", "radToDeg( ? )", "Radians to degrees", "numeric"),
        DEG2RAD("r2d", "degToRad( ? )", "Degrees to radians", "numeric"),
        STATS1("max", "max(?, ?)", "Maximum", "statistical"),
        STATS3("mean", "mean(?)", "Mean", "statistical"),
        STATS4("min", "min(?, ?)", "Minimum", "statistical"),
        STATS6("med", "median(?)", "Median of an array of values", "statistical"),
        STATS7("mode", "mode(?)", "Mode of an array of values", "statistical"),
        STATS8("range", "range(?)", "Range of an array of values", "statistical"),
        STATS9("sdev", "sdev(?)", "Standard deviation of an array of values", "statistical"),
        STATS10("sum", "sum(?)", "Sum of an array of values", "statistical"),
        STATS11("var", "variance(?)", "Variance of an array of values", "statistical"),
        PROCESSINGSAREA1("h", "height()", "Height of the processing area (world units)", "processing area"),
        PROCESSINGSAREA2("w", "width()", "Width of the processing area (world units)", "processing area"),
        PROCESSINGSAREA3("xmin", "xmin()", "Minimum X ordinate of the processing area (world units)", "processing area"),
        PROCESSINGSAREA4("ymin", "ymin()", "Minimum Y ordinate of the processing area (world units)", "processing area"),
        PROCESSINGSAREA5("xmax", "xmax()", "Maximum X ordinate of the processing area (world units)", "processing area"),
        PROCESSINGSAREA6("ymax", "ymax()", "Maximum Y ordinate of the processing area (world units)", "processing area"),
        PROCESSINGSAREA7("x", "x()", "X ordinate of the current processing position (world units)", "processing area"),
        PROCESSINGSAREA8("y", "y()", "Y ordinate of the current processing position (world units)", "processing area"),
        PROCESSINGSAREA9("xres", "xres()", "Pixel width (world units)", "processing area"),
        PROCESSINGSAREA10("yres", "yres()", "Pixel height (world units)", "processing area");

        String name;
        String toolTip;
        String construct;
        String category;

        private Constructs(String name, String construct, String toolTip, String category) {
            this.name = name;
            this.toolTip = toolTip;
            this.construct = construct;
            this.category = category;
        }
    }
}

