/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.ui;

import eu.udig.omsbox.OmsBoxPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class SettingsDialog {
    private Dialog dialog;
    private List<String> resourcesList;
    private String currentSelectedJarPath;
    private TableViewer tableViewer;
    private boolean cancelPressed = false;

    public void open(Shell parentShell, int selectionType) {
        String[] retrieveSavedJars;
        this.resourcesList = new ArrayList<String>();
        String[] stringArray = retrieveSavedJars = OmsBoxPlugin.getDefault().retrieveSavedJars();
        int n = retrieveSavedJars.length;
        int n2 = 0;
        while (n2 < n) {
            String jarPath = stringArray[n2];
            this.resourcesList.add(jarPath);
            ++n2;
        }
        this.dialog = new Dialog(parentShell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("");
            }

            protected Point getInitialSize() {
                return new Point(640, 450);
            }

            protected Control createDialogArea(Composite parent) {
                Composite parentPanel = (Composite)super.createDialogArea(parent);
                TabFolder tabFolder = new TabFolder(parentPanel, 0);
                GridData tabFolderGD = new GridData(4, 4, true, true);
                tabFolder.setLayoutData((Object)tabFolderGD);
                TabItem librariesTabItem = new TabItem(tabFolder, 0);
                librariesTabItem.setText("General Settings");
                Composite librariesPanel = new Composite((Composite)tabFolder, 0);
                librariesPanel.setLayoutData((Object)new GridData(4, 4, true, true));
                librariesPanel.setLayout((Layout)new GridLayout(2, true));
                SettingsDialog.this.createWorkingFolderText(librariesPanel);
                Group librariesGroup = new Group(librariesPanel, 0);
                GridData librariesGroupGD = new GridData(4, 4, true, true);
                librariesGroupGD.horizontalSpan = 2;
                librariesGroup.setLayoutData((Object)librariesGroupGD);
                librariesGroup.setLayout((Layout)new GridLayout(2, false));
                librariesGroup.setText("Modules Libraries");
                SettingsDialog.this.createTableViewer((Composite)librariesGroup);
                SettingsDialog.this.createAddRemoveButtons((Composite)librariesGroup);
                librariesTabItem.setControl((Control)librariesPanel);
                TabItem grassTabItem = new TabItem(tabFolder, 0);
                grassTabItem.setText("Grass settings");
                Composite grassPanel = new Composite((Composite)tabFolder, 0);
                grassPanel.setLayoutData((Object)new GridData(4, 4, true, true));
                grassPanel.setLayout((Layout)new GridLayout(1, false));
                grassTabItem.setControl((Control)grassPanel);
                SettingsDialog.this.createGrassPanel(grassPanel);
                return parentPanel;
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 0) {
                    OmsBoxPlugin.getDefault().saveJars(SettingsDialog.this.resourcesList);
                    SettingsDialog.this.cancelPressed = false;
                } else {
                    SettingsDialog.this.cancelPressed = true;
                }
                super.buttonPressed(buttonId);
            }
        };
        this.dialog.setBlockOnOpen(true);
        this.dialog.open();
    }

    public boolean isDisposed() {
        return this.dialog.getShell().isDisposed();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public List<String> getSelectedResources() {
        return this.resourcesList;
    }

    public String getNameOfResourceAtIndex(int index) {
        return this.resourcesList.get(index);
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void createWorkingFolderText(Composite librariesPanel) {
        final Group workingFolderGroup = new Group(librariesPanel, 0);
        GridData workingFolderGroupGD = new GridData(4, 4, true, false);
        workingFolderGroupGD.horizontalSpan = 2;
        workingFolderGroup.setLayoutData((Object)workingFolderGroupGD);
        workingFolderGroup.setLayout((Layout)new GridLayout(2, false));
        workingFolderGroup.setText("Optional Spatial Toolbox Working Folder");
        final Text pathText = new Text((Composite)workingFolderGroup, 18436);
        pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String workingFolder = OmsBoxPlugin.getDefault().getWorkingFolder();
        if (workingFolder == null) {
            workingFolder = "";
        }
        pathText.setText(workingFolder);
        pathText.setEditable(false);
        Button browseButton = new Button((Composite)workingFolderGroup, 8);
        browseButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog folderDialog = new DirectoryDialog(workingFolderGroup.getShell(), 4096);
                String path = folderDialog.open();
                if (path != null && path.length() >= 1) {
                    OmsBoxPlugin.getDefault().setWorkingFolder(path);
                    pathText.setText(path);
                }
            }
        });
    }

    private void createGrassPanel(Composite grassPanel) {
        final Group gisbaseGroup = new Group(grassPanel, 0);
        gisbaseGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        gisbaseGroup.setLayout((Layout)new GridLayout(2, false));
        gisbaseGroup.setText("Grass Gisbase Path");
        final Text pathText = new Text((Composite)gisbaseGroup, 18436);
        pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String gisbasePreference = OmsBoxPlugin.getDefault().getGisbasePreference();
        if (gisbasePreference == null) {
            gisbasePreference = "";
        }
        pathText.setText(gisbasePreference);
        pathText.setEditable(false);
        Button browseButton = new Button((Composite)gisbaseGroup, 8);
        browseButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog folderDialog = new DirectoryDialog(gisbaseGroup.getShell(), 4096);
                String path = folderDialog.open();
                if (path != null && path.length() >= 1) {
                    OmsBoxPlugin.getDefault().setGisbasePreference(path);
                    pathText.setText(path);
                }
            }
        });
        final Group shellGroup = new Group(grassPanel, 0);
        shellGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        shellGroup.setLayout((Layout)new GridLayout(2, false));
        shellGroup.setText("Grass Shell");
        final Text shellText = new Text((Composite)shellGroup, 18436);
        shellText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String grassShell = OmsBoxPlugin.getDefault().getShellPreference();
        if (grassShell == null) {
            grassShell = "";
        }
        shellText.setText(grassShell);
        shellText.setEditable(false);
        Button shellButton = new Button((Composite)shellGroup, 8);
        shellButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        shellButton.setText("...");
        shellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(shellGroup.getShell(), 4096);
                String path = fileDialog.open();
                if (path != null && path.length() >= 1) {
                    OmsBoxPlugin.getDefault().setShellPreference(path);
                    shellText.setText(path);
                }
            }
        });
    }

    private void createTableViewer(Composite parentPanel) {
        this.tableViewer = new TableViewer(parentPanel);
        Control control = this.tableViewer.getControl();
        GridData controlGD = new GridData(4, 4, true, true);
        controlGD.horizontalSpan = 2;
        control.setLayoutData((Object)controlGD);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List paths = (List)inputElement;
                    Object[] array = paths.toArray(new Object[paths.size()]);
                    return array;
                }
                return new String[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    String jarPath = (String)element;
                    return jarPath;
                }
                return "";
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object selectedItem = sel.getFirstElement();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem instanceof String) {
                    SettingsDialog.this.currentSelectedJarPath = (String)selectedItem;
                }
            }
        });
        if (this.resourcesList.size() > 0) {
            this.tableViewer.setInput(this.resourcesList);
        } else {
            this.tableViewer.setInput((Object)"");
        }
    }

    private void createAddRemoveButtons(Composite parentPanel) {
        final Button addButton = new Button(parentPanel, 8);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addButton.setText("+");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] fileNames;
                FileDialog fileDialog = new FileDialog(addButton.getShell(), 4098);
                fileDialog.setFilterExtensions(new String[]{"*.jar"});
                fileDialog.setFilterPath(OmsBoxPlugin.getDefault().getLastFolderChosen());
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    return;
                }
                String filterPath = fileDialog.getFilterPath();
                OmsBoxPlugin.getDefault().setLastFolderChosen(filterPath);
                String[] stringArray = fileNames = fileDialog.getFileNames();
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    String jarPath = String.valueOf(filterPath) + File.separator + fileName;
                    if (!SettingsDialog.this.resourcesList.contains(jarPath)) {
                        SettingsDialog.this.resourcesList.add(jarPath);
                    }
                    ++n2;
                }
                SettingsDialog.this.tableViewer.setInput((Object)SettingsDialog.this.resourcesList);
            }
        });
        Button removeButton = new Button(parentPanel, 8);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        removeButton.setText("-");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SettingsDialog.this.currentSelectedJarPath != null) {
                    SettingsDialog.this.resourcesList.remove(SettingsDialog.this.currentSelectedJarPath);
                    SettingsDialog.this.tableViewer.setInput((Object)SettingsDialog.this.resourcesList);
                }
            }
        });
    }
}

