/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.ui;

import eu.udig.omsbox.ui.AbstractChooserDialog;
import eu.udig.omsbox.ui.CoverageCatalogTreeViewer;
import eu.udig.omsbox.ui.CoverageLayersTreeViewer;
import eu.udig.omsbox.ui.IGeoResourcesSelector;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CoverageChooserDialog
extends AbstractChooserDialog {
    private IGeoResourcesSelector active;
    private Dialog dialog;
    private List<IGeoResource> resourcesList;

    @Override
    public void open(Shell parentShell, final int selectionType) {
        this.dialog = new Dialog(parentShell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("");
            }

            protected Point getInitialSize() {
                return new Point(320, 450);
            }

            protected Control createDialogArea(Composite parent) {
                CoverageChooserDialog.this.parentPanel = (Composite)super.createDialogArea(parent);
                GridLayout gLayout = (GridLayout)CoverageChooserDialog.this.parentPanel.getLayout();
                gLayout.numColumns = 1;
                CoverageChooserDialog.this.active = new CoverageLayersTreeViewer(CoverageChooserDialog.this.parentPanel, 2048, selectionType);
                CoverageChooserDialog.this.makeCheckPanel();
                return CoverageChooserDialog.this.parentPanel;
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 0) {
                    CoverageChooserDialog.this.resourcesList = CoverageChooserDialog.this.active.getSelectedResources();
                } else {
                    CoverageChooserDialog.this.resourcesList = null;
                }
                super.buttonPressed(buttonId);
            }
        };
        this.dialog.setBlockOnOpen(true);
        this.dialog.open();
    }

    public boolean isDisposed() {
        return this.dialog.getShell().isDisposed();
    }

    public void widgetSelected(SelectionEvent e) {
        Button selectedButton = (Button)e.getSource();
        if (!selectedButton.getSelection()) {
            return;
        }
        this.isCatalogType = !selectedButton.getData("type").equals("visiblelayertype");
        Control[] childrens = this.parentPanel.getChildren();
        int i = 0;
        while (i < childrens.length) {
            childrens[i].dispose();
            ++i;
        }
        if (this.isCatalogType) {
            this.active = new CoverageCatalogTreeViewer(this.parentPanel, 2048, 4);
        } else if (!this.isCatalogType) {
            this.active = new CoverageLayersTreeViewer(this.parentPanel, 2048, 4);
        }
        this.makeCheckPanel();
        this.parentPanel.layout();
    }

    public List<IGeoResource> getSelectedResources() {
        return this.resourcesList;
    }

    @Override
    public String getNameOfResourceAtIndex(int index) {
        IGeoResource iGeoResource = this.resourcesList.get(index);
        return iGeoResource.getTitle();
    }
}

