/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.ui;

import eu.udig.omsbox.ui.IGeoResourcesSelector;
import eu.udig.omsbox.utils.ImageCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.opengis.coverage.grid.GridCoverage;

public class CoverageCatalogTreeViewer
extends Composite
implements ISelectionChangedListener,
IGeoResourcesSelector {
    private final HashMap<String, IGeoResource> itemsMap = new HashMap();
    private List<IGeoResource> selectedResources = new ArrayList<IGeoResource>();

    public CoverageCatalogTreeViewer(Composite parent, int style, int selectionStyle) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        try {
            this.getCoverageResources();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree((Composite)this, selectionStyle, patternFilter, true);
        TreeViewer tv = filter.getViewer();
        tv.getTree().setLayoutData((Object)new GridData(1808));
        tv.setContentProvider((IContentProvider)new MyContentProvider());
        MyLabelProvider labelProvider = new MyLabelProvider();
        tv.setLabelProvider((IBaseLabelProvider)labelProvider);
        tv.setInput(this.itemsMap);
        tv.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection iselection = event.getSelection();
        if (iselection.isEmpty()) {
            return;
        }
        if (iselection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)iselection;
            for (Object resource : selection) {
                this.selectedResources.add((IGeoResource)resource);
            }
        }
    }

    private void getCoverageResources() throws IOException {
        this.itemsMap.clear();
        ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
        List allCatalogMembers = catalog.members(null);
        for (IResolve catalogMember : allCatalogMembers) {
            if (catalogMember instanceof IGeoResource && catalogMember.canResolve(GridCoverage.class)) {
                this.itemsMap.put(catalogMember.getTitle(), (IGeoResource)catalogMember);
            }
            List members = catalogMember.members((IProgressMonitor)new NullProgressMonitor());
            for (IResolve iResolve : members) {
                if (iResolve instanceof IGeoResource && iResolve.canResolve(GridCoverage.class)) {
                    this.itemsMap.put(iResolve.getTitle(), (IGeoResource)iResolve);
                }
                List subMembers = iResolve.members((IProgressMonitor)new NullProgressMonitor());
                for (IResolve subResolve : subMembers) {
                    if (!(subResolve instanceof IGeoResource) || !subResolve.canResolve(GridCoverage.class)) continue;
                    this.itemsMap.put(((IGeoResource)subResolve).getTitle(), (IGeoResource)subResolve);
                }
            }
        }
    }

    @Override
    public List<IGeoResource> getSelectedResources() {
        return this.selectedResources;
    }

    private static class MyContentProvider
    implements ITreeContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object arg0) {
            return this.getChildren(arg0);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HashMap) {
                HashMap map = (HashMap)parentElement;
                Object[] array = map.keySet().toArray();
                Arrays.sort(array);
                return array;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public Image getImage(Object arg0) {
            return ImageCache.getInstance().getImage("icons/grid_obj.gif");
        }

        public String getText(Object arg0) {
            if (arg0 instanceof IGeoResource) {
                IGeoResource geoResr = (IGeoResource)arg0;
                return geoResr.getTitle();
            }
            if (arg0 instanceof String) {
                String name = (String)arg0;
                return name;
            }
            return null;
        }
    }
}

