/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.processingregion;

import eu.udig.omsbox.processingregion.ProcessingRegionMapGraphic;
import eu.udig.omsbox.processingregion.ProcessingRegionStyle;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.StyleContent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;

public class ProcessingRegionStyleContent
extends StyleContent {
    public static final String ID = "eu.udig.omsbox.processingregion.ProcessingRegionStyleContent";
    public static final String N = "N";
    public static final String S = "S";
    public static final String E = "E";
    public static final String W = "W";
    public static final String ROWS = "ROWS";
    public static final String COLS = "COLS";
    public static final String CRS = "CRS";
    public static final String BALPHA = "BALPHA";
    public static final String FALPHA = "FALPHA";

    public ProcessingRegionStyleContent() {
        super(ID);
    }

    public Class<?> getStyleClass() {
        return ProcessingRegionStyle.class;
    }

    public void save(IMemento memento, Object value) {
        ProcessingRegionStyle style = (ProcessingRegionStyle)value;
        memento.putString(N, String.valueOf(style.north));
        memento.putString(S, String.valueOf(style.south));
        memento.putString(E, String.valueOf(style.east));
        memento.putString(W, String.valueOf(style.west));
        memento.putInteger(ROWS, style.rows);
        memento.putInteger(COLS, style.cols);
        memento.putFloat(BALPHA, style.bAlpha);
        memento.putFloat(FALPHA, style.fAlpha);
    }

    public Object load(IMemento memento) {
        ProcessingRegionStyle style = ProcessingRegionStyleContent.createDefault();
        try {
            style.north = Double.parseDouble(memento.getString(N));
            style.south = Double.parseDouble(memento.getString(S));
            style.east = Double.parseDouble(memento.getString(E));
            style.west = Double.parseDouble(memento.getString(W));
            style.rows = memento.getInteger(ROWS);
            style.cols = memento.getInteger(COLS);
            style.bAlpha = memento.getFloat(BALPHA).floatValue();
            style.fAlpha = memento.getFloat(FALPHA).floatValue();
        }
        catch (Exception exception) {
            style = ProcessingRegionStyleContent.createDefault();
        }
        return style;
    }

    public Object load(URL url, IProgressMonitor monitor) throws IOException {
        return null;
    }

    public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor monitor) throws IOException {
        if (!resource.canResolve(ProcessingRegionMapGraphic.class)) {
            return null;
        }
        return ProcessingRegionStyleContent.createDefault();
    }

    public static ProcessingRegionStyle createDefault() {
        ProcessingRegionStyle style = new ProcessingRegionStyle();
        style.north = 100.0;
        style.south = 0.0;
        style.east = 100.0;
        style.west = 0.0;
        style.rows = 10;
        style.cols = 10;
        style.bAlpha = 0.3f;
        style.backgroundColor = new Color(0.08627451f, 0.6392157f, 0.8666667f, style.bAlpha);
        style.fAlpha = 0.5f;
        style.foregroundColor = new Color(0.09411765f, 0.4862745f, 0.64705884f, style.fAlpha);
        return style;
    }
}

