/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.processingregion;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.omsbox.processingregion.ProcessingRegionStyle;
import eu.udig.omsbox.processingregion.ProcessingRegionStyleContent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.Collections;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.ui.graphics.AWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;

public class ProcessingRegionMapGraphic
implements MapGraphic {
    public static final String ID = "eu.udig.omsbox.processingregion.ProcessingRegionMapGraphic";

    public void draw(MapGraphicContext context) {
        context.getLayer().setStatus(5);
        ViewportGraphics g = context.getGraphics();
        if (g instanceof AWTGraphics) {
            AWTGraphics awtG = (AWTGraphics)g;
            Graphics2D g2D = awtG.g;
            RenderingHints hints = new RenderingHints(Collections.EMPTY_MAP);
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2D.addRenderingHints(hints);
        }
        Dimension screen = context.getMapDisplay().getDisplaySize();
        IStyleBlackboard blackboard = context.getLayer().getStyleBlackboard();
        ProcessingRegionStyle style = (ProcessingRegionStyle)blackboard.get("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent");
        if (style == null) {
            style = ProcessingRegionStyleContent.createDefault();
            blackboard.put("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent", (Object)style);
        }
        Coordinate ul = new Coordinate(style.west, style.north);
        Coordinate ur = new Coordinate(style.east, style.north);
        Coordinate ll = new Coordinate(style.west, style.south);
        Coordinate lr = new Coordinate(style.east, style.south);
        float[] rgba = style.backgroundColor.getColorComponents(null);
        g.setColor(new Color(rgba[0], rgba[1], rgba[2], style.bAlpha));
        Point ulPoint = context.worldToPixel(ul);
        Point urPoint = context.worldToPixel(ur);
        Point llPoint = context.worldToPixel(ll);
        Point lrPoint = context.worldToPixel(lr);
        int screenWidth = screen.width;
        int screenHeight = screen.height;
        GeneralPath path = new GeneralPath(0);
        path.moveTo(0.0f, 0.0f);
        path.lineTo(screenWidth, 0.0f);
        path.lineTo(screenWidth, screenHeight);
        path.lineTo(0.0f, screenHeight);
        path.closePath();
        path.moveTo(ulPoint.x, ulPoint.y);
        path.lineTo(urPoint.x, urPoint.y);
        path.lineTo(lrPoint.x, lrPoint.y);
        path.lineTo(llPoint.x, llPoint.y);
        path.closePath();
        g.fill((Shape)path);
        rgba = style.foregroundColor.getColorComponents(null);
        g.setColor(new Color(rgba[0], rgba[1], rgba[2], style.fAlpha));
        g.setStroke(1, 2);
        g.draw((Shape)path);
        context.getLayer().setStatus(0);
        context.getLayer().setStatusMessage("Layer rendered");
    }
}

