/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.processingregion;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.processingregion.ProcessingRegion;
import eu.udig.omsbox.processingregion.ProcessingRegionStyle;
import eu.udig.omsbox.processingregion.ProcessingRegionStyleContent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.SimpleTool;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ProcessingRegionBBoxSelection
extends SimpleTool
implements ModalTool {
    public static final String ID = "eu.udig.omsbox.processingregion.ProcessingRegionBBoxSelection";
    private Point start;
    private boolean selecting;
    private SelectionBoxCommand shapeCommand;

    public ProcessingRegionBBoxSelection() {
        super(3);
        OmsBoxPlugin.getDefault().getProcessingRegionMapGraphic();
    }

    protected void onMouseDragged(MapMouseEvent e) {
        Point end = e.getPoint();
        this.shapeCommand.setShape((Shape)new Rectangle(Math.min(this.start.x, end.x), Math.min(this.start.y, end.y), Math.abs(this.start.x - end.x), Math.abs(this.start.y - end.y)));
        this.context.getViewportPane().repaint();
    }

    public void onMousePressed(MapMouseEvent e) {
        this.shapeCommand = new SelectionBoxCommand();
        if ((e.button & 8) != 0) {
            this.selecting = true;
            this.start = e.getPoint();
            this.shapeCommand.setValid(true);
            this.shapeCommand.setShape((Shape)new Rectangle(this.start.x, this.start.y, 0, 0));
            this.context.sendASyncCommand((Command)this.shapeCommand);
        }
    }

    public void onMouseReleased(MapMouseEvent e) {
        if (this.selecting) {
            Point end = e.getPoint();
            if (this.start == null || this.start.equals(end)) {
                ReferencedEnvelope bounds = this.getContext().getBoundingBox(e.getPoint(), 3);
                this.sendSelectionCommand(e, (Envelope)bounds);
            } else {
                Coordinate c1 = this.context.getMap().getViewportModel().pixelToWorld(this.start.x, this.start.y);
                Coordinate c2 = this.context.getMap().getViewportModel().pixelToWorld(end.x, end.y);
                Envelope newRegionBounds = new Envelope(c1, c2);
                ILayer processingRegionLayer = OmsBoxPlugin.getDefault().getProcessingRegionMapGraphic();
                IStyleBlackboard blackboard = processingRegionLayer.getStyleBlackboard();
                ProcessingRegionStyle style = (ProcessingRegionStyle)blackboard.get("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent");
                if (style == null) {
                    style = ProcessingRegionStyleContent.createDefault();
                }
                ProcessingRegion processinRegion = new ProcessingRegion(style.west, style.east, style.south, style.north, style.rows, style.cols);
                ProcessingRegion newProcessingRegion = ProcessingRegion.adaptActiveRegionToEnvelope(newRegionBounds, processinRegion);
                style.north = newProcessingRegion.getNorth();
                style.south = newProcessingRegion.getSouth();
                style.east = newProcessingRegion.getEast();
                style.west = newProcessingRegion.getWest();
                style.rows = newProcessingRegion.getRows();
                style.cols = newProcessingRegion.getCols();
                blackboard.put("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent", (Object)style);
                processingRegionLayer.refresh(null);
                newRegionBounds = newProcessingRegion.getEnvelope();
                this.sendSelectionCommand(e, newRegionBounds);
            }
        }
    }

    protected void sendSelectionCommand(MapMouseEvent e, Envelope bounds) {
        UndoableMapCommand command = e.isModifierDown(MapMouseEvent.MOD2_DOWN_MASK) ? this.getContext().getSelectionFactory().createBBoxSelectionCommand(bounds, 1) : (e.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK) ? this.getContext().getSelectionFactory().createBBoxSelectionCommand(bounds, -1) : this.getContext().getSelectionFactory().createBBoxSelectionCommand(bounds, 0));
        this.getContext().sendASyncCommand((Command)command);
        this.selecting = false;
        this.shapeCommand.setValid(false);
        this.getContext().getViewportPane().repaint();
    }
}

