/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.processingregion;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.processingregion.ProcessingRegion;
import eu.udig.omsbox.processingregion.ProcessingRegionStyle;
import eu.udig.omsbox.processingregion.ProcessingRegionStyleContent;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ProcessingRegionAOIStrategy
extends IAOIStrategy {
    private static String name = "Processing Region";

    public ReferencedEnvelope getExtent() {
        ILayer processingRegionLayer = OmsBoxPlugin.getDefault().getProcessingRegionMapGraphic();
        if (processingRegionLayer != null) {
            IStyleBlackboard blackboard = processingRegionLayer.getStyleBlackboard();
            ProcessingRegionStyle style = (ProcessingRegionStyle)blackboard.get("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent");
            if (style == null) {
                style = ProcessingRegionStyleContent.createDefault();
            }
            ProcessingRegion processinRegion = new ProcessingRegion(style.west, style.east, style.south, style.north, style.rows, style.cols);
            ReferencedEnvelope envelope = new ReferencedEnvelope(processinRegion.getEnvelope(), this.getCrs());
            return envelope;
        }
        return null;
    }

    public Geometry getGeometry() {
        ReferencedEnvelope extent = this.getExtent();
        if (extent != null) {
            return new GeometryFactory().toGeometry((Envelope)extent);
        }
        return null;
    }

    public CoordinateReferenceSystem getCrs() {
        ILayer processingRegionMapGraphic = OmsBoxPlugin.getDefault().getProcessingRegionMapGraphic();
        if (processingRegionMapGraphic != null) {
            processingRegionMapGraphic.getCRS();
        }
        return null;
    }

    public String getName() {
        return name;
    }
}

