/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.core;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.utils.AnnotationUtilities;
import eu.udig.omsbox.utils.OmsBoxUtils;
import eu.udig.omsbox.utils.ResourceFinder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Description;
import oms3.annotations.Label;
import oms3.annotations.Name;
import oms3.annotations.Range;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import oms3.util.Components;

public class OmsModulesManager {
    private static OmsModulesManager modulesManager;
    private List<String> loadedJarsList = new ArrayList<String>();
    private HashMap<String, List<ModuleDescription>> modulesMap;
    private List<ModuleDescription> gridReaders = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> rasterReaders = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> rasterWriters = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> featureReaders = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> featureWriters = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> hashMapReaders = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> hashMapWriters = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> listReaders = new ArrayList<ModuleDescription>();
    private List<ModuleDescription> listWriters = new ArrayList<ModuleDescription>();
    private URLClassLoader jarClassloader;

    private OmsModulesManager() {
        this.getModulesJars();
    }

    public List<String> getModulesJars() {
        String[] retrieveSavedJars;
        ArrayList<String> jarsPathList = new ArrayList<String>();
        String[] stringArray = retrieveSavedJars = OmsBoxPlugin.getDefault().retrieveSavedJars();
        int n = retrieveSavedJars.length;
        int n2 = 0;
        while (n2 < n) {
            String jar = stringArray[n2];
            this.addJar(jar);
            jarsPathList.add(jar);
            ++n2;
        }
        File extraSpatialtoolboxLibsFolder = OmsBoxPlugin.getExtraSpatialtoolboxLibsFolder();
        if (extraSpatialtoolboxLibsFolder != null) {
            File[] extraJars;
            OmsBoxPlugin.log("Searching module libraries in: " + extraSpatialtoolboxLibsFolder.getAbsolutePath());
            File[] fileArray = extraJars = extraSpatialtoolboxLibsFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            int n3 = extraJars.length;
            int n4 = 0;
            while (n4 < n3) {
                File extraJar = fileArray[n4];
                this.addJar(extraJar.getAbsolutePath());
                jarsPathList.add(extraJar.getAbsolutePath());
                ++n4;
            }
        }
        return jarsPathList;
    }

    public static synchronized OmsModulesManager getInstance() {
        if (modulesManager == null) {
            modulesManager = new OmsModulesManager();
        }
        return modulesManager;
    }

    public void addJar(String newJar) {
        if (!this.loadedJarsList.contains(newJar)) {
            this.loadedJarsList.add(newJar);
        }
    }

    public void removeJar(String removeJar) {
        if (this.loadedJarsList.contains(removeJar)) {
            this.loadedJarsList.remove(removeJar);
        }
    }

    public void clearJars() {
        this.loadedJarsList.clear();
    }

    public HashMap<String, List<ModuleDescription>> browseModules(boolean rescan) {
        try {
            if (this.modulesMap == null) {
                this.modulesMap = new HashMap();
            } else if (rescan) {
                this.modulesMap.clear();
                this.gridReaders.clear();
                this.rasterReaders.clear();
                this.rasterWriters.clear();
                this.featureReaders.clear();
                this.featureWriters.clear();
                this.hashMapReaders.clear();
                this.hashMapWriters.clear();
                this.listWriters.clear();
                this.listReaders.clear();
            } else if (this.modulesMap.size() > 0) {
                return this.modulesMap;
            }
            this.scanForModules();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.modulesMap = new HashMap();
        }
        Set<Map.Entry<String, List<ModuleDescription>>> entrySet = this.modulesMap.entrySet();
        for (Map.Entry<String, List<ModuleDescription>> entry : entrySet) {
            Collections.sort(entry.getValue(), new ModuleDescription.ModuleDescriptionNameComparator());
        }
        return this.modulesMap;
    }

    public List<ModuleDescription> getFeatureReaders() {
        return this.cloneList(this.featureReaders);
    }

    public List<ModuleDescription> getFeatureWriters() {
        return this.cloneList(this.featureWriters);
    }

    public List<ModuleDescription> getGridReaders() {
        return this.cloneList(this.gridReaders);
    }

    public List<ModuleDescription> getRasterReaders() {
        return this.cloneList(this.rasterReaders);
    }

    public List<ModuleDescription> getRasterWriters() {
        return this.cloneList(this.rasterWriters);
    }

    public List<ModuleDescription> getHashMapReaders() {
        return this.cloneList(this.hashMapReaders);
    }

    public List<ModuleDescription> getHashMapWriters() {
        return this.cloneList(this.hashMapWriters);
    }

    public List<ModuleDescription> getListReaders() {
        return this.cloneList(this.listReaders);
    }

    public List<ModuleDescription> getListWriters() {
        return this.cloneList(this.listWriters);
    }

    public List<ModuleDescription> cloneList(List<ModuleDescription> list) {
        ArrayList<ModuleDescription> copy = new ArrayList<ModuleDescription>();
        for (ModuleDescription moduleDescription : list) {
            copy.add(moduleDescription.makeCopy());
        }
        return copy;
    }

    private void scanForModules() throws Exception {
        if (this.loadedJarsList.size() == 0) {
            return;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        int i = 0;
        while (i < this.loadedJarsList.size()) {
            String jarPath = this.loadedJarsList.get(i);
            File jarFile = new File(jarPath);
            if (jarFile.exists()) {
                urlList.add(jarFile.toURI().toURL());
            }
            ++i;
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        this.jarClassloader = new URLClassLoader(urls, this.getClass().getClassLoader());
        long t1 = System.currentTimeMillis();
        ArrayList<Class<Object>> classesList = new ArrayList<Class<Object>>();
        for (URL url : urlList) {
            ResourceFinder finder = new ResourceFinder("META-INF/", url);
            Map<String, Properties> servicesList = finder.mapAllProperties("services");
            Set<Map.Entry<String, Properties>> set = servicesList.entrySet();
            for (Map.Entry<String, Properties> serviceEntry : set) {
                Properties properties = serviceEntry.getValue();
                Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    Name name;
                    String className = entry.getKey().toString();
                    Class<?> possibleModulesClass = null;
                    try {
                        possibleModulesClass = Class.forName(className, true, this.jarClassloader);
                    }
                    catch (Exception exception) {}
                    if (possibleModulesClass == null || (name = possibleModulesClass.getAnnotation(Name.class)) == null) continue;
                    classesList.add(possibleModulesClass);
                }
            }
        }
        long t2 = System.currentTimeMillis();
        System.out.println((t2 - t1) / 1000L);
        if (classesList.size() == 0) {
            List allComponents = new ArrayList();
            try {
                allComponents = Components.getComponentClasses((ClassLoader)this.jarClassloader, (URL[])urls);
                classesList.addAll(allComponents);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        long t3 = System.currentTimeMillis();
        System.out.println((t3 - t2) / 1000L);
        OmsBoxUtils.cleanModuleDocumentation();
        for (Class clazz : classesList) {
            try {
                String uiHintStr;
                UI uiHints = clazz.getAnnotation(UI.class);
                if (uiHints != null && (uiHintStr = uiHints.value()).contains("hide")) continue;
                Label category = clazz.getAnnotation(Label.class);
                String categoryStr = "Others";
                if (category != null && categoryStr.trim().length() > 1) {
                    categoryStr = category.value();
                }
                if (clazz.getName().endsWith("Buffer")) {
                    System.out.println();
                }
                Description description = clazz.getAnnotation(Description.class);
                String descrStr = null;
                if (description != null) {
                    descrStr = description.value();
                }
                Status status = clazz.getAnnotation(Status.class);
                ModuleDescription module = new ModuleDescription(clazz, categoryStr, descrStr, status);
                Object newInstance = null;
                try {
                    newInstance = clazz.newInstance();
                    String className = module.getClassName();
                    OmsBoxUtils.generateModuleDocumentation(className);
                }
                catch (Throwable throwable) {
                    continue;
                }
                ComponentAccess cA = new ComponentAccess(newInstance);
                Collection inputs = cA.inputs();
                for (Access access : inputs) {
                    this.addInput(access, module);
                }
                Collection outputs = cA.outputs();
                for (Access access : outputs) {
                    this.addOutput(access, module);
                }
                if (categoryStr.equals("Grid Geometry Reader")) {
                    this.gridReaders.add(module);
                    continue;
                }
                if (categoryStr.equals("Raster Reader")) {
                    this.rasterReaders.add(module);
                    continue;
                }
                if (categoryStr.equals("Raster Writer")) {
                    this.rasterWriters.add(module);
                    continue;
                }
                if (categoryStr.equals("Vector Reader")) {
                    this.featureReaders.add(module);
                    continue;
                }
                if (categoryStr.equals("Vector Writer")) {
                    this.featureWriters.add(module);
                    continue;
                }
                if (categoryStr.equals("Generic Reader") || categoryStr.equals("Generic Writer")) continue;
                if (categoryStr.equals("HashMap Data Reader")) {
                    this.hashMapReaders.add(module);
                    continue;
                }
                if (categoryStr.equals("HashMap Data Writer")) {
                    this.hashMapWriters.add(module);
                    continue;
                }
                if (categoryStr.equals("List Data Reader")) {
                    this.listReaders.add(module);
                    continue;
                }
                if (categoryStr.equals("List Data Writer")) {
                    this.listWriters.add(module);
                    continue;
                }
                List<ModuleDescription> modulesList4Category = this.modulesMap.get(categoryStr);
                if (modulesList4Category == null) {
                    modulesList4Category = new ArrayList<ModuleDescription>();
                    this.modulesMap.put(categoryStr, modulesList4Category);
                }
                modulesList4Category.add(module);
            }
            catch (NoClassDefFoundError e) {
                if (clazz != null) {
                    System.out.println("ERROR IN: " + clazz.getCanonicalName());
                }
                e.printStackTrace();
            }
        }
        long l = System.currentTimeMillis();
        System.out.println((l - t3) / 1000L);
    }

    private void addInput(Access access, ModuleDescription module) throws Exception {
        Range rangeAnn;
        Field field = access.getField();
        Description descriptionAnn = field.getAnnotation(Description.class);
        String descriptionStr = "No description available";
        if (descriptionAnn != null) {
            descriptionStr = AnnotationUtilities.getLocalizedDescription(descriptionAnn);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(descriptionStr);
        Unit unitAnn = field.getAnnotation(Unit.class);
        if (unitAnn != null) {
            sb.append(" [");
            sb.append(unitAnn.value());
            sb.append("]");
        }
        if ((rangeAnn = field.getAnnotation(Range.class)) != null) {
            sb.append(" [");
            sb.append(rangeAnn.min());
            sb.append(" ,");
            sb.append(rangeAnn.max());
            sb.append("]");
        }
        descriptionStr = sb.toString();
        String fieldName = field.getName();
        Class<?> fieldClass = field.getType();
        Object fieldValue = access.getFieldValue();
        String defaultValue = "";
        if (fieldValue != null) {
            defaultValue = fieldValue.toString();
        }
        UI uiHintAnn = field.getAnnotation(UI.class);
        String uiHint = null;
        if (uiHintAnn != null) {
            uiHint = uiHintAnn.value();
        }
        module.addInput(fieldName, fieldClass.getCanonicalName(), descriptionStr, defaultValue, uiHint);
    }

    private void addOutput(Access access, ModuleDescription module) throws Exception {
        Range rangeAnn;
        Field field = access.getField();
        Description descriptionAnn = field.getAnnotation(Description.class);
        String descriptionStr = "No description available";
        if (descriptionAnn != null) {
            descriptionStr = AnnotationUtilities.getLocalizedDescription(descriptionAnn);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(descriptionStr);
        Unit unitAnn = field.getAnnotation(Unit.class);
        if (unitAnn != null) {
            sb.append(" [");
            sb.append(unitAnn.value());
            sb.append("]");
        }
        if ((rangeAnn = field.getAnnotation(Range.class)) != null) {
            sb.append(" [");
            sb.append(rangeAnn.min());
            sb.append(" ,");
            sb.append(rangeAnn.max());
            sb.append("]");
        }
        descriptionStr = sb.toString();
        String fieldName = field.getName();
        Class<?> fieldClass = field.getType();
        Object fieldValue = access.getFieldValue();
        String defaultValue = "";
        if (fieldValue != null) {
            defaultValue = fieldValue.toString();
        }
        UI uiHintAnn = field.getAnnotation(UI.class);
        String uiHint = null;
        if (uiHintAnn != null) {
            uiHint = uiHintAnn.value();
        }
        module.addOutput(fieldName, fieldClass.getCanonicalName(), descriptionStr, defaultValue, uiHint);
    }

    public Class<?> getModulesClass(String className) throws ClassNotFoundException {
        Class<?> moduleClass = Class.forName(className, true, this.jarClassloader);
        return moduleClass;
    }

    public InputStream getResourceAsStream(String fullName) throws IOException {
        URL resource = this.jarClassloader.getResource(fullName);
        InputStream resourceAsStream = resource.openStream();
        return resourceAsStream;
    }
}

