/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wfs.ui;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wfs.WFSServiceImpl;
import net.refractions.udig.catalog.internal.wfs.WfsPlugin;
import net.refractions.udig.catalog.internal.wfs.ui.WFSConnectionFactory;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.wizard.DataStoreWizardPage;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.wfs.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.wfs.WFSDataStoreFactory;

public class WFSRegistryWizardPage
extends DataStoreWizardPage
implements ModifyListener,
SelectionListener,
UDIGConnectionPage {
    protected Combo urlCombo = null;
    private Button advancedTag = null;
    private Composite advanced = null;
    protected Button getDefault;
    protected Button postDefault;
    protected Text bufferText;
    protected Text timeoutText;
    protected static final String timeoutDefault = "3";
    protected static final String bufferDefault = "100";
    protected static final String maxFeaturesDefault = "0";
    private IDialogSettings settings;
    private static final String WFS_WIZARD_ID = "WFSWizard";
    private static final String WFS_RECENTLY_USED_ID = "RecentlyUsed";
    private String url = "";
    WFSConnectionFactory wfsConnFactory = new WFSConnectionFactory();
    private Color red;
    private WFSDataStoreFactory factory = new WFSDataStoreFactory();
    private static final int COMBO_HISTORY_LENGTH = 15;

    public WFSRegistryWizardPage(String name) {
        super(name);
        this.settings = WfsPlugin.getDefault().getDialogSettings().getSection(WFS_WIZARD_ID);
        if (this.settings == null) {
            this.settings = WfsPlugin.getDefault().getDialogSettings().addNewSection(WFS_WIZARD_ID);
        }
    }

    public WFSRegistryWizardPage() {
        this("");
    }

    public String getId() {
        return "net.refractions.udig.catalog.ui.wfs";
    }

    protected Map<String, Serializable> defaultParams() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Map<String, Serializable> toParams = this.toParams(selection);
        if (!toParams.isEmpty()) {
            return toParams;
        }
        WFSConnectionFactory connectionFactory = new WFSConnectionFactory();
        Map<String, Serializable> params = connectionFactory.createConnectionParameters(this.getState().getWorkflow().getContext());
        if (params != null) {
            return params;
        }
        return Collections.emptyMap();
    }

    protected Map<String, Serializable> toParams(IStructuredSelection context) {
        if (context == null) {
            return Collections.emptyMap();
        }
        Iterator itr = context.iterator();
        while (itr.hasNext()) {
            Map<String, Serializable> params = this.wfsConnFactory.createConnectionParameters(itr.next());
            if (params.isEmpty()) continue;
            return params;
        }
        return Collections.emptyMap();
    }

    public void createControl(Composite arg0) {
        URL selectedURL;
        Group composite = new Group(arg0, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)composite, 0);
        label.setText(Messages.WFSRegistryWizardPage_label_url_text);
        label.setToolTipText(Messages.WFSRegistryWizardPage_label_url_tooltip);
        label.setLayoutData((Object)new GridData(0x1000008, -1, false, false));
        String[] temp = this.settings.getArray(WFS_RECENTLY_USED_ID);
        if (temp == null) {
            temp = new String[]{};
        }
        List<String> recent = Arrays.asList(temp);
        GridData gridData = new GridData(768);
        gridData.widthHint = 400;
        Map<String, Serializable> params = this.defaultParams();
        try {
            selectedURL = (URL)WFSDataStoreFactory.URL.lookUp(params);
        }
        catch (IOException iOException) {
            selectedURL = null;
        }
        this.urlCombo = new Combo((Composite)composite, 2048);
        this.urlCombo.setItems(recent.toArray(new String[recent.size()]));
        this.urlCombo.setVisibleItemCount(15);
        this.urlCombo.setLayoutData((Object)gridData);
        if (selectedURL != null) {
            this.urlCombo.setText(selectedURL.toExternalForm());
        } else if (this.url != null && this.url.length() != 0) {
            this.urlCombo.setText(this.url);
        } else {
            this.urlCombo.setText("http://");
        }
        this.urlCombo.addModifyListener((ModifyListener)this);
        label = new Label((Composite)composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 3));
        this.advancedTag = new Button((Composite)composite, 32);
        this.advancedTag.setLayoutData((Object)new GridData(0x1000000, -1, false, false));
        this.advancedTag.setSelection(false);
        this.advancedTag.addSelectionListener((SelectionListener)this);
        this.advancedTag.setText(Messages.WFSRegistryWizardPage_advanced_text);
        this.advancedTag.setToolTipText(Messages.WFSRegistryWizardPage_advanced_tooltip);
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData(-1, -1, false, false));
        this.advanced = this.createAdvancedControl((Composite)composite);
        this.advanced.setLayoutData((Object)new GridData(0x1000000, -1, true, true, 2, 1));
        this.setControl((Control)composite);
        this.setPageComplete(true);
        this.urlCombo.addModifyListener((ModifyListener)this);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                EndConnectionState currentState = WFSRegistryWizardPage.this.getState();
                Map errors = currentState.getErrors();
                if (errors != null && !errors.isEmpty()) {
                    for (Map.Entry entry : errors.entrySet()) {
                        if (!(entry.getKey() instanceof WFSServiceImpl)) continue;
                        Throwable value = (Throwable)entry.getValue();
                        if (value instanceof ConnectException) {
                            WFSRegistryWizardPage.this.setErrorMessage(Messages.WFSRegistryWizardPage_serverConnectionProblem);
                            continue;
                        }
                        String message = String.valueOf(Messages.WFSRegistryWizardPage_problemConnecting) + value.getLocalizedMessage();
                        WFSRegistryWizardPage.this.setErrorMessage(message);
                    }
                }
            }
        });
    }

    private Composite createAdvancedControl(Composite arg0) {
        this.advanced = new Group(arg0, 2048);
        this.advanced.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.advanced, 0);
        label.setText("GET");
        label.setToolTipText(Messages.WFSRegistryWizardPage_label_get_tooltip);
        label.setLayoutData((Object)new GridData(0x1000000, -1, false, false));
        this.getDefault = new Button(this.advanced, 32);
        this.getDefault.setLayoutData((Object)new GridData(0x1000000, -1, false, false));
        this.getDefault.setSelection(false);
        this.getDefault.addSelectionListener((SelectionListener)this);
        label = new Label(this.advanced, 0);
        label.setText("POST");
        label.setToolTipText(Messages.WFSRegistryWizardPage_label_post_tooltip);
        label.setLayoutData((Object)new GridData(0x1000000, -1, false, false));
        this.postDefault = new Button(this.advanced, 32);
        this.postDefault.setLayoutData((Object)new GridData(0x1000000, -1, false, false));
        this.postDefault.setSelection(false);
        this.postDefault.addSelectionListener((SelectionListener)this);
        label = new Label(this.advanced, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 3));
        label = new Label(this.advanced, 0);
        label.setText(Messages.WFSRegistryWizardPage_label_buffer_text);
        label.setToolTipText(Messages.WFSRegistryWizardPage_label_buffer_tooltip);
        label.setLayoutData((Object)new GridData(0x1000000, -1, false, false));
        this.bufferText = new Text(this.advanced, 133120);
        this.bufferText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.bufferText.setText(bufferDefault);
        this.bufferText.setTextLimit(5);
        this.bufferText.addModifyListener((ModifyListener)this);
        label = new Label(this.advanced, 0);
        label.setText(Messages.WFSRegistryWizardPage_label_timeout_text);
        label.setToolTipText(Messages.WFSRegistryWizardPage_label_timeout_tooltip);
        label.setLayoutData((Object)new GridData(0x1000000, -1, false, false));
        this.timeoutText = new Text(this.advanced, 133120);
        this.timeoutText.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        this.timeoutText.setText(timeoutDefault);
        this.timeoutText.setTextLimit(5);
        this.timeoutText.addModifyListener((ModifyListener)this);
        this.advanced.setVisible(false);
        return this.advanced;
    }

    public void setErrorMessage(String newMessage) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setErrorMessage(newMessage);
    }

    public void setMessage(String newMessage) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setMessage(newMessage);
    }

    public void setMessage(String newMessage, int messageType) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setMessage(newMessage, messageType);
    }

    public EndConnectionState getState() {
        return (EndConnectionState)super.getState();
    }

    public void dispose() {
        super.dispose();
        if (this.red != null) {
            this.red.dispose();
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget != null && e.widget instanceof Text) {
            ((Text)e.widget).setForeground(null);
        }
        if (e.widget == this.urlCombo) {
            ((Combo)e.widget).setForeground(null);
            this.setErrorMessage(null);
            this.url = this.urlCombo.getText();
        }
        this.getContainer().updateButtons();
    }

    public void widgetSelected(SelectionEvent e) {
        Button b = (Button)e.widget;
        if (b.equals(this.getDefault)) {
            if (this.getDefault.getSelection() && this.postDefault.getSelection()) {
                this.postDefault.setSelection(false);
            }
        } else if (b.equals(this.postDefault)) {
            if (this.postDefault.getSelection() && this.getDefault.getSelection()) {
                this.getDefault.setSelection(false);
            }
        } else if (b.equals(this.advancedTag)) {
            this.advanced.setVisible(this.advancedTag.getSelection());
        }
        this.getWizard().getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.getWizard().canFinish()) {
            this.getWizard().performFinish();
        }
    }

    public boolean isPageComplete() {
        Map<String, Serializable> params = this.getParams();
        if (params == null) {
            return false;
        }
        URL url = (URL)params.get(WFSDataStoreFactory.URL.key);
        String trim = url.getHost().trim();
        if (trim.length() == 0) {
            return false;
        }
        return this.factory.canProcess(params);
    }

    public List<URL> getURLs() {
        return null;
    }

    public Map<String, Serializable> getParams() {
        String buffer;
        HashMap<String, Serializable> dsParams = new HashMap<String, Serializable>();
        boolean error = false;
        try {
            URL u = new URL(this.urlCombo.getText());
            dsParams.put(WFSDataStoreFactory.URL.key, u);
        }
        catch (Exception exception) {
            if (this.red == null) {
                this.red = new Color(null, 255, 0, 0);
            }
            this.urlCombo.setForeground(this.red);
            error = true;
        }
        if (this.postDefault.getSelection()) {
            dsParams.put(WFSDataStoreFactory.PROTOCOL.key, Boolean.TRUE);
        } else if (this.getDefault.getSelection()) {
            dsParams.put(WFSDataStoreFactory.PROTOCOL.key, Boolean.FALSE);
        } else {
            dsParams.put(WFSDataStoreFactory.PROTOCOL.key, null);
        }
        String timeout = this.timeoutText.getText();
        if (!timeoutDefault.equals(timeout)) {
            Integer sec = null;
            try {
                sec = new Integer(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                if (this.red == null) {
                    this.red = new Color(null, 255, 0, 0);
                }
                this.timeoutText.setForeground(this.red);
                error = true;
            }
            dsParams.put(WFSDataStoreFactory.TIMEOUT.key, new Integer(sec * 1000));
        }
        if (!bufferDefault.equals(buffer = this.bufferText.getText())) {
            Integer sec = null;
            try {
                sec = new Integer(buffer);
            }
            catch (NumberFormatException numberFormatException) {
                if (this.red == null) {
                    this.red = new Color(null, 255, 0, 0);
                }
                this.bufferText.setForeground(this.red);
                error = true;
            }
            dsParams.put(WFSDataStoreFactory.BUFFER_SIZE.key, sec);
        }
        return error ? null : dsParams;
    }

    public List<IService> getResources(IProgressMonitor monitor) throws Exception {
        if (!this.isPageComplete()) {
            return null;
        }
        List list = CatalogPlugin.getDefault().getServiceFactory().createService(this.getParams());
        this.saveWidgetValues();
        return list;
    }

    protected DataStoreFactorySpi getDataStoreFactorySpi() {
        return this.factory;
    }

    private void saveWidgetValues() {
        if (this.settings != null) {
            String[] recentWFSs = this.settings.getArray(WFS_RECENTLY_USED_ID);
            if (recentWFSs == null) {
                recentWFSs = new String[]{};
            }
            recentWFSs = this.addToHistory(recentWFSs, this.urlCombo.getText());
            this.settings.put(WFS_RECENTLY_USED_ID, recentWFSs);
        }
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 15) {
            history.remove(15);
        }
    }
}

