/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wfs.ui;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wfs.WFSGeoResourceImpl;
import net.refractions.udig.catalog.internal.wfs.WFSServiceExtension;
import net.refractions.udig.catalog.internal.wfs.WFSServiceImpl;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;

public class WFSConnectionFactory
extends UDIGConnectionFactory {
    public boolean canProcess(Object data) {
        if (data instanceof IResolve) {
            IResolve resolve = (IResolve)data;
            return resolve.canResolve(WFSDataStore.class);
        }
        return this.toCapabilitiesURL(data) != null;
    }

    public Map<String, Serializable> createConnectionParameters(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof WFSServiceImpl) {
            IService wfs = (IService)data;
            return wfs.getConnectionParams();
        }
        URL url = this.toCapabilitiesURL(data);
        if (url != null) {
            List list = CatalogPlugin.getDefault().getLocalCatalog().find(url, null);
            for (IResolve resolve : list) {
                if (resolve instanceof WFSServiceImpl) {
                    IService wfs = (IService)resolve;
                    return wfs.getConnectionParams();
                }
                if (!(resolve instanceof WFSGeoResourceImpl)) continue;
                WFSGeoResourceImpl layer = (WFSGeoResourceImpl)resolve;
                try {
                    IService wfs = (IService)layer.parent(null);
                    return wfs.getConnectionParams();
                }
                catch (IOException iOException) {
                    WFSConnectionFactory.checkedURL(layer.getIdentifier());
                }
            }
            return this.createParams(url);
        }
        return Collections.emptyMap();
    }

    public URL createConnectionURL(Object context) {
        return null;
    }

    URL toCapabilitiesURL(Object data) {
        if (data instanceof IResolve) {
            return this.toCapabilitiesURL((IResolve)data);
        }
        if (data instanceof URL) {
            return this.toCapabilitiesURL((URL)data);
        }
        if (ID.cast((Object)data) != null) {
            return ID.cast((Object)data).toURL();
        }
        return null;
    }

    protected URL toCapabilitiesURL(IResolve resolve) {
        if (resolve instanceof IService) {
            return this.toCapabilitiesURL((IService)resolve);
        }
        return this.toCapabilitiesURL(resolve.getIdentifier());
    }

    protected URL toCapabilitiesURL(IService resolve) {
        if (resolve instanceof WFSServiceImpl) {
            return this.toCapabilitiesURL((WFSServiceImpl)resolve);
        }
        return this.toCapabilitiesURL(resolve.getIdentifier());
    }

    protected URL toCapabilitiesURL(WFSServiceImpl wfs) {
        return wfs.getIdentifier();
    }

    protected URL toCapabilitiesURL(URL url) {
        String protocol;
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        String query = url.getQuery();
        String string = protocol = url.getProtocol() != null ? url.getProtocol().toLowerCase() : null;
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            return null;
        }
        if (query != null && query.toLowerCase().indexOf("service=wfs") != -1) {
            return WFSConnectionFactory.checkedURL(url);
        }
        if (path != null && path.toLowerCase().indexOf("geoserver/wfs") != -1) {
            return WFSConnectionFactory.checkedURL(url);
        }
        if (url.toExternalForm().toLowerCase().indexOf("WFS") != -1) {
            return WFSConnectionFactory.checkedURL(url);
        }
        return null;
    }

    private static final URL checkedURL(URL url) {
        String check = url.toExternalForm();
        int hash = check.indexOf(35);
        if (hash == -1) {
            return url;
        }
        try {
            return new URL(check.substring(0, hash));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected Map<String, Serializable> createParams(URL url) {
        WFSServiceExtension factory = new WFSServiceExtension();
        Map<String, Serializable> params = factory.createParams(url);
        if (params != null) {
            return params;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put(WFSDataStoreFactory.URL.key, url);
        return params2;
    }
}

